/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Floater Bridge Network.
 *
 * The Initial Developer of the Original Code is
 * Geoff Pike <pike@EECS.Berkeley.EDU>.
 * Portions created by the Initial Developer are Copyright (C) 1996-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the
 * terms of either the GNU General Public License Version 2 or later
 * (the "GPL"), in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of the MPL,
 * indicate your decision by deleting the provisions above and replace
 * them with the notice and other provisions required by the GPL. If
 * you do not delete the provisions above, a recipient may use your
 * version of this file under the terms of either the MPL or the GPL.
 * ***** END LICENSE BLOCK ***** */
#include "floater.h"

#if TCL_IN_C

char *tcl2cfilenames[] = {
"floatert.tcl", "ls.tcl"};
char *tcl2cfiles[] = {
"# 1 \"/home/lex/floater/work/tclcode/floatert.deq\"\n"
"# 1 \"<built-in>\"\n"
"# 1 \"<command line>\"\n"
"# 1 \"/home/lex/floater/work/tclcode/floatert.deq\"\n"
"# 35 \"/home/lex/floater/work/tclcode/floatert.deq\"\n"
"# 1 \"/home/lex/floater/work/tclcode/floater.deq\" 1\n"
"# 41 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"pruc update {} {\n"
"puts update called!!!\n"
"}\n"
"# 61 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"if {[info tclversion] < 8.0} {\n"
"    puts stderr \"You have compiled Floater with Tcl [info tclversion]\"\n"
"    puts stderr \"You must recompile with Tcl 8.0 or higher\"\n"
"    exit 1\n"
"}\n"
"# 74 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"set debugstartup 0\n"
"\n"
"if $debugstartup {\n"
"\n"
"\n"
"    proc line args {\n"
"\n"
"\n"
"\n"
"\n"
"        puts \"Line: $args\"\n"
"\n"
"    }\n"
"} else {\n"
"    proc line args {}\n"
"}\n"
"# 149 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"# 1 \"/home/lex/floater/work/tclcode/gset.deq\" 1\n"
"# 35 \"/home/lex/floater/work/tclcode/gset.deq\"\n"
"proc tryset {a b} {\n"
"    if {[set x [string first \"(\" $a]] == -1} {\n"
"	global $a\n"
"    } else {\n"
"	global [string range $a 0 [incr x -1]]\n"
"    }\n"
"\n"
"    if [catch {set $a}] {set $a $b}\n"
"}\n"
"\n"
"\n"
"proc gset {a {b salami_on_rye}} {\n"
"    if {[set x [string first \"(\" $a]] == -1} {\n"
"	global $a\n"
"    } else {\n"
"	global [string range $a 0 [incr x -1]]\n"
"    }\n"
"\n"
"    if ![string compare $b salami_on_rye] {set $a} {set $a $b}\n"
"}\n"
"\n"
"\n"
"proc gunset {a} {\n"
"    if {[set x [string first \"(\" $a]] == -1} {\n"
"	global $a\n"
"    } else {\n"
"	global [string range $a 0 [incr x -1]]\n"
"    }\n"
"\n"
"    unset $a\n"
"}\n"
"# 150 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after gset\n"
"\n"
"\n"
"\n"
"\n"
"gset floater_version {Floater 1.4.11}\n"
"\n"
"# 1 \"/home/lex/floater/work/tclcode/errorhandle.deq\" 1\n"
"# 34 \"/home/lex/floater/work/tclcode/errorhandle.deq\"\n"
"proc bgerror {m} {catch {debugmsg $m}}\n"
"# 158 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after errorhandle\n"
"# 1 \"/home/lex/floater/work/tclcode/files.deq\" 1\n"
"# 38 \"/home/lex/floater/work/tclcode/files.deq\"\n"
"proc lseenhand {root number scoring} {\n"
"    global seenhands maxseenhand 	Nseen$scoring Sseen$scoring Eseen$scoring Wseen$scoring\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"    set seen seen\n"
"    foreach d {N S E W} {\n"
"	if [info exists $d$seen$scoring] {\n"
"	eval \"set old $$d$seen$scoring\"\n"
"	set $d$seen$scoring $old$number-\n"
"\n"
"	}\n"
"    }\n"
"    set seenhands($root,$number) 1\n"
"    if [info exists maxseenhand($root)] 	{if {$maxseenhand($root) > $number} return}\n"
"\n"
"    set maxseenhand($root) $number\n"
"}\n"
"\n"
"\n"
"proc seen {root {silent 0}} {\n"
"    global seenhands maxseenhand youveseen\n"
"\n"
"    if ![info exists maxseenhand($root)] {\n"
"	if {$youveseen && !$silent} 		{talkmsg \"You haven't seen any hands from $root\"}\n"
"\n"
"	return \"\"\n"
"    }\n"
"    set m $maxseenhand($root)\n"
"    set s \"\"\n"
"    set t \"\"\n"
"    for {set i 1} {$i <= $m} {incr i} {\n"
"	if [info exists seenhands($root,$i)] {\n"
"	append s \"$i-\"\n"
"	append t \"$i \"\n"
"	}\n"
"    }\n"
"    if {$youveseen && !$silent} {talkmsg \"From set $root, you've seen: $t\"}\n"
"    if {$silent} {return $t} {return $s}\n"
"}\n"
"# 91 \"/home/lex/floater/work/tclcode/files.deq\"\n"
"set slash \"/\"\n"
"\n"
"\n"
"proc floater_mkdir {s} {\n"
"    file mkdir $s\n"
"}\n"
"\n"
"proc floater_delete {s} {\n"
"    file delete $s\n"
"}\n"
"\n"
"proc append_to_file {fileName line} {\n"
"    set file [open $fileName a]\n"
"    puts $file $line\n"
"    close $file\n"
"}\n"
"\n"
"if [info exists env(FLOATER_DIR)] {\n"
"    tryset floaterdir $env(FLOATER_DIR)\n"
"}\n"
"\n"
"tryset floaterdir [set env(HOME)]${slash}.floater\n"
"\n"
"tryset startupfile $floaterdir${slash}startup.tcl\n"
"tryset seenfileroot $floaterdir${slash}seenhands\n"
"\n"
"if {[file exists $floaterdir] == 0} {catch {floater_mkdir $floaterdir}}\n"
"if {[file exists $seenfileroot] == 0} {catch {floater_mkdir $seenfileroot}}\n"
"\n"
"\n"
"\n"
"proc tclfiles {dir {recurse 1}} {\n"
"    global slash\n"
"\n"
"    set file_bases [glob -nocomplain -path \"$dir$slash\" *.tcl]\n"
"\n"
"    set files \"\"\n"
"    foreach base $file_bases {\n"
"        lappend files [file join $dir $base]\n"
"    }\n"
"\n"
"    return $files\n"
"}\n"
"\n"
"proc source_all_tclfiles {dir {recurse 1}} {\n"
"    global startupfile\n"
"\n"
"    foreach file [tclfiles $dir $recurse] {\n"
"	if {$file != $startupfile} {\n"
"	if [catch {source $file} err] {\n"
"		puts stderr $err\n"
"	}\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"proc setprioruse {name} {\n"
"    global usedname startupfile\n"
"\n"
"    if [info exists usedname($name)] return\n"
"    set \"usedname($name)\" 1\n"
"    catch {\n"
"        append_to_file $startupfile \\\"set usedname($name)\\\" 1\"\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set seenname _everyone_\n"
"\n"
"proc seenfile {root} {\n"
"    global seenfileroot seenname slash\n"
"    return $seenfileroot$slash$seenname$slash$root.tcl\n"
"}\n"
"\n"
"\n"
"proc seenhand {root number scoring} {\n"
"    global seenhands\n"
"\n"
"\n"
"    if [info exists seenhands($root,$number)] return\n"
"    lseenhand $root $number $scoring\n"
"\n"
"    if [catch {append_to_file [seenfile $root] \"lseenhand $root $number $scoring\"}] {\n"
"	floatererror \"Floater error: unable to make permanent note of what hands you've seen!\"\n"
"	set e1 \"Floater error: unable to write to file \"\n"
"	set e2 [seenfile $root]\n"
"	floatererror \"$e1$e2\"\n"
"    }\n"
"}\n"
"\n"
"proc loadseen {} {\n"
"    global seenhands maxseenhand seenname seenfileroot 	globaldate previousglobaldate slash\n"
"\n"
"\n"
"    debugmsg \"loadseen with seenname=$seenname\"\n"
"\n"
"\n"
"    if {[info exists globaldate] && [info exists previousglobaldate]} {\n"
"	cleanseen $seenfileroot${slash}$seenname $globaldate $previousglobaldate\n"
"	if {$seenname != \"_everyone_\"} {\n"
"	cleanseen $seenfileroot${slash}_everyone_ $globaldate $previousglobaldate\n"
"	}\n"
"    }\n"
"\n"
"    catch {unset seenhands; unset maxseenhand}\n"
"    if {[file exists $seenfileroot${slash}_everyone_] == 0} 	{catch {floater_mkdir $seenfileroot${slash}_everyone_}}\n"
"\n"
"    if {[file exists $seenfileroot${slash}$seenname] == 0} 	{catch {floater_mkdir $seenfileroot${slash}$seenname}}\n"
"\n"
"    source_all_tclfiles $seenfileroot${slash}_everyone_\n"
"\n"
"\n"
"    source_all_tclfiles $seenfileroot 0\n"
"\n"
"    if {$seenname != \"_everyone_\"} 	{source_all_tclfiles $seenfileroot${slash}$seenname}\n"
"\n"
"}\n"
"\n"
"proc cleanseen {dir except1 except2} {\n"
"    global slash\n"
"    foreach file [tclfiles $dir 0] {\n"
"	if {![string match \"*$except1*\" $file]\n"
"	&& ![string match \"*$except2*\" $file]} {\n"
"		floater_delete $file\n"
"	}\n"
"    }\n"
"}\n"
"# 231 \"/home/lex/floater/work/tclcode/files.deq\"\n"
"proc validfile {filename} {\n"
"    global floaterdir slash\n"
"\n"
"    regexp $floaterdir${slash}.* [file dirname $filename]${slash}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"package require http\n"
"\n"
"proc nop args {}\n"
"\n"
"proc http_done {token} {\n"
"    global token_to_file token_to_cmd\n"
"    upvar #0 $token state\n"
"    catch { close $token_to_file($token) }\n"
"    catch { unset $token_to_file($token) }\n"
"    if {$state(status) == \"ok\"} {\n"
"	catch { eval $token_to_cmd($token) }\n"
"    }\n"
"    catch { unset $token_to_cmd($token) }\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc http_fetch_to_file {url finalname {tmpfile \"\"}} {\n"
"    global token_to_file token_to_cmd\n"
"\n"
"    if {$tmpfile == \"\"} {\n"
"	set filename $finalname\n"
"    } else {\n"
"	set filename $tmpfile\n"
"    }\n"
"    set f [open $filename w]\n"
"    set token [::http::geturl $url -channel $f -command http_done]\n"
"    set token_to_filename($token) $f\n"
"    if {$tmpfile != \"\"} {\n"
"	set token_to_cmd($token) \"file rename \\{$tmpfile\\} \\{$finalname\\}\"\n"
"    }\n"
"}\n"
"# 160 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after files\n"
"# 1 \"/home/lex/floater/work/tclcode/connect.deq\" 1\n"
"# 34 \"/home/lex/floater/work/tclcode/connect.deq\"\n"
"gset conn_number 0\n"
"\n"
"gset default_handshake \"Floater 'shake\"\n"
"gset you_may_host \"you may host\"\n"
"gset silent_handshake \"Floater silent 'shake\"\n"
"gset test_connection_succeeded 0\n"
"\n"
"\n"
"proc FloaterListen {{port 0}} {\n"
"    global localIPaddr0\n"
"    PortNumber [socket -server FloaterAcceptConnection $port]\n"
"}\n"
"\n"
"proc FloaterAcceptConnection {sock addr port} {\n"
"    debugmsg \"AcceptConnection $sock $addr $port\"\n"
"    return [FloaterNewSocket $sock]\n"
"}\n"
"\n"
"proc FloaterReadable {conn sock} {\n"
"    global expecting_handshake floater_silent default_handshake you_may_host\n"
"\n"
"    debugmsg \"FloaterReadable $conn $sock\"\n"
"    set s [gets $sock]\n"
"    debugmsg \"Got $s from $conn\"\n"
"    if [info exists expecting_handshake($conn)] {\n"
"	debugmsg \"expecting handshake\"\n"
"	if {$s == $default_handshake} {\n"
"	\n"
"	unset expecting_handshake($conn)\n"
"	return\n"
"	} elseif {$s == $you_may_host} {\n"
"	\n"
"	unset expecting_handshake($conn)\n"
"	gset test_connection_succeeded 1\n"
"	return\n"
"	} else {\n"
"	if $floater_silent {\n"
"		global silent_handshake\n"
"		if {$s == $silent_handshake} {\n"
"		global floater_silent_conns\n"
"		set floater_silent_conns($conn) 1\n"
"		unset expecting_handshake($conn)\n"
"		return\n"
"		}\n"
"	}\n"
"	debugmsg \"Expecting handshake but got $s\"\n"
"	}\n"
"	\n"
"	FloaterClose $conn\n"
"	return\n"
"    }\n"
"\n"
"    if {$s == \"\" && [eof $sock]} 	{FloaterClose $conn} 	{debugmsg \"received $s\"; floaterreceive $s $conn}\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"proc FloaterWritable {conn sock} {\n"
"    debugmsg \"FloaterWritable $conn $sock\"\n"
"}\n"
"\n"
"\n"
"proc FloaterConnect {addr port {handshake default}} {\n"
"    debugmsg \"FloaterConnect $addr $port\"\n"
"    FloaterNewSocket [socket $addr $port] $handshake\n"
"}\n"
"\n"
"\n"
"\n"
"proc FloaterNewSocket {sock {handshake default}} {\n"
"    global sock_to_conn conn_to_sock conn_number expecting_handshake\n"
"\n"
"    if {$handshake == \"default\"} {\n"
"	global default_handshake\n"
"	set handshake $default_handshake\n"
"    }\n"
"    debugmsg \"NewSocket $sock $handshake\"\n"
"    fconfigure $sock -blocking 0 -buffering line\n"
"    set conn [incr conn_number]\n"
"    set sock_to_conn($sock) $conn\n"
"    set conn_to_sock($conn) $sock\n"
"    set expecting_handshake($conn) 1\n"
"\n"
"    fileevent $sock readable \"FloaterReadable $conn $sock\"\n"
"    if {$handshake != \"\"} {\n"
"	puts $sock $handshake\n"
"	debugmsg \"sent handshake ($handshake) to $conn\"\n"
"    }\n"
"    return $conn\n"
"}\n"
"\n"
"proc PortNumber {sock} {\n"
"    lindex [fconfigure $sock -sockname] 2\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"tryset failedsendwait 3000\n"
"\n"
"\n"
"\n"
"proc FloaterSend {to msg} {\n"
"    global conn_to_sock\n"
"\n"
"    catch {set s $conn_to_sock($to)}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"    debugmsg \"Send $to ($s) $msg\"\n"
"\n"
"    if [catch {puts $s $msg}] {\n"
"	global failedsendwait\n"
"\n"
"	after $failedsendwait 	debugmsg \\\"Closing $s due to failed send\\\"; 	catch \\{close $s\\}\n"
"\n"
"\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"proc FloaterCloseName {name} {\n"
"    global name_to_conn\n"
"\n"
"    set s \"<none>\"\n"
"    catch {set s $name_to_conn($name)}\n"
"    debugmsg \"FloaterCloseName $name ($s)\"\n"
"    if {$s != \"<none>\"} {\n"
"	catch {\n"
"	FloaterClose $s\n"
"	unset \"name_to_conn($name)\"\n"
"	}\n"
"    }\n"
"}\n"
"# 224 \"/home/lex/floater/work/tclcode/connect.deq\"\n"
"proc bogusIP {s} {\n"
"    if {$s == \"localhost\"} { return 1 }\n"
"    if {$s == \"localhost.localdomain\"} { return 1 }\n"
"    if {$s == \"127.0.0.1\"} { return 1 }\n"
"    if {$s == \"0.0.0.0\"} { return 1 }\n"
"    if {$s == \"255.255.255.255\"} { return 1 }\n"
"    return 0\n"
"}\n"
"\n"
"proc filter_and_join {s filter joiner} {\n"
"    set result \"\"\n"
"    foreach k $s {\n"
"	if ![$filter $k] { lappend result $k }\n"
"    }\n"
"    join $result $joiner\n"
"}\n"
"\n"
"proc nothing {sock ipaddr port} {}\n"
"\n"
"\n"
"set localIPaddr 127.0.0.1\n"
"\n"
"catch {\n"
"    set server [socket -server nothing 0]\n"
"    set socket [socket [info hostname] [PortNumber $server]]\n"
"    set localIPaddr0 [lindex [fconfigure $socket -peername] 0]\n"
"    set localIPaddr1 [lindex [fconfigure $socket -peername] 1]\n"
"    catch {close $socket}\n"
"    catch {close $server}\n"
"    set localIPaddr 	[filter_and_join \"$localIPaddr0 $localIPaddr1\" bogusIP !]\n"
"\n"
"\n"
"    if {$localIPaddr == \"\"} {\n"
"        set localIPaddr 127.0.0.1\n"
"    }\n"
"\n"
"}\n"
"# 162 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after connect\n"
"# 1 \"/home/lex/floater/work/tclcode/mail.deq\" 1\n"
"# 43 \"/home/lex/floater/work/tclcode/mail.deq\"\n"
"set to_be_emailed_n 0\n"
"\n"
"\n"
"proc emailresult {result} {\n"
"    global resultparser errorstring to_be_emailed to_be_emailed_n\n"
"\n"
"    if {[set q [what_to_send]] != \"\"} {set result \"$result\\nMagic cookie!$q\"}\n"
"    if {$result == \"\"} {return 0}\n"
"    set r [\n"
"\n"
"    pseudomail $result $resultparser\n"
"\n"
"\n"
"\n"
"    ]\n"
"    if $r {\n"
"	\n"
"	set to_be_emailed([incr to_be_emailed_n]) $result\n"
"    } else {\n"
"	while {$to_be_emailed_n > 0} {\n"
"	\n"
"	\n"
"	\n"
"	\n"
"	\n"
"	set result $to_be_emailed($to_be_emailed_n)\n"
"	unset to_be_emailed($to_be_emailed_n)\n"
"	incr to_be_emailed_n -1\n"
"	if [emailresult $result] {return $r}\n"
"	}\n"
"    }\n"
"    return $r\n"
"}\n"
"\n"
"proc emailseens {} {emailresult {}}\n"
"\n"
"\n"
"proc mail_bug {bug} {\n"
"    global bugmail errorstring\n"
"\n"
"\n"
"    pseudomail $bug $bugmail\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"proc pseudomail {what where} {\n"
"    global errorstring pseudomailaddr pseudomailport\n"
"\n"
"    catch {\n"
"	set conn [FloaterConnect $pseudomailaddr $pseudomailport]\n"
"	FloaterSend $conn ozzie_and_harriet\n"
"	FloaterSend $conn \"$where $what\"\n"
"	FloaterClose $conn\n"
"    } errorstring\n"
"}\n"
"# 164 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after mail\n"
"# 1 \"/home/lex/floater/work/tclcode/seen.deq\" 1\n"
"# 34 \"/home/lex/floater/work/tclcode/seen.deq\"\n"
"proc query_have_seen {name set} {\n"
"    set x \"$name $set\"\n"
"    global $x\n"
"    array names $x\n"
"}\n"
"\n"
"\n"
"proc a_h_s {name set num} {\n"
"    global \"have_seen_sets_$name\"\n"
"    eval \"set \\\"have_seen_sets_$name\\($set)\\\" 1\"\n"
"\n"
"    set x \"$name $set\"\n"
"    global $x\n"
"    eval \"set \\{$x\\($num)\\} 1\"\n"
"}\n"
"\n"
"proc have_seen_sets {name} {\n"
"    global \"have_seen_sets_$name\"\n"
"    array names \"have_seen_sets_$name\"\n"
"}\n"
"\n"
"proc discard_data_except_from {date} {\n"
"    global nameset\n"
"\n"
"    foreach name $nameset {\n"
"	global \"have_seen_sets_$name\"\n"
"	foreach set [have_seen_sets $name] {\n"
"	if ![string match *$date* $set] {\n"
"		set x \"$name $set\"\n"
"		global $x\n"
"		unset $x\n"
"\n"
"		eval \"unset \\\"have_seen_sets_$name\\($set)\\\"\"\n"
"\n"
"	}\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"set to_be_sent_n 0\n"
"\n"
"proc want_to_send {name set num} {\n"
"    global to_be_sent_n to_be_sent\n"
"\n"
"\n"
"    set to_be_sent([incr to_be_sent_n]) $name\n"
"    set to_be_sent([incr to_be_sent_n]) $set\n"
"    set to_be_sent([incr to_be_sent_n]) $num\n"
"}\n"
"\n"
"\n"
"\n"
"proc what_to_send {} {\n"
"    global to_be_sent_n to_be_sent\n"
"\n"
"    if {$to_be_sent_n == 0} {return \"\"}\n"
"    set s $to_be_sent(1)\n"
"    for {set i 2} {$i <= $to_be_sent_n} {incr i} {\n"
"	set s \"$s	$to_be_sent($i)\"\n"
"	unset to_be_sent($i)\n"
"    }\n"
"    set to_be_sent_n 0\n"
"    return $s\n"
"}\n"
"# 166 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after seen\n"
"# 1 \"/home/lex/floater/work/tclcode/logo.deq\" 1\n"
"# 37 \"/home/lex/floater/work/tclcode/logo.deq\"\n"
"global floater_version\n"
"tryset about_text \"version [lrange $floater_version 1 end]\n"
"\n"
"http:\\/\\/www.floater.org\n"
"This is free software.\"\n"
"\n"
"\n"
"\n"
"proc about {{timeout 0}} {\n"
"    global about_text\n"
"    talkmsg \"About Floater:\\n$about_text\"\n"
"}\n"
"# 168 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after logo\n"
"# 1 \"/home/lex/floater/work/tclcode/texts.deq\" 1\n"
"# 34 \"/home/lex/floater/work/tclcode/texts.deq\"\n"
"# 1 \"/home/lex/floater/work/tclcode/the_texts.deq\" 1\n"
"# 38 \"/home/lex/floater/work/tclcode/the_texts.deq\"\n"
"gset Confusing {\n"
"Floater relies on self-alerts. If playing formally, you are\n"
"expected to explain your bidding and carding agreements as carefully\n"
"as you would at a tournament. In any case, you alert by using the\n"
"commands `alert,' `redalert' and `explain.' You should alert\n"
"at the same time or before you take an alertable action. There are no\n"
"fixed rules as to what agreements are alertable---use your judgment\n"
"and do unto others as you would have them do unto you.\n"
"\n"
"The easy way to alert an action is to type \"!\" (or \"!!\" for redalert)\n"
"on the same line as the command to perform that action---and\n"
"optionally put an explanation at the end. For example, you could type\n"
"\"2D!weak two in either major\" to bid and alert your own bid\n"
"simultaneously. See also the help on `alert,' `redalert' and\n"
"`explain.'\n"
"\n"
"If you are using the graphical user interface, you may click on the\n"
"\"Alert\" or \"Redalert\" checkboxes BEFORE clicking on the call you wish\n"
"to make. For example, clicking on \"1C\" when the \"Alert\" checkbox is\n"
"highlighted will have the same effect as typing \"1C!\" on the keyboard.\n"
"\n"
"Everyone at the table except partner sees your alerts.\n"
"}\n"
"\n"
"gset Copyright {\n"
"Floater is released under either the Mozilla Public License 1.1, or the\n"
"GNU General Public License, at the user's choice. Both of these\n"
"licenses are below.\n"
"\n"
"\n"
"\n"
"                          MOZILLA PUBLIC LICENSE\n"
"                                Version 1.1\n"
"\n"
"                              ---------------\n"
"\n"
"1. Definitions.\n"
"\n"
"     1.0.1. \"Commercial Use\" means distribution or otherwise making the\n"
"     Covered Code available to a third party.\n"
"\n"
"     1.1. \"Contributor\" means each entity that creates or contributes to\n"
"     the creation of Modifications.\n"
"\n"
"     1.2. \"Contributor Version\" means the combination of the Original\n"
"     Code, prior Modifications used by a Contributor, and the Modifications\n"
"     made by that particular Contributor.\n"
"\n"
"     1.3. \"Covered Code\" means the Original Code or Modifications or the\n"
"     combination of the Original Code and Modifications, in each case\n"
"     including portions thereof.\n"
"\n"
"     1.4. \"Electronic Distribution Mechanism\" means a mechanism generally\n"
"     accepted in the software development community for the electronic\n"
"     transfer of data.\n"
"\n"
"     1.5. \"Executable\" means Covered Code in any form other than Source\n"
"     Code.\n"
"\n"
"     1.6. \"Initial Developer\" means the individual or entity identified\n"
"     as the Initial Developer in the Source Code notice required by Exhibit\n"
"     A.\n"
"\n"
"     1.7. \"Larger Work\" means a work which combines Covered Code or\n"
"     portions thereof with code not governed by the terms of this License.\n"
"\n"
"     1.8. \"License\" means this document.\n"
"\n"
"     1.8.1. \"Licensable\" means having the right to grant, to the maximum\n"
"     extent possible, whether at the time of the initial grant or\n"
"     subsequently acquired, any and all of the rights conveyed herein.\n"
"\n"
"     1.9. \"Modifications\" means any addition to or deletion from the\n"
"     substance or structure of either the Original Code or any previous\n"
"     Modifications. When Covered Code is released as a series of files, a\n"
"     Modification is:\n"
"          A. Any addition to or deletion from the contents of a file\n"
"          containing Original Code or previous Modifications.\n"
"\n"
"          B. Any new file that contains any part of the Original Code or\n"
"          previous Modifications.\n"
"\n"
"     1.10. \"Original Code\" means Source Code of computer software code\n"
"     which is described in the Source Code notice required by Exhibit A as\n"
"     Original Code, and which, at the time of its release under this\n"
"     License is not already Covered Code governed by this License.\n"
"\n"
"     1.10.1. \"Patent Claims\" means any patent claim(s), now owned or\n"
"     hereafter acquired, including without limitation, method, process,\n"
"     and apparatus claims, in any patent Licensable by grantor.\n"
"\n"
"     1.11. \"Source Code\" means the preferred form of the Covered Code for\n"
"     making modifications to it, including all modules it contains, plus\n"
"     any associated interface definition files, scripts used to control\n"
"     compilation and installation of an Executable, or source code\n"
"     differential comparisons against either the Original Code or another\n"
"     well known, available Covered Code of the Contributor's choice. The\n"
"     Source Code can be in a compressed or archival form, provided the\n"
"     appropriate decompression or de-archiving software is widely available\n"
"     for no charge.\n"
"\n"
"     1.12. \"You\" (or \"Your\") means an individual or a legal entity\n"
"     exercising rights under, and complying with all of the terms of, this\n"
"     License or a future version of this License issued under Section 6.1.\n"
"     For legal entities, \"You\" includes any entity which controls, is\n"
"     controlled by, or is under common control with You. For purposes of\n"
"     this definition, \"control\" means (a) the power, direct or indirect,\n"
"     to cause the direction or management of such entity, whether by\n"
"     contract or otherwise, or (b) ownership of more than fifty percent\n"
"     (50%) of the outstanding shares or beneficial ownership of such\n"
"     entity.\n"
"\n"
"2. Source Code License.\n"
"\n"
"     2.1. The Initial Developer Grant.\n"
"     The Initial Developer hereby grants You a world-wide, royalty-free,\n"
"     non-exclusive license, subject to third party intellectual property\n"
"     claims:\n"
"          (a) under intellectual property rights (other than patent or\n"
"          trademark) Licensable by Initial Developer to use, reproduce,\n"
"          modify, display, perform, sublicense and distribute the Original\n"
"          Code (or portions thereof) with or without Modifications, and/or\n"
"          as part of a Larger Work; and\n"
"\n"
"          (b) under Patents Claims infringed by the making, using or\n"
"          selling of Original Code, to make, have made, use, practice,\n"
"          sell, and offer for sale, and/or otherwise dispose of the\n"
"          Original Code (or portions thereof).\n"
"\n"
"          (c) the licenses granted in this Section 2.1(a) and (b) are\n"
"          effective on the date Initial Developer first distributes\n"
"          Original Code under the terms of this License.\n"
"\n"
"          (d) Notwithstanding Section 2.1(b) above, no patent license is\n"
"          granted: 1) for code that You delete from the Original Code; 2)\n"
"          separate from the Original Code; or 3) for infringements caused\n"
"          by: i) the modification of the Original Code or ii) the\n"
"          combination of the Original Code with other software or devices.\n"
"\n"
"     2.2. Contributor Grant.\n"
"     Subject to third party intellectual property claims, each Contributor\n"
"     hereby grants You a world-wide, royalty-free, non-exclusive license\n"
"\n"
"          (a) under intellectual property rights (other than patent or\n"
"          trademark) Licensable by Contributor, to use, reproduce, modify,\n"
"          display, perform, sublicense and distribute the Modifications\n"
"          created by such Contributor (or portions thereof) either on an\n"
"          unmodified basis, with other Modifications, as Covered Code\n"
"          and/or as part of a Larger Work; and\n"
"\n"
"          (b) under Patent Claims infringed by the making, using, or\n"
"          selling of Modifications made by that Contributor either alone\n"
"          and/or in combination with its Contributor Version (or portions\n"
"          of such combination), to make, use, sell, offer for sale, have\n"
"          made, and/or otherwise dispose of: 1) Modifications made by that\n"
"          Contributor (or portions thereof); and 2) the combination of\n"
"          Modifications made by that Contributor with its Contributor\n"
"          Version (or portions of such combination).\n"
"\n"
"          (c) the licenses granted in Sections 2.2(a) and 2.2(b) are\n"
"          effective on the date Contributor first makes Commercial Use of\n"
"          the Covered Code.\n"
"\n"
"          (d) Notwithstanding Section 2.2(b) above, no patent license is\n"
"          granted: 1) for any code that Contributor has deleted from the\n"
"          Contributor Version; 2) separate from the Contributor Version;\n"
"          3) for infringements caused by: i) third party modifications of\n"
"          Contributor Version or ii) the combination of Modifications made\n"
"          by that Contributor with other software (except as part of the\n"
"          Contributor Version) or other devices; or 4) under Patent Claims\n"
"          infringed by Covered Code in the absence of Modifications made by\n"
"          that Contributor.\n"
"\n"
"3. Distribution Obligations.\n"
"\n"
"     3.1. Application of License.\n"
"     The Modifications which You create or to which You contribute are\n"
"     governed by the terms of this License, including without limitation\n"
"     Section 2.2. The Source Code version of Covered Code may be\n"
"     distributed only under the terms of this License or a future version\n"
"     of this License released under Section 6.1, and You must include a\n"
"     copy of this License with every copy of the Source Code You\n"
"     distribute. You may not offer or impose any terms on any Source Code\n"
"     version that alters or restricts the applicable version of this\n"
"     License or the recipients' rights hereunder. However, You may include\n"
"     an additional document offering the additional rights described in\n"
"     Section 3.5.\n"
"\n"
"     3.2. Availability of Source Code.\n"
"     Any Modification which You create or to which You contribute must be\n"
"     made available in Source Code form under the terms of this License\n"
"     either on the same media as an Executable version or via an accepted\n"
"     Electronic Distribution Mechanism to anyone to whom you made an\n"
"     Executable version available; and if made available via Electronic\n"
"     Distribution Mechanism, must remain available for at least twelve (12)\n"
"     months after the date it initially became available, or at least six\n"
"     (6) months after a subsequent version of that particular Modification\n"
"     has been made available to such recipients. You are responsible for\n"
"     ensuring that the Source Code version remains available even if the\n"
"     Electronic Distribution Mechanism is maintained by a third party.\n"
"\n"
"     3.3. Description of Modifications.\n"
"     You must cause all Covered Code to which You contribute to contain a\n"
"     file documenting the changes You made to create that Covered Code and\n"
"     the date of any change. You must include a prominent statement that\n"
"     the Modification is derived, directly or indirectly, from Original\n"
"     Code provided by the Initial Developer and including the name of the\n"
"     Initial Developer in (a) the Source Code, and (b) in any notice in an\n"
"     Executable version or related documentation in which You describe the\n"
"     origin or ownership of the Covered Code.\n"
"\n"
"     3.4. Intellectual Property Matters\n"
"          (a) Third Party Claims.\n"
"          If Contributor has knowledge that a license under a third party's\n"
"          intellectual property rights is required to exercise the rights\n"
"          granted by such Contributor under Sections 2.1 or 2.2,\n"
"          Contributor must include a text file with the Source Code\n"
"          distribution titled \"LEGAL\" which describes the claim and the\n"
"          party making the claim in sufficient detail that a recipient will\n"
"          know whom to contact. If Contributor obtains such knowledge after\n"
"          the Modification is made available as described in Section 3.2,\n"
"          Contributor shall promptly modify the LEGAL file in all copies\n"
"          Contributor makes available thereafter and shall take other steps\n"
"          (such as notifying appropriate mailing lists or newsgroups)\n"
"          reasonably calculated to inform those who received the Covered\n"
"          Code that new knowledge has been obtained.\n"
"\n"
"          (b) Contributor APIs.\n"
"          If Contributor's Modifications include an application programming\n"
"          interface and Contributor has knowledge of patent licenses which\n"
"          are reasonably necessary to implement that API, Contributor must\n"
"          also include this information in the LEGAL file.\n"
"\n"
"               (c) Representations.\n"
"          Contributor represents that, except as disclosed pursuant to\n"
"          Section 3.4(a) above, Contributor believes that Contributor's\n"
"          Modifications are Contributor's original creation(s) and/or\n"
"          Contributor has sufficient rights to grant the rights conveyed by\n"
"          this License.\n"
"\n"
"     3.5. Required Notices.\n"
"     You must duplicate the notice in Exhibit A in each file of the Source\n"
"     Code. If it is not possible to put such notice in a particular Source\n"
"     Code file due to its structure, then You must include such notice in a\n"
"     location (such as a relevant directory) where a user would be likely\n"
"     to look for such a notice. If You created one or more Modification(s)\n"
"     You may add your name as a Contributor to the notice described in\n"
"     Exhibit A. You must also duplicate this License in any documentation\n"
"     for the Source Code where You describe recipients' rights or ownership\n"
"     rights relating to Covered Code. You may choose to offer, and to\n"
"     charge a fee for, warranty, support, indemnity or liability\n"
"     obligations to one or more recipients of Covered Code. However, You\n"
"     may do so only on Your own behalf, and not on behalf of the Initial\n"
"     Developer or any Contributor. You must make it absolutely clear than\n"
"     any such warranty, support, indemnity or liability obligation is\n"
"     offered by You alone, and You hereby agree to indemnify the Initial\n"
"     Developer and every Contributor for any liability incurred by the\n"
"     Initial Developer or such Contributor as a result of warranty,\n"
"     support, indemnity or liability terms You offer.\n"
"\n"
"     3.6. Distribution of Executable Versions.\n"
"     You may distribute Covered Code in Executable form only if the\n"
"     requirements of Section 3.1-3.5 have been met for that Covered Code,\n"
"     and if You include a notice stating that the Source Code version of\n"
"     the Covered Code is available under the terms of this License,\n"
"     including a description of how and where You have fulfilled the\n"
"     obligations of Section 3.2. The notice must be conspicuously included\n"
"     in any notice in an Executable version, related documentation or\n"
"     collateral in which You describe recipients' rights relating to the\n"
"     Covered Code. You may distribute the Executable version of Covered\n"
"     Code or ownership rights under a license of Your choice, which may\n"
"     contain terms different from this License, provided that You are in\n"
"     compliance with the terms of this License and that the license for the\n"
"     Executable version does not attempt to limit or alter the recipient's\n"
"     rights in the Source Code version from the rights set forth in this\n"
"     License. If You distribute the Executable version under a different\n"
"     license You must make it absolutely clear that any terms which differ\n"
"     from this License are offered by You alone, not by the Initial\n"
"     Developer or any Contributor. You hereby agree to indemnify the\n"
"     Initial Developer and every Contributor for any liability incurred by\n"
"     the Initial Developer or such Contributor as a result of any such\n"
"     terms You offer.\n"
"\n"
"     3.7. Larger Works.\n"
"     You may create a Larger Work by combining Covered Code with other code\n"
"     not governed by the terms of this License and distribute the Larger\n"
"     Work as a single product. In such a case, You must make sure the\n"
"     requirements of this License are fulfilled for the Covered Code.\n"
"\n"
"4. Inability to Comply Due to Statute or Regulation.\n"
"\n"
"     If it is impossible for You to comply with any of the terms of this\n"
"     License with respect to some or all of the Covered Code due to\n"
"     statute, judicial order, or regulation then You must: (a) comply with\n"
"     the terms of this License to the maximum extent possible; and (b)\n"
"     describe the limitations and the code they affect. Such description\n"
"     must be included in the LEGAL file described in Section 3.4 and must\n"
"     be included with all distributions of the Source Code. Except to the\n"
"     extent prohibited by statute or regulation, such description must be\n"
"     sufficiently detailed for a recipient of ordinary skill to be able to\n"
"     understand it.\n"
"\n"
"5. Application of this License.\n"
"\n"
"     This License applies to code to which the Initial Developer has\n"
"     attached the notice in Exhibit A and to related Covered Code.\n"
"\n"
"6. Versions of the License.\n"
"\n"
"     6.1. New Versions.\n"
"     Netscape Communications Corporation (\"Netscape\") may publish revised\n"
"     and/or new versions of the License from time to time. Each version\n"
"     will be given a distinguishing version number.\n"
"\n"
"     6.2. Effect of New Versions.\n"
"     Once Covered Code has been published under a particular version of the\n"
"     License, You may always continue to use it under the terms of that\n"
"     version. You may also choose to use such Covered Code under the terms\n"
"     of any subsequent version of the License published by Netscape. No one\n"
"     other than Netscape has the right to modify the terms applicable to\n"
"     Covered Code created under this License.\n"
"\n"
"     6.3. Derivative Works.\n"
"     If You create or use a modified version of this License (which you may\n"
"     only do in order to apply it to code which is not already Covered Code\n"
"     governed by this License), You must (a) rename Your license so that\n"
"     the phrases \"Mozilla\", \"MOZILLAPL\", \"MOZPL\", \"Netscape\",\n"
"     \"MPL\", \"NPL\" or any confusingly similar phrase do not appear in your\n"
"     license (except to note that your license differs from this License)\n"
"     and (b) otherwise make it clear that Your version of the license\n"
"     contains terms which differ from the Mozilla Public License and\n"
"     Netscape Public License. (Filling in the name of the Initial\n"
"     Developer, Original Code or Contributor in the notice described in\n"
"     Exhibit A shall not of themselves be deemed to be modifications of\n"
"     this License.)\n"
"\n"
"7. DISCLAIMER OF WARRANTY.\n"
"\n"
"     COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN \"AS IS\" BASIS,\n"
"     WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,\n"
"     WITHOUT LIMITATION, WARRANTIES THAT THE COVERED CODE IS FREE OF\n"
"     DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE OR NON-INFRINGING.\n"
"     THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED CODE\n"
"     IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT,\n"
"     YOU (NOT THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE\n"
"     COST OF ANY NECESSARY SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER\n"
"     OF WARRANTY CONSTITUTES AN ESSENTIAL PART OF THIS LICENSE. NO USE OF\n"
"     ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER THIS DISCLAIMER.\n"
"\n"
"8. TERMINATION.\n"
"\n"
"     8.1. This License and the rights granted hereunder will terminate\n"
"     automatically if You fail to comply with terms herein and fail to cure\n"
"     such breach within 30 days of becoming aware of the breach. All\n"
"     sublicenses to the Covered Code which are properly granted shall\n"
"     survive any termination of this License. Provisions which, by their\n"
"     nature, must remain in effect beyond the termination of this License\n"
"     shall survive.\n"
"\n"
"     8.2. If You initiate litigation by asserting a patent infringement\n"
"     claim (excluding declatory judgment actions) against Initial Developer\n"
"     or a Contributor (the Initial Developer or Contributor against whom\n"
"     You file such action is referred to as \"Participant\") alleging that:\n"
"\n"
"     (a) such Participant's Contributor Version directly or indirectly\n"
"     infringes any patent, then any and all rights granted by such\n"
"     Participant to You under Sections 2.1 and/or 2.2 of this License\n"
"     shall, upon 60 days notice from Participant terminate prospectively,\n"
"     unless if within 60 days after receipt of notice You either: (i)\n"
"     agree in writing to pay Participant a mutually agreeable reasonable\n"
"     royalty for Your past and future use of Modifications made by such\n"
"     Participant, or (ii) withdraw Your litigation claim with respect to\n"
"     the Contributor Version against such Participant. If within 60 days\n"
"     of notice, a reasonable royalty and payment arrangement are not\n"
"     mutually agreed upon in writing by the parties or the litigation claim\n"
"     is not withdrawn, the rights granted by Participant to You under\n"
"     Sections 2.1 and/or 2.2 automatically terminate at the expiration of\n"
"     the 60 day notice period specified above.\n"
"\n"
"     (b) any software, hardware, or device, other than such Participant's\n"
"     Contributor Version, directly or indirectly infringes any patent, then\n"
"     any rights granted to You by such Participant under Sections 2.1(b)\n"
"     and 2.2(b) are revoked effective as of the date You first made, used,\n"
"     sold, distributed, or had made, Modifications made by that\n"
"     Participant.\n"
"\n"
"     8.3. If You assert a patent infringement claim against Participant\n"
"     alleging that such Participant's Contributor Version directly or\n"
"     indirectly infringes any patent where such claim is resolved (such as\n"
"     by license or settlement) prior to the initiation of patent\n"
"     infringement litigation, then the reasonable value of the licenses\n"
"     granted by such Participant under Sections 2.1 or 2.2 shall be taken\n"
"     into account in determining the amount or value of any payment or\n"
"     license.\n"
"\n"
"     8.4. In the event of termination under Sections 8.1 or 8.2 above,\n"
"     all end user license agreements (excluding distributors and resellers)\n"
"     which have been validly granted by You or any distributor hereunder\n"
"     prior to termination shall survive termination.\n"
"\n"
"9. LIMITATION OF LIABILITY.\n"
"\n"
"     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, WHETHER TORT\n"
"     (INCLUDING NEGLIGENCE), CONTRACT, OR OTHERWISE, SHALL YOU, THE INITIAL\n"
"     DEVELOPER, ANY OTHER CONTRIBUTOR, OR ANY DISTRIBUTOR OF COVERED CODE,\n"
"     OR ANY SUPPLIER OF ANY OF SUCH PARTIES, BE LIABLE TO ANY PERSON FOR\n"
"     ANY INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY\n"
"     CHARACTER INCLUDING, WITHOUT LIMITATION, DAMAGES FOR LOSS OF GOODWILL,\n"
"     WORK STOPPAGE, COMPUTER FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER\n"
"     COMMERCIAL DAMAGES OR LOSSES, EVEN IF SUCH PARTY SHALL HAVE BEEN\n"
"     INFORMED OF THE POSSIBILITY OF SUCH DAMAGES. THIS LIMITATION OF\n"
"     LIABILITY SHALL NOT APPLY TO LIABILITY FOR DEATH OR PERSONAL INJURY\n"
"     RESULTING FROM SUCH PARTY'S NEGLIGENCE TO THE EXTENT APPLICABLE LAW\n"
"     PROHIBITS SUCH LIMITATION. SOME JURISDICTIONS DO NOT ALLOW THE\n"
"     EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO\n"
"     THIS EXCLUSION AND LIMITATION MAY NOT APPLY TO YOU.\n"
"\n"
"10. U.S. GOVERNMENT END USERS.\n"
"\n"
"     The Covered Code is a \"commercial item,\" as that term is defined in\n"
"     48 C.F.R. 2.101 (Oct. 1995), consisting of \"commercial computer\n"
"     software\" and \"commercial computer software documentation,\" as such\n"
"     terms are used in 48 C.F.R. 12.212 (Sept. 1995). Consistent with 48\n"
"     C.F.R. 12.212 and 48 C.F.R. 227.7202-1 through 227.7202-4 (June 1995),\n"
"     all U.S. Government End Users acquire Covered Code with only those\n"
"     rights set forth herein.\n"
"\n"
"11. MISCELLANEOUS.\n"
"\n"
"     This License represents the complete agreement concerning subject\n"
"     matter hereof. If any provision of this License is held to be\n"
"     unenforceable, such provision shall be reformed only to the extent\n"
"     necessary to make it enforceable. This License shall be governed by\n"
"     California law provisions (except to the extent applicable law, if\n"
"     any, provides otherwise), excluding its conflict-of-law provisions.\n"
"     With respect to disputes in which at least one party is a citizen of,\n"
"     or an entity chartered or registered to do business in the United\n"
"     States of America, any litigation relating to this License shall be\n"
"     subject to the jurisdiction of the Federal Courts of the Northern\n"
"     District of California, with venue lying in Santa Clara County,\n"
"     California, with the losing party responsible for costs, including\n"
"     without limitation, court costs and reasonable attorneys' fees and\n"
"     expenses. The application of the United Nations Convention on\n"
"     Contracts for the International Sale of Goods is expressly excluded.\n"
"     Any law or regulation which provides that the language of a contract\n"
"     shall be construed against the drafter shall not apply to this\n"
"     License.\n"
"\n"
"12. RESPONSIBILITY FOR CLAIMS.\n"
"\n"
"     As between Initial Developer and the Contributors, each party is\n"
"     responsible for claims and damages arising, directly or indirectly,\n"
"     out of its utilization of rights under this License and You agree to\n"
"     work with Initial Developer and Contributors to distribute such\n"
"     responsibility on an equitable basis. Nothing herein is intended or\n"
"     shall be deemed to constitute any admission of liability.\n"
"\n"
"13. MULTIPLE-LICENSED CODE.\n"
"\n"
"     Initial Developer may designate portions of the Covered Code as\n"
"     \"Multiple-Licensed\". \"Multiple-Licensed\" means that the Initial\n"
"     Developer permits you to utilize portions of the Covered Code under\n"
"     Your choice of the NPL or the alternative licenses, if any, specified\n"
"     by the Initial Developer in the file described in Exhibit A.\n"
"\n"
"EXHIBIT A -Mozilla Public License.\n"
"\n"
"     ``The contents of this file are subject to the Mozilla Public License\n"
"     Version 1.1 (the \"License\"); you may not use this file except in\n"
"     compliance with the License. You may obtain a copy of the License at\n"
"     http:slashslashwww.mozilla.org/MPL/\n"
"\n"
"     Software distributed under the License is distributed on an \"AS IS\"\n"
"     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the\n"
"     License for the specific language governing rights and limitations\n"
"     under the License.\n"
"\n"
"     The Original Code is ______________________________________.\n"
"\n"
"     The Initial Developer of the Original Code is ________________________.\n"
"     Portions created by ______________________ are Copyright (C) ______\n"
"     _______________________. All Rights Reserved.\n"
"\n"
"     Contributor(s): ______________________________________.\n"
"\n"
"     Alternatively, the contents of this file may be used under the terms\n"
"     of the _____ license (the \"[___] License\"), in which case the\n"
"     provisions of [______] License are applicable instead of those\n"
"     above. If you wish to allow use of your version of this file only\n"
"     under the terms of the [____] License and not to allow others to use\n"
"     your version of this file under the MPL, indicate your decision by\n"
"     deleting the provisions above and replace them with the notice and\n"
"     other provisions required by the [___] License. If you do not delete\n"
"     the provisions above, a recipient may use your version of this file\n"
"     under either the MPL or the [___] License.\"\n"
"\n"
"     [NOTE: The text of this Exhibit A may differ slightly from the text of\n"
"     the notices in the Source Code files of the Original Code. You should\n"
"     use the text of this Exhibit A rather than the text found in the\n"
"     Original Code Source Code for Your Modifications.]\n"
"\n"
"\n"
"\n"
"		GNU GENERAL PUBLIC LICENSE\n"
"		Version 2, June 1991\n"
"\n"
" Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"
"     59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n"
" Everyone is permitted to copy and distribute verbatim copies\n"
" of this license document, but changing it is not allowed.\n"
"\n"
"			Preamble\n"
"\n"
"  The licenses for most software are designed to take away your\n"
"freedom to share and change it. By contrast, the GNU General Public\n"
"License is intended to guarantee your freedom to share and change free\n"
"software--to make sure the software is free for all its users. This\n"
"General Public License applies to most of the Free Software\n"
"Foundation's software and to any other program whose authors commit to\n"
"using it. (Some other Free Software Foundation software is covered by\n"
"the GNU Library General Public License instead.) You can apply it to\n"
"your programs, too.\n"
"\n"
"  When we speak of free software, we are referring to freedom, not\n"
"price. Our General Public Licenses are designed to make sure that you\n"
"have the freedom to distribute copies of free software (and charge for\n"
"this service if you wish), that you receive source code or can get it\n"
"if you want it, that you can change the software or use pieces of it\n"
"in new free programs; and that you know you can do these things.\n"
"\n"
"  To protect your rights, we need to make restrictions that forbid\n"
"anyone to deny you these rights or to ask you to surrender the rights.\n"
"These restrictions translate to certain responsibilities for you if you\n"
"distribute copies of the software, or if you modify it.\n"
"\n"
"  For example, if you distribute copies of such a program, whether\n"
"gratis or for a fee, you must give the recipients all the rights that\n"
"you have. You must make sure that they, too, receive or can get the\n"
"source code. And you must show them these terms so they know their\n"
"rights.\n"
"\n"
"  We protect your rights with two steps: (1) copyright the software, and\n"
"(2) offer you this license which gives you legal permission to copy,\n"
"distribute and/or modify the software.\n"
"\n"
"  Also, for each author's protection and ours, we want to make certain\n"
"that everyone understands that there is no warranty for this free\n"
"software. If the software is modified by someone else and passed on, we\n"
"want its recipients to know that what they have is not the original, so\n"
"that any problems introduced by others will not reflect on the original\n"
"authors' reputations.\n"
"\n"
"  Finally, any free program is threatened constantly by software\n"
"patents. We wish to avoid the danger that redistributors of a free\n"
"program will individually obtain patent licenses, in effect making the\n"
"program proprietary. To prevent this, we have made it clear that any\n"
"patent must be licensed for everyone's free use or not licensed at all.\n"
"\n"
"  The precise terms and conditions for copying, distribution and\n"
"modification follow.\n"
"\n"
"		GNU GENERAL PUBLIC LICENSE\n"
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
"\n"
"  0. This License applies to any program or other work which contains\n"
"a notice placed by the copyright holder saying it may be distributed\n"
"under the terms of this General Public License. The \"Program\", below,\n"
"refers to any such program or work, and a \"work based on the Program\"\n"
"means either the Program or any derivative work under copyright law:\n"
"that is to say, a work containing the Program or a portion of it,\n"
"either verbatim or with modifications and/or translated into another\n"
"language. (Hereinafter, translation is included without limitation in\n"
"the term \"modification\".) Each licensee is addressed as \"you\".\n"
"\n"
"Activities other than copying, distribution and modification are not\n"
"covered by this License; they are outside its scope. The act of\n"
"running the Program is not restricted, and the output from the Program\n"
"is covered only if its contents constitute a work based on the\n"
"Program (independent of having been made by running the Program).\n"
"Whether that is true depends on what the Program does.\n"
"\n"
"  1. You may copy and distribute verbatim copies of the Program's\n"
"source code as you receive it, in any medium, provided that you\n"
"conspicuously and appropriately publish on each copy an appropriate\n"
"copyright notice and disclaimer of warranty; keep intact all the\n"
"notices that refer to this License and to the absence of any warranty;\n"
"and give any other recipients of the Program a copy of this License\n"
"along with the Program.\n"
"\n"
"You may charge a fee for the physical act of transferring a copy, and\n"
"you may at your option offer warranty protection in exchange for a fee.\n"
"\n"
"  2. You may modify your copy or copies of the Program or any portion\n"
"of it, thus forming a work based on the Program, and copy and\n"
"distribute such modifications or work under the terms of Section 1\n"
"above, provided that you also meet all of these conditions:\n"
"\n"
"    a) You must cause the modified files to carry prominent notices\n"
"    stating that you changed the files and the date of any change.\n"
"\n"
"    b) You must cause any work that you distribute or publish, that in\n"
"    whole or in part contains or is derived from the Program or any\n"
"    part thereof, to be licensed as a whole at no charge to all third\n"
"    parties under the terms of this License.\n"
"\n"
"    c) If the modified program normally reads commands interactively\n"
"    when run, you must cause it, when started running for such\n"
"    interactive use in the most ordinary way, to print or display an\n"
"    announcement including an appropriate copyright notice and a\n"
"    notice that there is no warranty (or else, saying that you provide\n"
"    a warranty) and that users may redistribute the program under\n"
"    these conditions, and telling the user how to view a copy of this\n"
"    License. (Exception: if the Program itself is interactive but\n"
"    does not normally print such an announcement, your work based on\n"
"    the Program is not required to print an announcement.)\n"
"\n"
"These requirements apply to the modified work as a whole. If\n"
"identifiable sections of that work are not derived from the Program,\n"
"and can be reasonably considered independent and separate works in\n"
"themselves, then this License, and its terms, do not apply to those\n"
"sections when you distribute them as separate works. But when you\n"
"distribute the same sections as part of a whole which is a work based\n"
"on the Program, the distribution of the whole must be on the terms of\n"
"this License, whose permissions for other licensees extend to the\n"
"entire whole, and thus to each and every part regardless of who wrote it.\n"
"\n"
"Thus, it is not the intent of this section to claim rights or contest\n"
"your rights to work written entirely by you; rather, the intent is to\n"
"exercise the right to control the distribution of derivative or\n"
"collective works based on the Program.\n"
"\n"
"In addition, mere aggregation of another work not based on the Program\n"
"with the Program (or with a work based on the Program) on a volume of\n"
"a storage or distribution medium does not bring the other work under\n"
"the scope of this License.\n"
"\n"
"  3. You may copy and distribute the Program (or a work based on it,\n"
"under Section 2) in object code or executable form under the terms of\n"
"Sections 1 and 2 above provided that you also do one of the following:\n"
"\n"
"    a) Accompany it with the complete corresponding machine-readable\n"
"    source code, which must be distributed under the terms of Sections\n"
"    1 and 2 above on a medium customarily used for software interchange; or,\n"
"\n"
"    b) Accompany it with a written offer, valid for at least three\n"
"    years, to give any third party, for a charge no more than your\n"
"    cost of physically performing source distribution, a complete\n"
"    machine-readable copy of the corresponding source code, to be\n"
"    distributed under the terms of Sections 1 and 2 above on a medium\n"
"    customarily used for software interchange; or,\n"
"\n"
"    c) Accompany it with the information you received as to the offer\n"
"    to distribute corresponding source code. (This alternative is\n"
"    allowed only for noncommercial distribution and only if you\n"
"    received the program in object code or executable form with such\n"
"    an offer, in accord with Subsection b above.)\n"
"\n"
"The source code for a work means the preferred form of the work for\n"
"making modifications to it. For an executable work, complete source\n"
"code means all the source code for all modules it contains, plus any\n"
"associated interface definition files, plus the scripts used to\n"
"control compilation and installation of the executable. However, as a\n"
"special exception, the source code distributed need not include\n"
"anything that is normally distributed (in either source or binary\n"
"form) with the major components (compiler, kernel, and so on) of the\n"
"operating system on which the executable runs, unless that component\n"
"itself accompanies the executable.\n"
"\n"
"If distribution of executable or object code is made by offering\n"
"access to copy from a designated place, then offering equivalent\n"
"access to copy the source code from the same place counts as\n"
"distribution of the source code, even though third parties are not\n"
"compelled to copy the source along with the object code.\n"
"\n"
"  4. You may not copy, modify, sublicense, or distribute the Program\n"
"except as expressly provided under this License. Any attempt\n"
"otherwise to copy, modify, sublicense or distribute the Program is\n"
"void, and will automatically terminate your rights under this License.\n"
"However, parties who have received copies, or rights, from you under\n"
"this License will not have their licenses terminated so long as such\n"
"parties remain in full compliance.\n"
"\n"
"  5. You are not required to accept this License, since you have not\n"
"signed it. However, nothing else grants you permission to modify or\n"
"distribute the Program or its derivative works. These actions are\n"
"prohibited by law if you do not accept this License. Therefore, by\n"
"modifying or distributing the Program (or any work based on the\n"
"Program), you indicate your acceptance of this License to do so, and\n"
"all its terms and conditions for copying, distributing or modifying\n"
"the Program or works based on it.\n"
"\n"
"  6. Each time you redistribute the Program (or any work based on the\n"
"Program), the recipient automatically receives a license from the\n"
"original licensor to copy, distribute or modify the Program subject to\n"
"these terms and conditions. You may not impose any further\n"
"restrictions on the recipients' exercise of the rights granted herein.\n"
"You are not responsible for enforcing compliance by third parties to\n"
"this License.\n"
"\n"
"  7. If, as a consequence of a court judgment or allegation of patent\n"
"infringement or for any other reason (not limited to patent issues),\n"
"conditions are imposed on you (whether by court order, agreement or\n"
"otherwise) that contradict the conditions of this License, they do not\n"
"excuse you from the conditions of this License. If you cannot\n"
"distribute so as to satisfy simultaneously your obligations under this\n"
"License and any other pertinent obligations, then as a consequence you\n"
"may not distribute the Program at all. For example, if a patent\n"
"license would not permit royalty-free redistribution of the Program by\n"
"all those who receive copies directly or indirectly through you, then\n"
"the only way you could satisfy both it and this License would be to\n"
"refrain entirely from distribution of the Program.\n"
"\n"
"If any portion of this section is held invalid or unenforceable under\n"
"any particular circumstance, the balance of the section is intended to\n"
"apply and the section as a whole is intended to apply in other\n"
"circumstances.\n"
"\n"
"It is not the purpose of this section to induce you to infringe any\n"
"patents or other property right claims or to contest validity of any\n"
"such claims; this section has the sole purpose of protecting the\n"
"integrity of the free software distribution system, which is\n"
"implemented by public license practices. Many people have made\n"
"generous contributions to the wide range of software distributed\n"
"through that system in reliance on consistent application of that\n"
"system; it is up to the author/donor to decide if he or she is willing\n"
"to distribute software through any other system and a licensee cannot\n"
"impose that choice.\n"
"\n"
"This section is intended to make thoroughly clear what is believed to\n"
"be a consequence of the rest of this License.\n"
"\n"
"  8. If the distribution and/or use of the Program is restricted in\n"
"certain countries either by patents or by copyrighted interfaces, the\n"
"original copyright holder who places the Program under this License\n"
"may add an explicit geographical distribution limitation excluding\n"
"those countries, so that distribution is permitted only in or among\n"
"countries not thus excluded. In such case, this License incorporates\n"
"the limitation as if written in the body of this License.\n"
"\n"
"  9. The Free Software Foundation may publish revised and/or new versions\n"
"of the General Public License from time to time. Such new versions will\n"
"be similar in spirit to the present version, but may differ in detail to\n"
"address new problems or concerns.\n"
"\n"
"Each version is given a distinguishing version number. If the Program\n"
"specifies a version number of this License which applies to it and \"any\n"
"later version\", you have the option of following the terms and conditions\n"
"either of that version or of any later version published by the Free\n"
"Software Foundation. If the Program does not specify a version number of\n"
"this License, you may choose any version ever published by the Free Software\n"
"Foundation.\n"
"\n"
"  10. If you wish to incorporate parts of the Program into other free\n"
"programs whose distribution conditions are different, write to the author\n"
"to ask for permission. For software which is copyrighted by the Free\n"
"Software Foundation, write to the Free Software Foundation; we sometimes\n"
"make exceptions for this. Our decision will be guided by the two goals\n"
"of preserving the free status of all derivatives of our free software and\n"
"of promoting the sharing and reuse of software generally.\n"
"\n"
"			NO WARRANTY\n"
"\n"
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN\n"
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS\n"
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE\n"
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
"REPAIR OR CORRECTION.\n"
"\n"
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
"POSSIBILITY OF SUCH DAMAGES.\n"
"\n"
"		END OF TERMS AND CONDITIONS\n"
"\n"
"	How to Apply These Terms to Your New Programs\n"
"\n"
"  If you develop a new program, and you want it to be of the greatest\n"
"possible use to the public, the best way to achieve this is to make it\n"
"free software which everyone can redistribute and change under these terms.\n"
"\n"
"  To do so, attach the following notices to the program. It is safest\n"
"to attach them to the start of each source file to most effectively\n"
"convey the exclusion of warranty; and each file should have at least\n"
"the \"copyright\" line and a pointer to where the full notice is found.\n"
"\n"
"    <one line to give the program's name and a brief idea of what it does.>\n"
"    Copyright (C) <year> <name of author>\n"
"\n"
"    This program is free software; you can redistribute it and/or modify\n"
"    it under the terms of the GNU General Public License as published by\n"
"    the Free Software Foundation; either version 2 of the License, or\n"
"    (at your option) any later version.\n"
"\n"
"    This program is distributed in the hope that it will be useful,\n"
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
"    GNU General Public License for more details.\n"
"\n"
"    You should have received a copy of the GNU General Public License\n"
"    along with this program; if not, write to the Free Software\n"
"    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n"
"\n"
"\n"
"Also add information on how to contact you by electronic and paper mail.\n"
"\n"
"If the program is interactive, make it output a short notice like this\n"
"when it starts in an interactive mode:\n"
"\n"
"    Gnomovision version 69, Copyright (C) year name of author\n"
"    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n"
"    This is free software, and you are welcome to redistribute it\n"
"    under certain conditions; type `show c' for details.\n"
"\n"
"The hypothetical commands `show w' and `show c' should show the appropriate\n"
"parts of the General Public License. Of course, the commands you use may\n"
"be called something other than `show w' and `show c'; they could even be\n"
"mouse-clicks or menu items--whatever suits your program.\n"
"\n"
"You should also get your employer (if you work as a programmer) or your\n"
"school, if any, to sign a \"copyright disclaimer\" for the program, if\n"
"necessary. Here is a sample; alter the names:\n"
"\n"
"  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n"
"  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n"
"\n"
"  <signature of Ty Coon>, 1 April 1989\n"
"  Ty Coon, President of Vice\n"
"\n"
"This General Public License does not permit incorporating your program into\n"
"proprietary programs. If your program is a subroutine library, you may\n"
"consider it more useful to permit linking proprietary applications with the\n"
"library. If this is what you want to do, use the GNU Library General\n"
"Public License instead of this License.\n"
"}\n"
"\n"
"\n"
"gset help_texts {Copyright Confusing}\n"
"# 35 \"/home/lex/floater/work/tclcode/texts.deq\" 2\n"
"proc display_text {name s} {\n"
"    global fixedfont\n"
"\n"
"    set slash /\n"
"    regsub -all slashslash [string range $s 1 end] $slash$slash text\n"
"\n"
"    talkmsg $text\n"
"# 60 \"/home/lex/floater/work/tclcode/texts.deq\"\n"
"}\n"
"# 170 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"line after texts\n"
"\n"
"foreach x [array names tcl_platform] { lappend platform $tcl_platform($x) }\n"
"\n"
"gset floaterclock 0\n"
"gset table_arrival_time 0\n"
"gset snooze 0\n"
"# 192 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"gset ntalklines 0\n"
"\n"
"gset dtalklines 0\n"
"		\n"
"\n"
"gset talklineattop 0\n"
"\n"
"\n"
"\n"
"gset showerrors 1\n"
"gset debugprinting 0\n"
"\n"
"\n"
"if $floater_silent {\n"
"    proc clearrect {x y} {puts stdout \"clearrect $x $y\"}\n"
"    proc anchor {l} {puts stdout \"anchor $l\"}\n"
"    proc down_and_anchor {{l 1}} {puts stdout \"down_and_anchor $l\"}\n"
"    proc right {{l 1}} {puts stdout \"right $l\"}\n"
"    proc str {l} {puts stdout \"str `$l'\"}\n"
"    proc ch {l} {puts stdout \"ch $l\"}\n"
"}\n"
"\n"
"line 161\n"
"\n"
"proc talkmsg {s {draw 1} {allowPrefix 1}} {\n"
"    global talklines ntalklines talkwidth debugprinting showerrors\n"
"    global dtalklines scrolllock talktop floater_silent floater_silent_conns\n"
"\n"
"    if $floater_silent {\n"
"	puts $s\n"
"	global conn_to_sock\n"
"	foreach conn [array names floater_silent_conns] {\n"
"	catch {puts $conn_to_sock($conn) $s}\n"
"	}\n"
"	return\n"
"    }\n"
"\n"
"\n"
"\n"
"\n"
"    if $debugprinting return\n"
"\n"
"    if {$talktop < 0} return\n"
"    if {!$showerrors && [regexp -nocase error $s]} return\n"
"\n"
"\n"
"    if [regexp \"(.*)\\n(.*)\" $s whole a b] {\n"
"	talkmsg $a\n"
"	talkmsg $b\n"
"	return\n"
"    }\n"
"\n"
"    if {[string length $s] > $talkwidth} {\n"
"	\n"
"	for {set i $talkwidth} {[incr i -1] > 0} {} {\n"
"	if {[string index $s $i] == \" \"} {\n"
"		incr i -1\n"
"		talkmsg [string range $s 0 $i] 0 0\n"
"		talkmsg [string range $s [expr $i + 2] end] $draw 0\n"
"		return\n"
"	}\n"
"	}\n"
"	\n"
"	talkmsg [string range $s 0 [expr $talkwidth - 1]] 0 0\n"
"	talkmsg [string range $s $talkwidth end] $draw 0\n"
"	return\n"
"    }\n"
"\n"
"    set talklines($ntalklines) $s\n"
"    incr ntalklines\n"
"    if !$scrolllock {set dtalklines $ntalklines}\n"
"    if $draw {drawtalkregion}\n"
"}\n"
"# 280 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"proc floatererror {s} { talkmsg \"ERROR: $s\" }\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if {[catch {source $startupfile} err] 	&& ![regexp -nocase {no such file} $err]} {\n"
"\n"
"\n"
"    talkmsg \"ERROR: $err\"\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"tryset loginservername \"loginserver\"\n"
"tryset loginserveraddr server.floater.org\n"
"tryset loginserverport \"2210\"\n"
"tryset resultservername \"resultserver\"\n"
"tryset resultserveraddr $loginserveraddr\n"
"tryset resultserverport \"1430\"\n"
"tryset pseudomailaddr $loginserveraddr\n"
"tryset pseudomailport \"1440\"\n"
"tryset resultparserprogram @FLOATER_SRC_DIR@/floatres/parsemail\n"
"tryset resultparser \"floater@floater.org\"\n"
"tryset bugmail \"lex@cc.gatech.edu\"\n"
"\n"
"line 255\n"
"\n"
"\n"
"tryset defaultnote \"\"\n"
"\n"
"\n"
"tryset tricktime 2000\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tryset autonewdeal_default 35\n"
"\n"
"\n"
"\n"
"tryset autonewdeal_seconds $autonewdeal_default\n"
"\n"
"tryset nokibitzers 0\n"
"tryset jointableservertree 1\n"
"\n"
"tryset youveseen 1\n"
"\n"
"tryset newbie [expr ![info exists usedname]]\n"
"# 570 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"gset tcl_interactive 1\n"
"\n"
"set needAuctionUpdate 0\n"
"\n"
"\n"
"gset showingauction 0\n"
"\n"
"# 1 \"/home/lex/floater/work/tclcode/options_common.deq\" 1\n"
"# 41 \"/home/lex/floater/work/tclcode/options_common.deq\"\n"
"set beepAtMyTurn_ 0\n"
"proc beepAtMyTurn {{toggle 0}} {\n"
"    global beepAtMyTurn_\n"
"\n"
"    if $toggle {set beepAtMyTurn_ [expr !$beepAtMyTurn_]}\n"
"}\n"
"# 578 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"# 1 \"/home/lex/floater/work/tclcode/matrix0.deq\" 1\n"
"# 38 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"proc redrawmatrixcards {} {}\n"
"\n"
"proc togglepassedcard {suit card} {\n"
"    global togglepassedaction\n"
"\n"
"    if [info exists togglepassedaction([string toupper $suit$card])] 	{catch $togglepassedaction([string toupper $suit$card])}\n"
"\n"
"}\n"
"\n"
"proc removecardfromhand {suit card} {\n"
"    global removecard\n"
"\n"
"    if [info exists removecard([string toupper $suit$card])] 	{catch $removecard([string toupper $suit$card])}\n"
"\n"
"}\n"
"# 69 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"proc rmcard {x y suit card} {\n"
"    set f \"$x $y\"\n"
"    anchor $f\n"
"    set suit [string toupper $suit]\n"
"    if {$suit == \"S\"} {rmcard2 $f $suit $card} {down_and_anchor}\n"
"    if {$suit == \"H\"} {rmcard2 $f $suit $card} {down_and_anchor}\n"
"    if {$suit == \"D\"} {rmcard2 $f $suit $card} {down_and_anchor}\n"
"    if {$suit == \"C\"} {rmcard2 $f $suit $card}\n"
"}\n"
"\n"
"proc rmcard2 {f suit card} {\n"
"    global cursuit\n"
"\n"
"    right 2\n"
"    set w [set \"cursuit($f$suit)\" [zap $card $cursuit($f$suit)]]\n"
"    str \"$w \"\n"
"}\n"
"\n"
"\n"
"proc zap {char text} {\n"
"    set i [string first $char $text]\n"
"    if {$i < 0} {\n"
"	return $text\n"
"    } elseif {$i == 0} {\n"
"	return [string range $text 1 end]\n"
"    } else {\n"
"	incr i -1\n"
"	set j [expr $i + 2]\n"
"	\n"
"	return \"[string range $text 0 $i][string range $text $j end]\"\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc suit {f cards suit} {\n"
"\n"
"    global cursuit removecard\n"
"\n"
"    set suit [string toupper $suit]\n"
"    set cards [string toupper $cards]\n"
"    str \"$suit $cards\"\n"
"    down_and_anchor\n"
"    set \"cursuit($f$suit)\" $cards\n"
"    for {set i [expr [string length $cards] - 1]} {$i >= 0} {incr i -1} {\n"
"	set card [string index $cards $i]\n"
"	set removecard([string toupper $suit$card]) \"rmcard $f $suit $card\"\n"
"    }\n"
"# 140 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"}\n"
"\n"
"\n"
"\n"
"proc hand {f s h d c} {\n"
"# 166 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"    global handwidth\n"
"    anchor $f\n"
"    clearrect $handwidth 4\n"
"\n"
"    suit $f $s s\n"
"    suit $f $h h\n"
"    suit $f $d d\n"
"    suit $f $c c\n"
"}\n"
"# 206 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"proc fulldeal {s h d c LHOs LHOh LHOd LHOc 		Ps Ph Pd Pc RHOs RHOh RHOd RHOc} {\n"
"\n"
"    global mframe\n"
"\n"
"    hand $mframe(self) $s $h $d $c\n"
"    hand $mframe(pard) $Ps $Ph $Pd $Pc\n"
"    hand $mframe(lho) $LHOs $LHOh $LHOd $LHOc\n"
"    hand $mframe(rho) $RHOs $RHOh $RHOd $RHOc\n"
"}\n"
"\n"
"gset tricktimeOK 1\n"
"\n"
"\n"
"\n"
"proc startshowtricktimer {} {\n"
"    global tricktime tricktimeOK\n"
"\n"
"    set tricktimeOK 0\n"
"    after $tricktime set tricktimeOK 1\n"
"}\n"
"\n"
"\n"
"\n"
"proc delayedclearmatrix {} {\n"
"    global needtoerase\n"
"\n"
"    set needtoerase 1\n"
"    after 5000 clearmatrixtimer\n"
"}\n"
"\n"
"proc clearmatrixtimer {} {\n"
"    global needtoerase\n"
"\n"
"    if $needtoerase {erasebidplay all}\n"
"}\n"
"\n"
"\n"
"\n"
"proc erasebidplay {who} {\n"
"    global tricktimeOK\n"
"\n"
"    while {!$tricktimeOK} {\n"
"	update\n"
"	after 100\n"
"    }\n"
"    if {$who == \"all\"} {\n"
"	global needtoerase\n"
"\n"
"	set needtoerase 0\n"
"	erasebidplay lho\n"
"	erasebidplay rho\n"
"	erasebidplay pard\n"
"	erasebidplay self\n"
"    } else {\n"
"\n"
"	global matrixtext\n"
"	\n"
"	anchor $matrixtext($who)\n"
"	clearrect 2 1\n"
"\n"
"\n"
"\n"
"\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc showplay {player suit card} {\n"
"\n"
"    global matrixtext\n"
"\n"
"    anchor $matrixtext($player)\n"
"    if {$suit == \"?\"} {\n"
"	str \"? \"\n"
"    } else {\n"
"	str $suit$card\n"
"    }\n"
"# 305 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc showbid {player level strain} {\n"
"\n"
"\n"
"    global matrixtext\n"
"\n"
"    anchor $matrixtext($player)\n"
"    if {$strain == \"-\"} {\n"
"	str \" \"\n"
"    } elseif {$strain == \"?\"} {\n"
"	str \"? \"\n"
"    } elseif {$level > 0} {\n"
"	str \"$level$strain \"\n"
"    } else {	\n"
"	str \"$strain \"\n"
"    }\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"proc drawbid {x y level strain} {\n"
"    global auctionx auctiony auctionbot\n"
"\n"
"\n"
"\n"
"    if {[expr $auctiony + $y + 2] <= $auctionbot} {\n"
"	anchor \"[expr $auctionx + 1 + 4 * $x] [expr $auctiony + $y + 2]\"\n"
"\n"
"	\n"
"	if {$strain == \"x\"} {\n"
"	set s \"X \"\n"
"	} elseif {$strain == \"xx\"} {\n"
"	set s \"XX\"\n"
"	} elseif {$strain == \"p\"} {\n"
"	set s \"P \"\n"
"	} elseif {$strain == \"-\"} {\n"
"	set s \" \"\n"
"	} elseif {$strain == \"?\"} {\n"
"	set s \"? \"\n"
"	} else {\n"
"	set s $level$strain\n"
"	}\n"
"	\n"
"	clearrect 2 1\n"
"	if {$s != \" \"} {str [string toupper $s]}\n"
"    }\n"
"}\n"
"# 489 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"proc setname {player compassdir name} {\n"
"\n"
"    global namepos namewidth\n"
"\n"
"    anchor $namepos($player)\n"
"    if {[string first \"(\" $name] == -1} {set name \"$name ($compassdir)\"}\n"
"    if {[string length $name] > $namewidth} {\n"
"	set name [string range $name 0 [expr $namewidth - 1]]\n"
"    }\n"
"    if {$player == \"self\" || $player == \"pard\"} {\n"
"	rightjustify $name $namewidth\n"
"    } else {\n"
"	clearrect $namewidth 1\n"
"    }\n"
"    str $name\n"
"# 517 \"/home/lex/floater/work/tclcode/matrix0.deq\"\n"
"}\n"
"# 585 \"/home/lex/floater/work/tclcode/floater.deq\" 2\n"
"\n"
"\n"
"line 532\n"
"\n"
"\n"
"\n"
"\n"
"proc showauction {bool} {\n"
"    global auctionx auctiony auctionwidth auctionheight auctionright auctionbot\n"
"    global showingauction\n"
"\n"
"    set showingauction $bool\n"
"    anchor \"$auctionx $auctiony\"\n"
"    clearrect $auctionwidth $auctionheight\n"
"    if $bool {\n"
"	hline . $auctionx $auctionright $auctiony\n"
"	vline . $auctionx $auctiony $auctionbot\n"
"    }\n"
"    textseated\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc rightjustify {s width {r 1}} {\n"
"    while {[string length $s] < $width} {\n"
"	set s \" $s\"\n"
"	if $r {ch \" \"}\n"
"    }\n"
"    return $s\n"
"}\n"
"\n"
"\n"
"\n"
"proc hline {c xlo xhi y} {\n"
"    anchor \"$xlo $y\"\n"
"    for {} {$xlo <= $xhi} {incr xlo} {ch $c}\n"
"}\n"
"\n"
"proc vline {c x ylo yhi} {\n"
"    anchor \"$x $ylo\"\n"
"    for {} {$ylo <= $yhi} {incr ylo} {ch $c; down_and_anchor}\n"
"}\n"
"\n"
"\n"
"hline - 30 46 4\n"
"hline - 30 46 10\n"
"vline | 29 5 9\n"
"vline | 47 5 9\n"
"\n"
"\n"
"gset mframe(self) {30 11}\n"
"gset mframe(pard) {30 0}\n"
"gset mframe(lho) {15 6}\n"
"gset mframe(rho) {49 6}\n"
"gset handwidth 14\n"
"\n"
"gset namewidth 14\n"
"gset namepos(self) {15 11}\n"
"gset namepos(pard) {15 0}\n"
"gset namepos(lho) {15 5}\n"
"gset namepos(rho) {49 5}\n"
"\n"
"gset matrixtext(self) {37 9}\n"
"gset matrixtext(pard) {37 5}\n"
"gset matrixtext(lho) {31 7}\n"
"gset matrixtext(rho) {43 7}\n"
"\n"
"gset auctionx 64\n"
"gset auctiony 5\n"
"gset auctionright 79\n"
"gset auctionbot 14\n"
"gset auctionwidth [expr $auctionright - $auctionx + 1]\n"
"gset auctionheight [expr $auctionbot - $auctiony + 1]\n"
"# 707 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"set x [expr ![catch {regexp -nocase \"Apr.? 1 \" [clock format [clock seconds]]} y]]\n"
"if !$x {set y 0}\n"
"if [expr $x && $y] {\n"
" fulldeal AKQJ AKQJ AKQJ AK T98 T98 T98 QJT9 765 765 765 876 432 432 432 5432\n"
" showbid self 8 n\n"
"} else {\n"
" fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2\n"
" showbid self 7 n\n"
"}\n"
"\n"
"\n"
"line 901\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"gset previous_trick_index 0\n"
"gset previous_trick {}\n"
"\n"
"proc reset_previous_trick {{index -999}} {\n"
"    global previous_trick previous_trick_index\n"
"\n"
"    if {$index == -999 || $index == $previous_trick_index} {\n"
"	set previous_trick {}\n"
"    }\n"
"}\n"
"\n"
"proc set_previous_trick {s {erase 1}} {\n"
"    global previous_trick previous_trick_index\n"
"\n"
"    set previous_trick $s\n"
"    incr previous_trick_index\n"
"\n"
"\n"
"    if $erase {after 10000 \"reset_previous_trick $previous_trick_index\"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"gset oldpov S\n"
"gset oldseated 0\n"
"\n"
"proc textseated {{seated -1} {pov S}} {\n"
"    global auctionx auctiony showingauction oldseated oldpov\n"
"\n"
"    if {$seated == -1} {set seated $oldseated; set pov $oldpov}\n"
"    set oldseated $seated\n"
"    set oldpov $pov\n"
"    if !$showingauction return\n"
"\n"
"    anchor \"$auctionx $auctiony\"\n"
"    down_and_anchor\n"
"    right 1\n"
"    if $seated {\n"
"	str \"LHO Par RHO you\"\n"
"    } else {\n"
"	if {$pov == \"S\"} {\n"
"	str \"(W) (N) (E) (S)\"\n"
"	} elseif {$pov == \"N\"} {\n"
"	str \"(E) (S) (W) (N)\"\n"
"	} elseif {$pov == \"E\"} {\n"
"	str \"(S) (W) (N) (E)\"\n"
"	} elseif {$pov == \"W\"} {\n"
"	str \"(N) (E) (S) (W)\"\n"
"	}\n"
"    }\n"
"}\n"
"# 787 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"set statusline {}\n"
"set infoline {}\n"
"\n"
"gset leftwidth 14\n"
"gset rightwidth 30\n"
"gset rightpos 50\n"
"\n"
"proc strinfield {s x y width} {\n"
"    anchor \"$x $y\"\n"
"    clearrect $width 1\n"
"    if {[string length $s] > $width} 	{set s [string range $s 0 [expr $width - 1]]}\n"
"\n"
"    str $s\n"
"}\n"
"\n"
"strinfield $floater_version 0 0 15\n"
"\n"
"\n"
"proc connstat {{s {}}} {\n"
"    global leftwidth\n"
"    strinfield $s 0 1 $leftwidth\n"
"}\n"
"\n"
"\n"
"proc displayhandname {{s {}}} {\n"
"    global leftwidth\n"
"    strinfield $s 0 2 $leftwidth\n"
"}\n"
"\n"
"proc statushandvul {{s {}}} {\n"
"    global leftwidth\n"
"    strinfield $s 0 3 $leftwidth\n"
"}\n"
"\n"
"proc statushanddlr {{s {}}} {\n"
"    global leftwidth\n"
"    strinfield $s 0 4 $leftwidth\n"
"}\n"
"\n"
"proc statuscontract {{s {}}} {\n"
"    global rightpos rightwidth\n"
"    strinfield $s $rightpos 0 $rightwidth\n"
"}\n"
"\n"
"proc statustolead {{s {}}} {\n"
"    global rightpos rightwidth\n"
"    strinfield $s $rightpos 1 $rightwidth\n"
"}\n"
"\n"
"proc displaytrickswon {{s {}}} {\n"
"    global rightpos rightwidth\n"
"    strinfield $s $rightpos 2 $rightwidth\n"
"}\n"
"\n"
"\n"
"proc statusclaim {{s {}}} {\n"
"    global rightpos rightwidth\n"
"    strinfield $s $rightpos 3 $rightwidth\n"
"}\n"
"\n"
"proc statusresult {{s {}}} {\n"
"    global rightpos rightwidth\n"
"    strinfield $s $rightpos 4 $rightwidth\n"
"}\n"
"\n"
"\n"
"proc statusscore {{s {}}} {\n"
"    global leftwidth\n"
"\n"
"    set x 0\n"
"    set y 5\n"
"\n"
"    if {$s == \"\"} {set s \" ; ; ; ; \"}\n"
"\n"
"    while {[regexp {([^;]*); (.*)} $s whole t s]} {\n"
"	strinfield $t $x $y $leftwidth\n"
"	incr y\n"
"    }\n"
"    strinfield $s $x $y $leftwidth\n"
"}\n"
"\n"
"\n"
"line 1064\n"
"\n"
"\n"
"gset oldntalklines 0\n"
"gset scrolllock 0\n"
"\n"
"\n"
"\n"
"\n"
"proc drawtalkregion {{must_redraw 0}} {\n"
"    global talklines dtalklines talktop talklineattop talkbottom oldntalklines\n"
"    global scrolllock ntalklines\n"
"\n"
"    draw_on_current_display +\n"
"\n"
"    set talksize [expr $talkbottom - $talktop + 1]\n"
"\n"
"    if {($dtalklines >= $ntalklines) || ($ntalklines < $talksize)} {\n"
"	set dtalklines $ntalklines\n"
"	set scrolllock 0\n"
"    }\n"
"\n"
"    set want_to_redraw 	[expr ($dtalklines - $talklineattop) > $talksize]\n"
"\n"
"    if {$must_redraw || ($want_to_redraw && !$scrolllock)} {\n"
"	\n"
"	set y $talktop\n"
"	set i [set talklineattop [expr $dtalklines - $talksize]]\n"
"	if {$i < 0} {\n"
"	if $scrolllock {set dtalklines $talksize}\n"
"	set i 0\n"
"	}\n"
"	for {set talklineattop $i} 	{($y <= $talkbottom) && ($i < $dtalklines) && ($i < $ntalklines)} 	{incr i; incr y} {\n"
"\n"
"\n"
"		drawtalkline $y $talklines($i)\n"
"	}\n"
"	\n"
"	\n"
"	if {$i == $ntalklines} {set scrolllock 0}\n"
"    } elseif !$scrolllock {\n"
"	\n"
"	for {set y $talktop; set i $talklineattop} 		{$y <= $talkbottom && $i < $dtalklines} 		{incr i; incr y} {\n"
"\n"
"\n"
"	if {$i >= $oldntalklines} {drawtalkline $y $talklines($i)}\n"
"	}\n"
"    }\n"
"    set oldntalklines $ntalklines\n"
"    reset_cursor_position\n"
"    draw_on_current_display -\n"
"}\n"
"\n"
"proc talkscroll {n} {\n"
"    global scrolllock dtalklines\n"
"\n"
"    incr dtalklines $n\n"
"    set scrolllock 1\n"
"    drawtalkregion 1\n"
"}\n"
"\n"
"proc turn_off_scrolllock {} {\n"
"    talkscroll 1000000\n"
"}\n"
"\n"
"proc talkregion {top bottom} {\n"
"    global talktop talkbottom talklineattop scrolllock\n"
"\n"
"    set talktop $top\n"
"    set talkbottom $bottom\n"
"    drawtalkregion 1\n"
"}\n"
"\n"
"proc drawtalkline {y s} {\n"
"    anchor \"0 $y\"\n"
"    str \"$s\\n\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc debugmsg {s} {\n"
"    global debugprinting floater_silent\n"
"\n"
"    set old $debugprinting\n"
"    set debugprinting 1\n"
"    talkmsg $s\n"
"    set debugprinting $old\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc setcursor {cursor w} {\n"
"# 976 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"}\n"
"\n"
"line 1173\n"
"\n"
"proc unsetcursor {w} {\n"
"# 992 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"}\n"
"\n"
"proc patientcursor {} {\n"
"    global cursorlevel\n"
"\n"
"    if {[incr cursorlevel] == 1} {setcursor watch .}\n"
"}\n"
"\n"
"proc normalcursor {} {\n"
"    global cursorlevel\n"
"\n"
"    if {[incr cursorlevel -1] == 0} {unsetcursor .}\n"
"}\n"
"set cursorlevel 0\n"
"	\n"
"# 1026 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"tryset tabletimeout 600\n"
"\n"
"\n"
"\n"
"tryset tablereannounce 90\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set receiveiamalivelist {}\n"
"set sendiamalivelist {}\n"
"\n"
"\n"
"tryset sendiamaliveinterval 40000\n"
"\n"
"\n"
"tryset receiveiamaliveinterval 20000\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tryset iamalivetimeout 450\n"
"\n"
"\n"
"proc shouldreceiveiamalive {conn} {\n"
"    global receiveiamalivelist\n"
"\n"
"    set receiveiamalivelist [linsert $receiveiamalivelist 0 $conn]\n"
"}\n"
"\n"
"proc shouldnotreceiveiamalive {conn} {\n"
"    global receiveiamalivelist\n"
"\n"
"    catch {\n"
"	set i [lsearch $receiveiamalivelist $conn]\n"
"	set receiveiamalivelist [lreplace $receiveiamalivelist $i $i]\n"
"    }\n"
"}\n"
"\n"
"proc shouldsendiamalive {conn} {\n"
"    global sendiamalivelist\n"
"\n"
"    set sendiamalivelist [linsert $sendiamalivelist 0 $conn]\n"
"}\n"
"\n"
"proc shouldnotsendiamalive {conn} {\n"
"    global sendiamalivelist\n"
"\n"
"    catch {\n"
"	set i [lsearch $sendiamalivelist $conn]\n"
"	set sendiamalivelist [lreplace $sendiamalivelist $i $i]\n"
"    }\n"
"}\n"
"\n"
"proc sendiamalives {} {\n"
"    global sendiamalivelist sendiamaliveinterval\n"
"\n"
"    after $sendiamaliveinterval sendiamalives\n"
"    foreach conn $sendiamalivelist {\n"
"	debugmsg \"Sending iamalive to $conn\"\n"
"	catch {FloaterSend $conn *alive*}\n"
"    }\n"
"}\n"
"\n"
"proc checkreceiveiamalive {conn} {\n"
"    global iamalivetimeout timeofmostrecent floaterclock\n"
"\n"
"\n"
"    catch {\n"
"	debugmsg \"seconds since most recent msg on $conn: [expr ($floaterclock - $timeofmostrecent($conn))]\"\n"
"	if [expr ($floaterclock - $timeofmostrecent($conn)) > $iamalivetimeout] 		{floatertimeout $conn}\n"
"\n"
"    }\n"
"}\n"
"\n"
"proc checkreceiveiamalives {} {\n"
"    global receiveiamalivelist receiveiamaliveinterval\n"
"\n"
"    after $receiveiamaliveinterval checkreceiveiamalives\n"
"    foreach conn $receiveiamalivelist { checkreceiveiamalive $conn }\n"
"}\n"
"\n"
"sendiamalives\n"
"checkreceiveiamalives\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"gset MyTurnTimer -99\n"
"tryset MyTurnTimerCountdown 20\n"
"proc startMyTurnTimer {} {\n"
"    global MyTurnTimerCountdown MyTurnTimer\n"
"    set MyTurnTimer $MyTurnTimerCountdown\n"
"}\n"
"\n"
"proc MyTurnTimerRing {} {\n"
"    global showingauction\n"
"    if $showingauction {\n"
"	showauction 0\n"
"	showauction 1\n"
"	startMyTurnTimer\n"
"    }\n"
"}\n"
"\n"
"proc stopMyTurnTimer {} {\n"
"    global MyTurnTimer\n"
"    set MyTurnTimer -99\n"
"}\n"
"\n"
"line 1335\n"
"\n"
"\n"
"\n"
"proc floaterclockbump {} {\n"
"    global floaterclock MyTurnTimer\n"
"\n"
"    incr floaterclock\n"
"    if {$MyTurnTimer > 0} {if {[incr MyTurnTimer -1] == 0} MyTurnTimerRing}\n"
"    after 1000 floaterclockbump\n"
"\n"
"\n"
"    if {[expr $floaterclock % 3] == 0} {command {}}\n"
"}\n"
"\n"
"after 1000 floaterclockbump\n"
"\n"
"\n"
"proc countdown {x} {\n"
"    global $x\n"
"\n"
"    if {[set $x] > 0} then \"after 1000 \\\"countdown $x\\\"\" else return\n"
"    incr $x -1\n"
"}\n"
"\n"
"proc reset_rejoinnow {} {\n"
"    global rejoinclock rejoinclockincrement\n"
"\n"
"    set rejoinclock 0\n"
"    set rejoinclockincrement 1\n"
"}\n"
"\n"
"proc rejoinnow {} {\n"
"    global rejoinclock rejoinclockincrement\n"
"\n"
"    if {$rejoinclock <= 0} then {\n"
"	if {$rejoinclockincrement < 1800} 		{set rejoinclockincrement [expr 2 * $rejoinclockincrement]}\n"
"\n"
"	set rejoinclock $rejoinclockincrement\n"
"	countdown rejoinclock\n"
"	return 1\n"
"    } else {return 0}\n"
"}\n"
"\n"
"proc reset_find_rho {} {\n"
"    global rhoclock rhoclockincrement\n"
"\n"
"    set rhoclock 0\n"
"    set rhoclockincrement 1\n"
"}\n"
"\n"
"proc findrhonow {} {\n"
"    global rhoclock rhoclockincrement\n"
"\n"
"    if {$rhoclock <= 0} then {\n"
"	if {$rhoclockincrement < 1800} 		{set rhoclockincrement [expr 2 * $rhoclockincrement]}\n"
"\n"
"	set rhoclock $rhoclockincrement\n"
"	countdown rhoclock\n"
"	return 1\n"
"    } else {return 0}\n"
"}\n"
"\n"
"reset_find_rho\n"
"reset_rejoinnow\n"
"\n"
"\n"
"gset autodealing 0\n"
"\n"
"proc autonewdeal {} {\n"
"    global autonewdeal_seconds autodealing\n"
"\n"
"    if $autodealing return\n"
"    if {$autonewdeal_seconds >= 0} {\n"
"	set autodealing 1\n"
"	after [expr 1000 * $autonewdeal_seconds] {\n"
"	global autodealing\n"
"	\n"
"	if $autodealing {\n"
"		set autodealing 0\n"
"		if {$autonewdeal_seconds >= 0} {command autodeal_now}\n"
"	} else {\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"	}\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"global updateloc_seconds\n"
"tryset updateloc_seconds 300\n"
"\n"
"proc updateloc {} {\n"
"    global updateloc_seconds\n"
"\n"
"    after [expr 1000 * $updateloc_seconds] updateloc\n"
"    catch {command iupdatelocation}\n"
"}\n"
"\n"
"updateloc\n"
"# 1257 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"gset should_defer 0\n"
"\n"
"\n"
"proc command args {\n"
"    global should_defer\n"
"\n"
"    if $should_defer {deferpush \"commandn $args\"} else {eval \"commandn $args\"}\n"
"}\n"
"# 1276 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"proc floaterreceive {msg conn} {\n"
"    global should_defer timeofmostrecent floaterclock\n"
"\n"
"    set timeofmostrecent($conn) $floaterclock\n"
"\n"
"    if {$msg == \"*alive*\"} return\n"
"\n"
"    if $should_defer {\n"
"	deferpush \"floaterreceiven {$msg} {$conn}\"\n"
"    } else {\n"
"	floaterreceiven $msg $conn\n"
"    }\n"
"}\n"
"\n"
"proc talk args {\n"
"    global should_defer\n"
"\n"
"    if $should_defer {deferpush \"talkn $args\"} else {eval \"talkn $args\"}\n"
"}\n"
"\n"
"proc FloaterClose args {\n"
"    global should_defer\n"
"\n"
"    if $should_defer {deferpush \"FloaterClosen $args\"} 	else {eval \"FloaterClosen $args\"}\n"
"\n"
"}\n"
"# 1312 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"proc floatertimeout args {\n"
"    global should_defer\n"
"\n"
"    if $should_defer {deferpush \"floatertimeoutn $args\"} 	else {eval \"floatertimeoutn $args\"}\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc defer {n} {\n"
"    global should_defer\n"
"\n"
"    if {[incr should_defer $n] == 0} {\n"
"	while {![deferempty]} {eval [deferpop]}\n"
"    }\n"
"}\n"
"\n"
"gset deferqueuelo 0\n"
"gset deferqueuehi 0\n"
"\n"
"proc deferempty {} {\n"
"    global deferqueuehi deferqueuelo\n"
"\n"
"    return [expr $deferqueuelo == $deferqueuehi]\n"
"}\n"
"\n"
"proc deferpush {s} {\n"
"    global deferqueue deferqueuehi\n"
"\n"
"    set deferqueue($deferqueuehi) $s\n"
"    incr deferqueuehi\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"proc deferpop {} {\n"
"    global deferqueue deferqueuelo\n"
"\n"
"    set temp $deferqueue($deferqueuelo)\n"
"    unset deferqueue($deferqueuelo)\n"
"    incr deferqueuelo\n"
"\n"
"\n"
"\n"
"    return $temp\n"
"}\n"
"\n"
"line 1548\n"
"# 1373 \"/home/lex/floater/work/tclcode/floater.deq\"\n"
"set executing_index 0\n"
"\n"
"proc Floater_execute {file} {\n"
"    global executing_index executing_command\n"
"    if {[set n [gets $file s]] >= 0} {\n"
"	if {$n > 0} {\n"
"	deferpush \"show_executing [incr executing_index]; Floater_execute $file\"\n"
"	set executing_command($executing_index) $s\n"
"	} else {\n"
"	\n"
"	Floater_execute $file\n"
"	}\n"
"	return\n"
"    }\n"
"    catch {close $file}\n"
"}\n"
"\n"
"proc show_executing {n} {\n"
"    global executing_command\n"
"\n"
"    talkmsg \"Execute: $executing_command($n)\"\n"
"    commandn $executing_command($n)\n"
"    unset executing_command($n)\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc untabify {s} {\n"
"    if [regexp {([^\\t]*)\\t(.*)} $s whole left right] {\n"
"	set i [string length $left]\n"
"	while 1 {\n"
"	set right \" $right\"\n"
"	incr i\n"
"	if [expr $i % 8 == 0] {return [untabify $left$right]}\n"
"	}\n"
"    } else {return $s}\n"
"}\n"
"\n"
"proc truncate {s {n 80}} {\n"
"    if {[string length $s] > $n} {\n"
"	return [string range $s 0 [expr $n - 1]]\n"
"    } else {\n"
"	return $s\n"
"    }\n"
"}\n"
"\n"
"proc unbraceclean {s} {\n"
"    regsub -all {\\\\(\\[|\\]|\\{|\\})} $s {\\1} x\n"
"    return $x\n"
"}\n"
"\n"
"proc beginnewcc {direction} {\n"
"    global newcc newccline newccignoring\n"
"\n"
"    set newccline 0\n"
"    set newccignoring 0\n"
"    set newcc $direction\n"
"}\n"
"\n"
"proc fetchnewcc {ccloadfile} {\n"
"    while {[gets $ccloadfile s] >= 0} {addnewcc $s 0}\n"
"}\n"
"\n"
"proc addnewcc {s {bracecleaned 1}} {\n"
"    global newcc newccline cc newccignoring\n"
"\n"
"    set s [untabify [truncate $s]]\n"
"    if $bracecleaned {set s [unbraceclean $s]}\n"
"    if {$newccline == 40} {set newccignoring 1; return}\n"
"    set cc($newcc,[incr newccline]) $s\n"
"}\n"
"\n"
"proc endnewcc {} {\n"
"    global newcc newccline newccignoring cclines\n"
"\n"
"    set cclines($newcc) $newccline\n"
"\n"
"    if $newccignoring {\n"
"	return \"Warning: Ignored lines beyond the first 40\"\n"
"    } else {\n"
"	return \"\"\n"
"    }\n"
"}\n"
"\n"
"\n"
"\n"
"proc ccstr {direction} {\n"
"    global cc cclines\n"
"\n"
"    set s \"\"\n"
"    catch {\n"
"	if {$cclines($direction) < 1} {return \"\"}\n"
"	set s $cc($direction,1)\n"
"	for {set i 2} {$i <= $cclines($direction)} {incr i} {\n"
"	set s \"$s\\t$cc($direction,$i)\"\n"
"	}\n"
"    }\n"
"    return $s\n"
"}\n"
"\n"
"gset lastrange \"\"\n"
"proc inrange {n range} {\n"
"    global lastrange lastrangelow lastrangehigh\n"
"\n"
"    if {$range != $lastrange} {\n"
"	set lastrange $range\n"
"	if [regexp {^([0-9]+)-([0-9]+)$} $range x lastrangelow lastrangehigh] {\n"
"	\n"
"	} elseif [regexp {^([0-9]+)$} $range lastrangelow] {\n"
"	set lastrangehigh $lastrangelow\n"
"	} elseif [regexp {^([0-9]+)-$} $range x lastrangelow] {\n"
"	set lastrangehigh 1000000\n"
"	} elseif [regexp {^-([0-9]+)$} $range x lastrangehigh] {\n"
"	set lastrangelow -1000000\n"
"	} else {error \"Invalid range: $range\"}\n"
"    }\n"
"    expr ($n >= $lastrangelow) && ($n <= $lastrangehigh)\n"
"}\n"
"\n"
"proc ccdump {direction {range 1-}} {\n"
"    global cc cclines\n"
"\n"
"    for {set i 1} {$i <= $cclines($direction)} {incr i} {\n"
"	if [inrange $i $range] {\n"
"	talkmsg $cc($direction,$i)\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"proc ccsave {file direction} {\n"
"    global cc cclines\n"
"\n"
"    for {set i 1} {$i <= $cclines($direction)} {incr i} {\n"
"	puts $file $cc($direction,$i)\n"
"    }\n"
"    close $file\n"
"}\n"
"\n"
"proc getccline {direction line} {\n"
"    global cc cclines\n"
"\n"
"    if ![info exists cclines($direction)] {return \"\"}\n"
"    if {$line <= $cclines($direction)} {\n"
"	return $cc($direction,$line)\n"
"    } else {\n"
"	return \"\"\n"
"    }\n"
"}\n"
"\n"
"line 1697\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc reverse_init {} {\n"
"    global reverse_n\n"
"\n"
"    set reverse_n 0\n"
"}\n"
"\n"
"proc reverse_print {s} {\n"
"    global reverse_n reverse_lines\n"
"\n"
"    set reverse_lines($reverse_n) $s\n"
"    incr reverse_n\n"
"}\n"
"\n"
"proc reverse_done {} {\n"
"    global reverse_n reverse_lines\n"
"\n"
"    while {[incr reverse_n -1] >= 0} {\n"
"	talkmsg $reverse_lines($reverse_n)\n"
"	unset reverse_lines($reverse_n)\n"
"    }\n"
"}\n"
"\n"
"\n"
"proc Floater_login {} {\n"
"    global loginname loginpassword newbie\n"
"\n"
"    toplevel .login\n"
"\n"
"    frame .login.left\n"
"    frame .login.right\n"
"    frame .login.bottom\n"
"\n"
"    button .login.bottom.cancel -text \"Cancel\" 	-command {set loginname \"\"; set loginpassword \"\"; destroy .login}\n"
"\n"
"    button .login.bottom.clear -text \"Clear\" 	-command {set loginname \"\"; set loginpassword \"\"; focus .login.right.n}\n"
"\n"
"    button .login.bottom.ok -text \"OK\" 	-command {destroy .login}\n"
"\n"
"\n"
"    proc newbietr {name el op} {\n"
"	global pw_or_email newbie\n"
"\n"
"	if $newbie {set pw_or_email \"Email address: \"} 		{set pw_or_email \"Password: \"}\n"
"\n"
"    }\n"
"\n"
"    checkbutton .login.new -text \"New User\" -variable newbie\n"
"    trace variable newbie w newbietr\n"
"    if [info exists newbie] {set newbie $newbie} {set newbie 0}\n"
"\n"
"    label .login.left.n -text \"Name: \"\n"
"    label .login.left.p -textvariable pw_or_email -width 13\n"
"\n"
"    entry .login.right.n -bd 2 -relief sunken -textvariable loginname\n"
"    focus .login.right.n\n"
"    entry .login.right.p -bd 2 -relief sunken -textvariable loginpassword\n"
"\n"
"    pack .login.bottom.cancel .login.bottom.clear .login.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m\n"
"\n"
"    pack .login.left.n .login.left.p\n"
"    pack .login.right.n .login.right.p\n"
"    pack .login.bottom -side bottom\n"
"    pack .login.new -side bottom -pady 2m\n"
"    pack .login.left -side left -fill x -expand yes\n"
"    pack .login.right .login.right -side right -fill x -expand yes\n"
"    wm title .login \"Floater login\"\n"
"\n"
"    bindsetup .login.right.n .login.right.p {focus .login.right.p}\n"
"    bindsetup .login.right.p .login.right.n {destroy .login}\n"
"    bind .login.right.n \\\\ {set loginname \"\"}\n"
"\n"
"    grab set .login\n"
"    tkwait window .login\n"
"    trace vdelete newbie w newbietr\n"
"    set loginname [string trim $loginname]\n"
"    catch focus_cmdline\n"
"    if $newbie {return \"N$loginname\\\\$loginpassword\"} 	{return \"O$loginname\\\\$loginpassword\"}\n"
"\n"
"}\n"
"\n"
"proc Floater_changepw {} {\n"
"    global changepwname oldpassword newpassword\n"
"\n"
"    toplevel .changepw\n"
"\n"
"    frame .changepw.left\n"
"    frame .changepw.right\n"
"    frame .changepw.bottom\n"
"\n"
"\n"
"    button .changepw.bottom.cancel -text \"Cancel\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; destroy .changepw}\n"
"\n"
"\n"
"    button .changepw.bottom.clear -text \"Clear\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; focus .changepw.right.n}\n"
"\n"
"\n"
"    button .changepw.bottom.ok -text \"OK\" 	-command {destroy .changepw}\n"
"\n"
"\n"
"    label .changepw.left.n -text \"Name: \"\n"
"    label .changepw.left.o -text \"Old password: \"\n"
"    label .changepw.left.p -text \"New password: \"\n"
"\n"
"    entry .changepw.right.n -bd 2 -relief sunken -textvariable changepwname\n"
"    entry .changepw.right.o -bd 2 -relief sunken -textvariable oldpassword\n"
"    entry .changepw.right.p -bd 2 -relief sunken -textvariable newpassword\n"
"\n"
"    pack .changepw.bottom.cancel .changepw.bottom.clear .changepw.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m\n"
"\n"
"    pack .changepw.left.n .changepw.left.o .changepw.left.p\n"
"    pack .changepw.right.n .changepw.right.o .changepw.right.p\n"
"    pack .changepw.bottom -side bottom\n"
"    pack .changepw.left -side left -fill x -expand yes\n"
"    pack .changepw.right .changepw.right -side right -fill x -expand yes\n"
"    wm title .changepw \"change password\"\n"
"\n"
"    bindsetup .changepw.right.n .changepw.right.o {focus .changepw.right.o}\n"
"    bindsetup .changepw.right.o .changepw.right.p {focus .changepw.right.p}\n"
"    bindsetup .changepw.right.p .changepw.right.n {destroy .changepw}\n"
"    bind .changepw.right.n \\\\ {set changepwname \"\"}\n"
"\n"
"    grab set .changepw\n"
"    tkwait window .changepw\n"
"    catch {focus .cmd; focus .cmd.talk}\n"
"    return \"$changepwname\\\\$oldpassword\\\\$newpassword\"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc Floater_bell {} { catch { bell } }\n"
"\n"
"\n"
"line bottom\n"
"# 36 \"/home/lex/floater/work/tclcode/floatert.deq\" 2\n"
,
"# ***** BEGIN LICENSE BLOCK *****\n"
"# Version: MPL 1.1/GPL 2\n"
"#\n"
"# The contents of this file are subject to the Mozilla Public License Version\n"
"# 1.1 (the \"License\"); you may not use this file except in compliance with\n"
"# the License. You may obtain a copy of the License at\n"
"# http://www.mozilla.org/MPL/\n"
"#\n"
"# Software distributed under the License is distributed on an \"AS IS\" basis,\n"
"# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License\n"
"# for the specific language governing rights and limitations under the\n"
"# License.\n"
"#\n"
"# The Original Code is the Floater Bridge Network.\n"
"#\n"
"# The Initial Developer of the Original Code is\n"
"# Geoff Pike <pike@EECS.Berkeley.EDU>.\n"
"# Portions created by the Initial Developer are Copyright (C) 1996-2003\n"
"# the Initial Developer. All Rights Reserved.\n"
"#\n"
"# Contributor(s):\n"
"#     Lex Spoon <lex@cc.gatech.edu>\n"
"#\n"
"# Alternatively, the contents of this file may be used under the\n"
"# terms of either the GNU General Public License Version 2 or later\n"
"# (the \"GPL\"), in which case the provisions of the GPL are applicable\n"
"# instead of those above. If you wish to allow use of your version of\n"
"# this file only under the terms of the GPL, and not to allow others\n"
"# to use your version of this file under the terms of the MPL,\n"
"# indicate your decision by deleting the provisions above and replace\n"
"# them with the notice and other provisions required by the GPL. If\n"
"# you do not delete the provisions above, a recipient may use your\n"
"# version of this file under the terms of either the MPL or the GPL.\n"
"# ***** END LICENSE BLOCK *****\n"
"\n"
"# ls.tcl -- Floater's login server, responsible for logging in users\n"
"#           and keeping track of the open tables\n"
"\n"
"\n"
"# XXX this doesn't work; autoconf only sets up directory substitutions for Makefiles\n"
"#set lsfile @libdir@/serverfiles/loginserver.tcl\n"
"set lsfile /var/lib/floater/serverfiles/loginserver.tcl\n"
"set writefile $lsfile\\_wtest\n"
"set lsdir [file dirname $lsfile]\n"
"#set rsdir @rsdir@\n"
"set rsdir /var/lib/floater/floater_rs\n"
"\n"
"#set webdir @webdir@\n"
"set webdir /var/lib/floater/www\n"
"set rawresultsdir $webdir/rawresults\n"
"set permdir $lsdir/perm\n"
"set tmpdir $lsdir/tmp\n"
"\n"
"# 5 minutes\n"
"set check_tempdir_interval [expr 1000 * 60 * 5]\n"
"set flush_interval [expr 1000 * 60 * 5]\n"
"\n"
"exec sh -c \"cd $lsdir && make all || (echo make all failed | mail $bugmail)\"\n"
"\n"
"proc dumppw {} {\n"
"    global lsdir bugmail\n"
"    catch {exec sh -c \"cd $lsdir && make dump || (echo dumppw failed | mail $bugmail)\" &}\n"
"}\n"
"\n"
"proc copyresultfiles {week} {\n"
"    global rsdir rawresultsdir\n"
"    catch {\n"
"	# puts stderr \"copyresultfiles $week\"\n"
"	set files [glob $rsdir/$week*]\n"
"	puts stderr \"cp $files $rawresultsdir\"\n"
"	eval exec cp $files $rawresultsdir\n"
"    }\n"
"}\n"
"\n"
"# keep everything before the first open paren\n"
"proc parenstrip {s} {\n"
"    if {[set i [string first \\( $s]] == -1} {return $s}\n"
"    string range $s 0 [incr i -1]\n"
"}\n"
"\n"
"proc tryget {a} {\n"
"    global [parenstrip $a]\n"
"\n"
"    if [info exists $a] {return [set $a]} {return \"\"}\n"
"}\n"
"\n"
"#Try to find an element of arr whose index is v, ignoring case differences\n"
"proc tryget_nocase {arr v} {\n"
"    global $arr\n"
"\n"
"    set v [string toupper $v]\n"
"    foreach i [array names $arr] {\n"
"	if ![string compare $v [string toupper $i]] {\n"
"	    return [tryget $arr\\($i\\)]\n"
"	}\n"
"    }\n"
"    return \"\"\n"
"}\n"
"\n"
"proc s {a b} {global [parenstrip $a]; set $a $b}\n"
"if [file exists $lsfile] {source $lsfile}\n"
"global pw pwx\n"
"foreach i [array names pw] {\n"
"    set \"pwx([string toupper $i])\" $i\n"
"}\n"
"\n"
"proc sendmail {to subject {replyto \"floater@floater.org\"}} {\n"
"    set f [open \"| /usr/lib/sendmail $to\" w]\n"
"    puts $f \"From: Floater <$replyto>\"\n"
"    puts $f \"To: $to\"\n"
"    puts $f \"Reply-To: $replyto\"\n"
"    puts $f \"X-URL: http://www.floater.org/\"\n"
"    puts $f \"Subject: $subject\"\n"
"    puts $f \"\"\n"
"    return $f\n"
"}\n"
"\n"
"proc welcomeemail {name addr password} {\n"
"    set e [sendmail $addr \"Welcome to Floater!\"]\n"
"    puts $e \"Thanks for playing Floater!\"\n"
"    puts $e \"\"\n"
"    puts $e \"Your account name is: $name\"\n"
"    puts $e \"Your initial account password is: $password\"\n"
"    puts $e \"\"\n"
"    puts $e \"(Be sure to enter upper case letters as upper case, and lower\"\n"
"    puts $e \"case letters as lower case.)\"\n"
"    puts $e \"\"\n"
"    puts $e \"You may change your Floater password at any time by using\"\n"
"    puts $e \"the Change Pasword command of the File menu.  We recommend\"\n"
"\n"
"    puts $e \"using a password that is different from passwords that you\"\n"
"    puts $e \"may be using for other purposes.\"\n"
"    puts $e \"\"\n"
"    puts $e \"We hope you enjoy playing the game!\"\n"
"    puts $e \"\"\n"
"    puts $e \"Best Wishes,\"\n"
"    puts $e \"\"\n"
"    puts $e \"The Floater Team\"\n"
"    puts $e \"\"\n"
"    puts $e \"P.S. This is an automatically generated form letter.  However,\"\n"
"    puts $e \"     if you send us email real people do read it and respond!\"\n"
"    close $e\n"
"}\n"
"\n"
"proc permdo {script} {\n"
"    global writefile\n"
"\n"
"    eval $script\n"
"    exec cat << \"$script\\n\" >> $writefile\n"
"}\n"
"\n"
"proc permset {a b} {\n"
"    global [parenstrip $a] writefile\n"
"\n"
"    puts stdout \"permset $a $b\"\n"
"    set $a $b\n"
"    exec cat << \"set \\{$a\\} \\{$b\\}\\n\" >> $writefile\n"
"}\n"
"\n"
"proc newaccount {name addr password} {\n"
"    global email pw pwx\n"
"\n"
"    permset \"email($name)\" $addr\n"
"    permset \"pw($name)\" $password\n"
"    set pwx([string toupper $name]) $name\n"
"    catch {welcomeemail $name $addr $password}\n"
"}\n"
"\n"
"proc password_fetch {name} {\n"
"    global pw pwx\n"
"    if [info exists pw($name)] {return $pw($name)}\n"
"    return \"\"\n"
"#    set upname [string toupper $name]\n"
"#    if {\"$upname\" != \"$name\"} {\n"
"#	if [info exists pwx($upname)] {\n"
"#	    set r [password_fetch $pwx($upname)]\n"
"#	    if {$r != \"\"} {return $r}\n"
"#	}\n"
"#    }\n"
"#    tryget_nocase pw $name\n"
"}\n"
"\n"
"proc name_fetch {name} {\n"
"    global pw pwx\n"
"    if [info exists pw($name)] {return $name}\n"
"    set upname [string toupper $name]\n"
"    if {\"$upname\" != \"$name\"} {\n"
"	if [info exists pwx($upname)] {\n"
"	    return $pwx($upname)\n"
"	}\n"
"    }\n"
"    foreach i [array names pw] {\n"
"	if ![string compare $upname [string toupper $i]] {return $i}\n"
"    }\n"
"    \n"
"    # shouldn't get here\n"
"    return $name\n"
"}\n"
"\n"
"#############################################################################\n"
"\n"
"proc safeglob {pattern} {\n"
"    if [catch {set s [glob $pattern]}] {return \"\"} {return $s}\n"
"}\n"
"\n"
"proc seen_startup {date1 date2} {\n"
"    global permdir tmpdir flush_interval\n"
"\n"
"    #remove files that aren't *$date1* or *$date2* or directories\n"
"    set junkdir $permdir/junk\n"
"    foreach f [safeglob $permdir/*] {\n"
"	if {![string match *$date1* $f] && ![string match *$date2* $f] &&\n"
"		    ![file isdirectory $f]} {\n"
"	    if ![file exists $junkdir] {catch {floater_mkdir $junkdir}}\n"
"	    catch {exec mv $f $junkdir}\n"
"	}\n"
"    }\n"
"\n"
"    #load all remaining files from permdir (they'll match date1 or date2)\n"
"    foreach f [safeglob $permdir/*] {\n"
"	if ![file isdirectory $f] {\n"
"	    uplevel #0 \"source $f\"\n"
"	    talkmsg \"Loaded $f\"\n"
"	}\n"
"    }\n"
"\n"
"    check_tempdir\n"
"    after [expr $flush_interval / 2] flush_permseenfiles\n"
"}\n"
"\n"
"proc check_tempdir {} {\n"
"    global check_tempdir_interval tmpdir\n"
"\n"
"    after $check_tempdir_interval check_tempdir\n"
"\n"
"    # 10 seconds should allow files being written to be closed\n"
"    after 10000 \"read_tempfiles \\{[safeglob $tmpdir/*]\\}\"\n"
"}\n"
"\n"
"gset checknewweek 1\n"
"\n"
"set to_be_deleted \"\"\n"
"\n"
"proc read_tempfiles {files} {\n"
"    global to_be_deleted\n"
"\n"
"    foreach file $files {\n"
"	talkmsg \"reading $file\"\n"
"	catch {uplevel #0 \"source $file\"}\n"
"    }\n"
"    if {$files != \"\"} {set to_be_deleted \"$to_be_deleted $files\"}\n"
"}\n"
"\n"
"#Make permanent note of the fact that $name has seen $num from $set.\n"
"proc permanent_seen {name set num} {\n"
"    global permseenfiles permdir\n"
"\n"
"    a_h_s $name $set $num\n"
"\n"
"    #if not logged in, return\n"
"    if [regexp \\\\* $name] return\n"
"\n"
"    if ![info exists permseenfiles($set)] {\n"
"	set permseenfiles($set) [open $permdir/$set a]\n"
"    }\n"
"    puts $permseenfiles($set) \"a_h_s \\{$name\\} $set $num\"\n"
"}\n"
"\n"
"proc flush_permseenfiles {} {\n"
"    global permseenfiles flush_interval to_be_deleted tmpdir\n"
"\n"
"    puts \"flushing permseenfiles\"\n"
"    foreach f [array names permseenfiles] {catch {flush $permseenfiles($f)}}\n"
"    if {$to_be_deleted != \"\"} {\n"
"	puts \"Deleting files from $tmpdir\"\n"
"	catch {eval \"file delete $to_be_deleted\"}\n"
"	set to_be_deleted \"\"\n"
"    }\n"
"    after $flush_interval flush_permseenfiles\n"
"}\n"
"\n"
"#############################################################################\n"
"\n"
"proc remove_stale_locations {} {\n"
"    global stale_locations_seconds lastlocation lastlocation_timestamp \\n"
"	    floaterclock\n"
"\n"
"    after [expr 1000 * $stale_locations_seconds] remove_stale_locations\n"
"\n"
"    foreach i [array names lastlocation_timestamp] {\n"
"	if {[expr $floaterclock - $lastlocation_timestamp($i)] >\n"
"					        $stale_locations_seconds} \\n"
"		{\n"
"		    unset lastlocation_timestamp($i)\n"
"		    unset lastlocation($i)\n"
"		}\n"
"    }\n"
"}\n"
"\n"
"tryset stale_locations_seconds 500\n"
"remove_stale_locations\n"
"\n"
"proc bgerror {m} {talkmsg $m}\n"
"\n"
"#############################################################################\n"
"\n"
"gset testConnTime 15\n"
"\n"
"# Return whether a test connection to the given IPaddr:port succeeds.\n"
"# Don't allow any test to take longer than testConnTime seconds.\n"
"proc testConn {IPaddr port} {\n"
"    # if IPaddr is foo!bar then recursively test foo and bar\n"
"    if {[string first ! $IPaddr] >= 0} {\n"
"	foreach part [split $IPaddr !] {\n"
"	    if {[testConn $part $port] == \"y\"} {return \"y\"}\n"
"	}\n"
"	return \"n\"\n"
"    }\n"
"\n"
"    # max time per addr/port pair (in ms)\n"
"    global testConnTime default_handshake\n"
"    set timeout [expr $testConnTime * 10000]\n"
"    # frequency to check if socket creation failed (in ms)\n"
"    set timestep 500\n"
"    # min delay between reading lines from telnet\n"
"    set linetimestep 10\n"
"\n"
"    if [catch {set f [open \"|telnet $IPaddr $port\"]} err] {\n"
"	set q 1\n"
"    } else {\n"
"	set q [catch {\n"
"	    fconfigure $f -blocking 0\n"
"	    set happy 0\n"
"	    for {set i 0} {!$happy && $i < $timeout} {incr i $timestep} {\n"
"		set s [gets $f]\n"
"		puts \"testConn $IPaddr: $s\"\n"
"		if {$s == \"\" && [fblocked $f]} {\n"
"		    after $timestep\n"
"		} else {\n"
"		    if [regexp $default_handshake $s] {\n"
"			set happy 1\n"
"		    } elseif {[eof $f]} {\n"
"			return \"eof\"\n"
"		    } else {\n"
"			after $linetimestep\n"
"		    }\n"
"		}\n"
"	    }\n"
"	    if !$happy { return \"timeout\" }\n"
"	} err]\n"
"    }\n"
"    catch { close $f }\n"
"    if $q {\n"
"	puts \"testing conn $IPaddr $port: failed ($err)\"\n"
"	return \"n\"\n"
"    } else {\n"
"	puts \"testing conn $IPaddr $port: succeeded\"\n"
"	return \"y\"\n"
"    }\n"
"}\n"
"\n"
"# timeout in seconds\n"
"gset testConnInBackgroundTime 120\n"
"\n"
"# The new, preferred alternative to testConn (above).\n"
"# Works with Floater 1.3b1 on.\n"
"proc testConnInBackground {IPaddr port} {\n"
"    # if IPaddr is foo!bar then recursively test foo and bar\n"
"    if {[string first ! $IPaddr] >= 0} {\n"
"	foreach part [split $IPaddr !] {\n"
"	    testConnInBackground $part $port\n"
"	}\n"
"	return\n"
"    }\n"
"    \n"
"    global you_may_host testConnInBackgroundTime \n"
"    set maxseconds $testConnInBackgroundTime\n"
"    if [catch {\n"
"	set s [socket -async $IPaddr $port] \n"
"	fconfigure $s -blocking 0\n"
"	puts $s $you_may_host\n"
"	flush $s\n"
"	after $maxseconds \"catch { close $s }\"\n"
"    } x] {\n"
"	puts \"Error in testConnInBackground: $x\"\n"
"    }\n"
"}\n"
"    \n"
"#############################################################################\n"
"\n"
"\n"
"tryset tables \"\"\n"
"\n"
"proc notetables {s time} {\n"
"    global tables\n"
"\n"
"    puts stderr \"notetables\"\n"
"    if {$tables == $s} return\n"
"    set tables $s\n"
"    construct_activity_webpage $time\n"
"}\n"
"\n"
"gset minlogin 1\n"
"gset maxlogin 0\n"
"\n"
"proc notelogin {name time} {\n"
"    global logins maxlogin logins_timestamp floaterclock\n"
"\n"
"    incr maxlogin\n"
"    set logins($maxlogin) \"$time: <b>$name</b> </br>\"\n"
"    set logins_timestamp($maxlogin) $floaterclock\n"
"    construct_activity_webpage $time\n"
"}\n"
"\n"
"tryset login_trim_seconds 3600\n"
"\n"
"proc trim_logins {} {\n"
"    global logins maxlogin minlogin logins_timestamp floaterclock \\n"
"	    login_trim_seconds\n"
"\n"
"    # puts stderr trim_logins\n"
"    while {$minlogin <= $maxlogin} {\n"
"	if {[expr $logins_timestamp($minlogin) + $login_trim_seconds]\n"
"		< $floaterclock} {\n"
"	    # puts stderr \"trimming $logins($minlogin)\"\n"
"	    unset logins_timestamp($minlogin)\n"
"	    unset logins($minlogin)\n"
"	    incr minlogin\n"
"	} else return\n"
"    }\n"
"}\n"
"\n"
"gset last_construction_of_activity_webpage -9999\n"
"\n"
"# time is the textual time stamp to put on the page.  retry is whether\n"
"# to try again later if it turns out that right now is too soon to\n"
"# create a new version.\n"
"proc construct_activity_webpage {time {retry 1}} {\n"
"    global logins maxlogin minlogin logins_timestamp tables floaterclock \\n"
"	    last_construction_of_activity_webpage\n"
"\n"
"    # minimum number of seconds between updates\n"
"    set waittime 60\n"
"\n"
"    puts stderr \"construct_activity_webpage $time\"\n"
"    if {[expr $floaterclock - $last_construction_of_activity_webpage]\n"
"            < $waittime} {\n"
"	# puts stderr \"too soon\"\n"
"        if $retry {\n"
"	    after [expr 1000 * ($waittime + 5 - \\n"
"		($floaterclock - $last_construction_of_activity_webpage))] \\n"
"		\"construct_activity_webpage \\{$time\\} 0\"\n"
"	}\n"
"	return\n"
"    }\n"
"\n"
"    trim_logins\n"
"    set recent_logins \"\"\n"
"    for {set i $minlogin} {$i <= $maxlogin} {incr i} {\n"
"	set recent_logins $logins($i)$recent_logins\n"
"    }	\n"
"    \n"
"    update_activity_webpage $recent_logins $tables $time\n"
"}\n"
"\n"
"\n"
"\n"
"tryset saved_recent_logins \"\"\n"
"tryset saved_tables \"\"\n"
"\n"
"set activity_webpage_filename $webdir/activity.html\n"
"\n"
"proc update_activity_webpage {recent_logins tables creation_time} {\n"
"    global saved_recent_logins saved_tables activity_webpage_filename \\n"
"	    last_construction_of_activity_webpage floaterclock\n"
"\n"
"    set last_construction_of_activity_webpage $floaterclock\n"
"     puts stderr update_activity_webpage\n"
"\n"
"    if {$saved_recent_logins == $recent_logins && $saved_tables == $tables} {\n"
"	puts stderr \"update_activity_webpage: no change, aborting\"\n"
"	    return\n"
"    }\n"
"\n"
"    set saved_recent_logins $recent_logins\n"
"    set saved_tables $tables\n"
"\n"
"    set page \"<html><head><TITLE>Floater Activity</TITLE></head>\n"
"<body bgcolor=\\\"#ffffff\\\" text=\\\"#000000\\\" link=\\\"#CC0000\\\" alink=\\\"#FF3300\\\" vlink=\\\"#0000CC\\\">\n"
"\n"
"<h2>Floater Activity: $creation_time</h2>\n"
"\n"
"Tables:\n"
"\n"
"$tables\n"
"<p>\n"
"Recent Logins:\n"
"<p>\n"
"$recent_logins\n"
"<p>\n"
"This page is automatically updated to reflect recent Floater activity.\n"
"All times are local to Atlanta, Georgia, USA.\n"
"This version was created at $creation_time.  New versions are created\n"
"whenever there is new information, but at most once per minute.  You may\n"
"have to reload to get the latest info.\n"
"<p>\n"
"\n"
"<hr>\n"
"<A HREF=http://www.floater.org>Floater</A>\n"
"\"\n"
"\n"
"     puts stderr \"creating $activity_webpage_filename\"\n"
"    if [catch {set f [open $activity_webpage_filename w]}] return\n"
"\n"
"    puts $f $page\n"
"    close $f\n"
"}\n"
"\n"
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Floater Bridge Network.
 *
 * The Initial Developer of the Original Code is
 * Geoff Pike <pike@EECS.Berkeley.EDU>.
 * Portions created by the Initial Developer are Copyright (C) 1996-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *     Lex Spoon <lex@cc.gatech.edu>
 *
 * Alternatively, the contents of this file may be used under the
 * terms of either the GNU General Public License Version 2 or later
 * (the "GPL"), in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of the MPL,
 * indicate your decision by deleting the provisions above and replace
 * them with the notice and other provisions required by the GPL. If
 * you do not delete the provisions above, a recipient may use your
 * version of this file under the terms of either the MPL or the GPL.
 * ***** END LICENSE BLOCK ***** */
};

#define numfiles (sizeof(tcl2cfiles) / sizeof(tcl2cfiles[0]))

void source(const char *s)
{
  int i;

  s = STRCAT(s, ".tcl");
  for (i = 0; i < numfiles; i++)
    if (streq(s, tcl2cfilenames[i])) {
      TclDo3("uplevel #0 {", tcl2cfiles[i], "}");
      return;
    }
  assert(0);
}
#endif /* TCL_IN_C */
