%if 0%{!?_with_gstreamer08:1}
%define         gst_minver      0.10.1
%define         gstpb_minver    0.10.1
%define         gstpy_minver    0.10.0
%define         pygtk_minver    2.8.0
%else
%define         gst_minver      0.8.8
%define         gstp_minver     0.8.8
%define         gstpy_minver    0.8.1
%define         pygtk_minver    2.4.3
%endif

%{!?gstreamer:  %define         gstreamer       gstreamer}

Name:           flumotion
Version:        0.2.2
Release:        1
Summary:        Flumotion - the Fluendo Streaming Server

Group:          Applications/Internet
License:	GPL
URL:            http://www.flumotion.net/
Source:         http://www.flumotion.net/src/flumotion/%{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root

Requires:	python >= 2.3
Requires:	%{gstreamer} >= %{gst_minver}
Requires:	%{gstreamer}-python >= %{gstpy_minver}
%if 0%{!?_with_gstreamer08:1}
Requires:	%{gstreamer}-plugins-base >= %{gstpb_minver}
%else
Requires:	%{gstreamer}-plugins >= %{gstp_minver}
%endif
Requires:	python-twisted >= 1.3.0
Requires:	pygtk2 >= %{pygtk_minver}
Requires:	python-imaging
Requires:	pyOpenSSL
Requires:	pkgconfig

# for make-dummy-cert to work
Requires(post):	openssl

BuildRequires:	%{gstreamer}-devel >= %{gst_minver}
BuildRequires:	%{gstreamer}-python >= %{gstpy_minver}
BuildRequires:	python-twisted >= 1.3.0
BuildRequires:	python-devel >= 2.3
BuildRequires:	pygtk2-devel >= %{pygtk_minver}
BuildRequires:	gtk2-devel

# docs
BuildRequires:	epydoc

# sigh, libtool
BuildRequires:  gcc-c++

BuildRequires:	desktop-file-utils

# since we compile pytrayicon, we're no longer noarch
# BuildArch:	noarch

%description
Flumotion, the Fluendo Streaming Server.

Flumotion can work with GStreamer 0.8 and/or 0.10.

By default it will build against the 0.10 GStreamer version.  To use 0.8
instead, use:
  --with gstreamer08

To define the base name of GStreamer packages to build against
(gstreamer, gstreamer08 or gstreamer010, depending on your distro), use e.g.:
  --define 'gstreamer gstreamer010'
These packages should of course match your choice of building or not building
with gstreamer08.

%prep
%setup -q

%build
%configure

make

%install
rm -rf $RPM_BUILD_ROOT

# use DESTDIR so compiled python files get tagged correctly with their
# final location
make DESTDIR=$RPM_BUILD_ROOT install

# desktop file
desktop-file-install \
  --vendor fedora \
  --mode 644 \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  --add-category X-Fedora \
  --delete-original \
  $RPM_BUILD_ROOT%{_datadir}/applications/flumotion-admin.desktop

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/flumotion

# install make-dummy-cert script
install -d $RPM_BUILD_ROOT%{_datadir}/flumotion
install -m 644 \
	doc/redhat/make-dummy-cert \
	$RPM_BUILD_ROOT%{_datadir}/flumotion

# install service files
install -d $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d
install -m 755 \
	doc/redhat/flumotion \
	$RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d

# create log and run and cache directory
install -d $RPM_BUILD_ROOT%{_localstatedir}/log/flumotion
install -d $RPM_BUILD_ROOT%{_localstatedir}/run/flumotion
install -d $RPM_BUILD_ROOT%{_localstatedir}/cache/flumotion

%find_lang flumotion

%clean
rm -rf $RPM_BUILD_ROOT

%pre
/usr/sbin/useradd -s /sbin/nologin \
	-r -d %{_localstatedir}/cache/flumotion -M \
	flumotion > /dev/null 2> /dev/null || :
# for old installs, we need to move the homedir
/usr/sbin/usermod -d %{_localstatedir}/cache/flumotion \
	flumotion > /dev/null 2> /dev/null || :

%post
/sbin/chkconfig --add flumotion
# generate a default .pem certificate ?
PEM_FILE="%{_sysconfdir}/flumotion/default.pem"
if ! test -e ${PEM_FILE}
then
  sh %{_datadir}/flumotion/make-dummy-cert ${PEM_FILE}
  chown :flumotion ${PEM_FILE}
  chmod 640 ${PEM_FILE}
fi

# create a default planet config if no manager configs present
# the default login will be user/test
if ! test -e %{_sysconfdir}/flumotion/managers
then
  mkdir -p %{_sysconfdir}/flumotion/managers/default/flows
  cat > %{_sysconfdir}/flumotion/managers/default/planet.xml <<EOF
<planet>
 
  <manager>
    <!-- <debug>3</debug> -->
    <host>localhost</host>
<!--
    <port>7531</port>
    <transport>ssl</transport>
    <!-- certificate path can be relative to $sysconfdir/flumotion,
         or absolute -->
    <certificate>default.pem</certificate>
-->
    <component name="manager-bouncer" type="htpasswdcrypt">
      <property name="data"><![CDATA[
user:PSfNpHTkpTx1M
]]></property>
    </component>
  </manager>
 
</planet>
EOF
fi

# create a default worker config if no worker configs present
# the default login will be user/test
if ! test -e %{_sysconfdir}/flumotion/workers
then
  mkdir -p %{_sysconfdir}/flumotion/workers
  cat > %{_sysconfdir}/flumotion/workers/default.xml <<EOF
<worker>
 
  <!-- <debug>3</debug> -->

  <manager>
<!--
    <host>localhost</host>
    <port>7531</port>
-->
  </manager>

  <authentication type="plaintext">
    <username>user</username>
    <password>test</password>
  </authentication>
 
  <!-- <feederports>8600-8639</feederports> -->

</worker>
EOF

fi

%preun
/sbin/chkconfig --del flumotion
# if removal and not upgrade, stop the processes, clean up locks
if [ $1 -eq 0 ]
then
  /sbin/service flumotion stop > /dev/null

  rm -rf %{_localstatedir}/lock/flumotion*
  rm -rf %{_localstatedir}/run/flumotion*
fi

# Think about this first, we don't really want to stop everything
#%postun
# if [ $1 -ge 1 ]; then
#   /sbin/service flumotion condrestart
# fi

%files -f flumotion.lang
%defattr(-,root,root,-)
%doc ChangeLog COPYING README AUTHORS flumotion.doap
%doc doc/reference/html
%doc conf
%{_bindir}/flumotion-manager
%{_bindir}/flumotion-worker
%{_bindir}/flumotion-admin
%{_bindir}/flumotion-admin-text
%{_bindir}/flumotion-command
%{_bindir}/flumotion-tester
%{_bindir}/flumotion-job
%{_bindir}/flumotion-inspect
%{_bindir}/flumotion-launch
%{_sbindir}/flumotion

%{_libdir}/flumotion
%{_libdir}/pkgconfig/flumotion.pc

%{_datadir}/applications/*.desktop
%{_datadir}/pixmaps/*
%{_mandir}/man1/flumotion*.1*

%{_datadir}/flumotion/glade
%{_datadir}/flumotion/image
%{_datadir}/flumotion/make-dummy-cert
%{_datadir}/flumotion/*.xsl

%attr(750,flumotion,root) %{_sysconfdir}/flumotion
%attr(750,flumotion,root) %{_localstatedir}/run/flumotion
%attr(750,flumotion,root) %{_localstatedir}/log/flumotion
%attr(750,flumotion,root) %{_localstatedir}/cache/flumotion
%{_sysconfdir}/rc.d/init.d/flumotion

%changelog
* Sun Jun 18 2006 Thomas Vander Stichele <thomas at apestaart dot org>
- only create default worker if there is not /etc/flumotion/workers
- only create default manager if there is not /etc/flumotion/managers
- make gstreamer versions defines
- change flumotion home directory to /var/cache/flumotion

* Fri Jul 29 2005 Thomas Vander Stichele <thomas at apestaart dot org>
- added translations

* Thu May 19 2005 Thomas Vander Stichele <thomas at apestaart dot org>
- use disted make-dummy-cert

* Mon Feb 14 2005 Christian Schaller <christian at fluendo dot com>
- Add desktop file for admin tool and icon

* Thu Nov 11 2004 Thomas Vander Stichele <thomas at apestaart dot org>
- Integrate changes from issue 86

* Fri Nov 05 2004 Christian Schaller <christian at fluendo com>
- Add call to chkconfig script in post and preun parts to get our service into 
  the service list

* Fri Nov 05 2004 Thomas Vander Stichele <thomas at apestaart dot org>
- use DESTDIR install to fix python compiles

* Mon Jun 07 2004 Thomas Vander Stichele <thomas at apestaart dot org>
- first package
