/********************************************************************************
*                                                                               *
*                          C o l o r   S e l e c t o r                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2002 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXColorSelector.cpp,v 1.43.4.1 2003/06/20 19:02:07 fox Exp $              *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "fxpriv.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXSize.h"
#include "FXPoint.h"
#include "FXRectangle.h"
#include "FXObject.h"
#include "FXObjectList.h"
#include "FXSettings.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXFont.h"
#include "FXDCWindow.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXSeparator.h"
#include "FXLabel.h"
#include "FXColorBar.h"
#include "FXColorWell.h"
#include "FXColorWheel.h"
#include "FXTextField.h"
#include "FXButton.h"
#include "FXPicker.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXTabItem.h"
#include "FXTabBook.h"
#include "FXHorizontalFrame.h"
#include "FXVerticalFrame.h"
#include "FXMatrix.h"
#include "FXShell.h"
#include "FXScrollbar.h"
#include "FXSlider.h"
#include "FXList.h"
#include "FXColorSelector.h"


/*
  Notes:
  - Custom colors in the twentyfour wells are saved to registry for next time you
    run the program.

  - HSV Model:

      green          yellow
            o-----o
           /       \
          /  white  \
    cyan o     o     o red
          \         /
           \       /
            o-----o
      blue           magenta

  - Perhaps this panel should send color change messages to active
    colorwell widget?

  - Still need a way to pick a color from the screen:- look at WindowMaker.
*/

/*******************************************************************************/


// Map
FXDEFMAP(FXColorSelector) FXColorSelectorMap[]={
  FXMAPFUNC(SEL_CHANGED,FXColorSelector::ID_COLOR,FXColorSelector::onChgColor),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_COLOR,FXColorSelector::onCmdColor),
  FXMAPFUNC(SEL_UPDATE,FXColorSelector::ID_ALPHA_SLIDER,FXColorSelector::onUpdAlphaSlider),
  FXMAPFUNC(SEL_UPDATE,FXColorSelector::ID_ALPHA_TEXT,FXColorSelector::onUpdAlphaText),
  FXMAPFUNC(SEL_UPDATE,FXColorSelector::ID_ALPHA_LABEL,FXColorSelector::onUpdAlphaLabel),
  FXMAPFUNC(SEL_CHANGED,FXColorSelector::ID_ALPHA_SLIDER,FXColorSelector::onCmdAlphaSlider),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_ALPHA_SLIDER,FXColorSelector::onCmdAlphaSlider),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_ALPHA_TEXT,FXColorSelector::onCmdAlphaText),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_RGB_RED_TEXT,FXColorSelector::ID_RGB_BLUE_TEXT,FXColorSelector::onUpdRGBText),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_HSV_HUE_TEXT,FXColorSelector::ID_HSV_VALUE_TEXT,FXColorSelector::onUpdHSVText),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_CMY_CYAN_TEXT,FXColorSelector::ID_CMY_YELLOW_TEXT,FXColorSelector::onUpdCMYText),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_RGB_RED_TEXT,FXColorSelector::ID_RGB_BLUE_TEXT,FXColorSelector::onCmdRGBText),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_HSV_HUE_TEXT,FXColorSelector::ID_HSV_VALUE_TEXT,FXColorSelector::onCmdHSVText),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_CMY_CYAN_TEXT,FXColorSelector::ID_CMY_YELLOW_TEXT,FXColorSelector::onCmdCMYText),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_RGB_RED_SLIDER,FXColorSelector::ID_RGB_BLUE_SLIDER,FXColorSelector::onUpdRGBSlider),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_HSV_HUE_SLIDER,FXColorSelector::ID_HSV_VALUE_SLIDER,FXColorSelector::onUpdHSVSlider),
  FXMAPFUNCS(SEL_UPDATE,FXColorSelector::ID_CMY_CYAN_SLIDER,FXColorSelector::ID_CMY_YELLOW_SLIDER,FXColorSelector::onUpdCMYSlider),
  FXMAPFUNCS(SEL_CHANGED,FXColorSelector::ID_RGB_RED_SLIDER,FXColorSelector::ID_RGB_BLUE_SLIDER,FXColorSelector::onCmdRGBSlider),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_RGB_RED_SLIDER,FXColorSelector::ID_RGB_BLUE_SLIDER,FXColorSelector::onCmdRGBSlider),
  FXMAPFUNCS(SEL_CHANGED,FXColorSelector::ID_HSV_HUE_SLIDER,FXColorSelector::ID_HSV_VALUE_SLIDER,FXColorSelector::onCmdHSVSlider),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_HSV_HUE_SLIDER,FXColorSelector::ID_HSV_VALUE_SLIDER,FXColorSelector::onCmdHSVSlider),
  FXMAPFUNCS(SEL_CHANGED,FXColorSelector::ID_CMY_CYAN_SLIDER,FXColorSelector::ID_CMY_YELLOW_SLIDER,FXColorSelector::onCmdCMYSlider),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_CMY_CYAN_SLIDER,FXColorSelector::ID_CMY_YELLOW_SLIDER,FXColorSelector::onCmdCMYSlider),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_WELL_CHANGED,FXColorSelector::onCmdWell),
  FXMAPFUNC(SEL_CHANGED,FXColorSelector::ID_WELL_CHANGED,FXColorSelector::onChgWell),
  FXMAPFUNCS(SEL_COMMAND,FXColorSelector::ID_CUSTOM_FIRST,FXColorSelector::ID_CUSTOM_LAST,FXColorSelector::onCmdCustomWell),
  FXMAPFUNCS(SEL_CHANGED,FXColorSelector::ID_CUSTOM_FIRST,FXColorSelector::ID_CUSTOM_LAST,FXColorSelector::onChgCustomWell),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_COLOR_LIST,FXColorSelector::onCmdList),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXColorSelector::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_ACTIVEPANE,FXColorSelector::onCmdActivePane),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_DIAL_WHEEL,FXColorSelector::onCmdWheel),
  FXMAPFUNC(SEL_CHANGED,FXColorSelector::ID_DIAL_WHEEL,FXColorSelector::onCmdWheel),
  FXMAPFUNC(SEL_UPDATE,FXColorSelector::ID_DIAL_WHEEL,FXColorSelector::onUpdWheel),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_COLOR_BAR,FXColorSelector::onCmdBar),
  FXMAPFUNC(SEL_CHANGED,FXColorSelector::ID_COLOR_BAR,FXColorSelector::onCmdBar),
  FXMAPFUNC(SEL_UPDATE,FXColorSelector::ID_COLOR_BAR,FXColorSelector::onUpdBar),
  FXMAPFUNC(SEL_COMMAND,FXColorSelector::ID_COLORPICK,FXColorSelector::onCmdColorPick),
  };


// Object implementation
FXIMPLEMENT(FXColorSelector,FXPacker,FXColorSelectorMap,ARRAYNUMBER(FXColorSelectorMap))


// Well names
const FXchar* FXColorSelector::wellname[24]={
  "wella","wellb","wellc","welld",
  "welle","wellf","wellg","wellh",
  "welli","wellj","wellk","welll",
  "wellm","welln","wello","wellp",
  "wellq","wellr","wells","wellt",
  "wellu","wellv","wellw","wellx"
  };

const unsigned char eyedrop[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf3,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0xa5,0x00,0xff,0x00,0x00,0x8b,0x00,0x00,0x00,
  0x40,0x00,0xff,0xff,0xff,0xaa,0xaa,0xaa,0xdc,0xdc,0xdc,0x80,0x80,0x80,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x04,0x7f,0x10,0xc8,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xbb,0xff,0x60,0x28,0x62,0x41,0x30,0x6a,0x81,0x30,0x98,0xa7,0x95,0x0e,0x04,
  0xc1,0xb6,0xd2,0x1b,0x17,0x73,0x6b,0x13,0x85,0x91,0x8b,0x25,0xd5,0xcd,0x47,0x4b,
  0x15,0x60,0x3c,0x22,0x0d,0x60,0x4c,0xfe,0x46,0x81,0x03,0x42,0x50,0xc0,0x2d,0x99,
  0x87,0x04,0x42,0x21,0x50,0xea,0xb2,0x5b,0x13,0xab,0x4a,0xae,0x7a,0xa2,0x5a,0xc5,
  0xb3,0x4c,0xe6,0xa0,0xc3,0x18,0xb6,0x39,0xf3,0x56,0x6b,0xe4,0x74,0xb0,0xbd,0xd3,
  0xbe,0xd4,0x9f,0x19,0x7d,0x15,0x7f,0x20,0x82,0x13,0x84,0x7c,0x72,0x73,0x88,0x1e,
  0x8a,0x87,0x69,0x80,0x1b,0x6c,0x87,0x0a,0x08,0x25,0x27,0x86,0x01,0x7b,0x2d,0x05,
  0x57,0x9e,0x9f,0xa0,0xa1,0xa2,0x15,0x11,0x00,0x3b
  };


const unsigned char dialmode[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x28,0x00,0x14,0x00,0xc6,0x00,0x00,0xff,0xff,0xff,
  0xec,0xfe,0xd8,0xcc,0xfe,0x9c,0xf4,0xfe,0xac,0xf0,0xfa,0x34,0xe0,0xfe,0x1c,0xb4,
  0xfe,0x40,0x7c,0xfe,0x24,0x24,0xfe,0x20,0x40,0xfe,0x58,0xac,0xfe,0xd4,0xfc,0xee,
  0x5c,0x30,0xfe,0x3c,0x94,0xfe,0x8c,0x00,0x00,0x00,0xfc,0xce,0x4c,0xfc,0xb6,0x18,
  0x94,0xfe,0x60,0x5c,0xfe,0xa0,0xe4,0xfe,0x74,0x5c,0xfe,0x74,0x9c,0xfe,0xb8,0xfc,
  0x7e,0x30,0x24,0xfe,0xc0,0xfc,0x9e,0x5c,0xfc,0xe2,0x98,0x70,0xfe,0xd4,0xfc,0x42,
  0x38,0xfc,0xa6,0x7c,0x44,0xfe,0xe4,0xfc,0xe2,0xd0,0xfc,0x36,0x14,0xfc,0xba,0xc0,
  0xf4,0xfe,0xfc,0xfc,0x62,0x74,0xfc,0x9e,0xac,0xfc,0xfe,0xfc,0xdc,0xee,0xfc,0x78,
  0xf2,0xfc,0x0c,0xf2,0xfc,0xfc,0x72,0xac,0xfc,0xe6,0xf8,0xb0,0xee,0xfc,0x2c,0xda,
  0xfc,0xfc,0x22,0x54,0xf8,0xb2,0xf4,0x84,0xc2,0xfc,0xfc,0x36,0x94,0xfc,0x7e,0xdc,
  0xbc,0xae,0xfc,0x54,0xba,0xfc,0xe0,0x9e,0xfc,0x8c,0x9a,0xfc,0x24,0x8a,0xfc,0xfc,
  0x2a,0xc4,0xfc,0x3e,0xe8,0xf4,0x76,0xfc,0xa0,0x76,0xfc,0x60,0x7a,0xfc,0xc0,0x6a,
  0xfc,0x40,0x62,0xfc,0x8c,0x3a,0xfc,0x68,0x2e,0xfc,0x2c,0x2a,0xfc,0xe4,0x1e,0xfc,
  0xb8,0x36,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x28,0x00,0x14,0x00,0x00,0x07,0xfe,0x80,0x00,0x82,0x83,0x84,0x82,0x01,
  0x02,0x88,0x02,0x85,0x8b,0x8c,0x8d,0x8c,0x03,0x04,0x05,0x06,0x07,0x94,0x08,0x09,
  0x0a,0x8e,0x99,0x99,0x0b,0x05,0x9d,0x06,0x93,0x07,0x0c,0x08,0x08,0x0d,0x85,0x0e,
  0x0e,0x00,0xa7,0x9a,0x8b,0x0f,0x10,0x04,0xaf,0x9f,0x11,0x07,0x09,0x0c,0xb5,0x12,
  0xa6,0xaa,0xaa,0xab,0x00,0xad,0x10,0x0f,0x0b,0x13,0x13,0x06,0x11,0x11,0x14,0x09,
  0xc7,0x0c,0x15,0xbb,0x9a,0x16,0xbe,0xbf,0xc1,0x02,0x0d,0x0d,0x14,0xd4,0xc7,0x17,
  0xcb,0x8e,0x18,0x16,0x16,0x18,0x0f,0x19,0x19,0x03,0x88,0xd2,0x12,0xe4,0x17,0x17,
  0x1a,0xd8,0x8c,0x1b,0xdb,0x18,0x1c,0xdf,0x03,0xe1,0x15,0xf2,0x1a,0x12,0xe6,0x1d,
  0xe9,0x85,0x1e,0x1f,0xeb,0xed,0x20,0x19,0x1e,0x01,0x02,0x28,0x50,0x50,0x41,0x83,
  0x86,0x0e,0xe6,0x42,0x0c,0x42,0xc5,0x70,0x15,0x88,0x7d,0x1b,0x44,0x70,0x18,0x01,
  0xc2,0x03,0x89,0x00,0x25,0x06,0x9a,0x38,0xd8,0xe1,0x84,0xc2,0x54,0xa9,0x72,0x69,
  0x7a,0xb8,0x21,0x22,0x0a,0x8a,0x1e,0x52,0x94,0x28,0xa1,0x42,0x85,0x09,0x13,0x1d,
  0x56,0x78,0xc4,0x37,0x08,0x04,0x0b,0x16,0x22,0x44,0x9c,0x04,0xd1,0x42,0x65,0x4b,
  0x17,0x2e,0x4c,0xac,0x90,0xf9,0x91,0x26,0x80,0x9b,0x2f,0x50,0xa0,0x80,0xd1,0xa2,
  0x69,0x8c,0x18,0x40,0x5d,0xc8,0x90,0x31,0xd4,0xe8,0xa0,0x17,0x2c,0x5e,0x24,0x85,
  0x01,0x63,0xc6,0x8c,0x18,0x34,0xc2,0x4e,0xad,0x51,0xc3,0x85,0x55,0x41,0x20,0xb4,
  0xda,0xb8,0x81,0xa3,0xed,0x8c,0x1c,0x45,0x39,0x74,0xc8,0x25,0x5b,0x63,0x21,0x48,
  0x86,0xa8,0x56,0xa1,0xb0,0xb1,0x96,0xed,0x8e,0x1d,0x70,0x75,0xf0,0x18,0x5c,0x96,
  0x50,0x43,0x5d,0xbb,0xf8,0xde,0x58,0xfc,0xb7,0x47,0x0f,0x1f,0x3f,0x22,0xeb,0x38,
  0xbb,0xe8,0x06,0x90,0xcb,0x41,0x82,0x3c,0x86,0xfc,0x83,0x07,0x65,0x46,0x38,0x30,
  0x6f,0x8e,0x4c,0xe3,0xb3,0xa3,0x19,0x7f,0xe1,0xc6,0xa0,0x1c,0x08,0x00,0x3b
  };


const unsigned char cmymode[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x28,0x00,0x14,0x00,0xf7,0x00,0x00,0xb2,0xc0,0xdc,
  0xff,0xff,0xff,0xf0,0xfc,0xf8,0xe8,0xf8,0xf8,0xe0,0xfc,0xf8,0xd8,0xf8,0xf8,0xd0,
  0xf8,0xf8,0xc8,0xf8,0xf8,0xb8,0xf4,0xf8,0xb0,0xf4,0xf8,0xa8,0xf4,0xf8,0xa0,0xf4,
  0xf8,0x98,0xf4,0xf8,0x98,0xf0,0xf8,0x90,0xf0,0xf8,0x88,0xf0,0xf8,0x80,0xf0,0xf8,
  0x78,0xf0,0xf8,0x70,0xec,0xf8,0x70,0xf0,0xf8,0x68,0xec,0xf8,0x60,0xec,0xf8,0x58,
  0xec,0xf8,0x50,0xec,0xf8,0x48,0xe8,0xf8,0x40,0xec,0xf8,0x40,0xe8,0xf8,0x38,0xe8,
  0xf8,0x30,0xe8,0xf8,0x28,0xe8,0xf8,0xe0,0xe4,0xe0,0xe8,0xe8,0xe8,0x10,0xe4,0xf8,
  0x08,0xe4,0xf8,0x00,0xe4,0xf8,0xe8,0xfc,0xf8,0xd8,0xfc,0xf8,0xd0,0xfc,0xf8,0xc0,
  0xf8,0xf8,0xb8,0xf8,0xf8,0xb0,0xf8,0xf8,0x90,0xf4,0xf8,0x88,0xf4,0xf8,0x80,0xf4,
  0xf8,0x68,0xf0,0xf8,0x58,0xf0,0xf8,0x48,0xec,0xf8,0x80,0x80,0x80,0x38,0x34,0x38,
  0x10,0xe8,0xf8,0xa0,0xf8,0xf8,0x60,0xf0,0xf8,0x38,0xec,0xf8,0xe0,0xe8,0xe8,0x30,
  0x34,0x38,0x00,0xe8,0xf8,0x28,0xec,0xf8,0xa8,0xf8,0xf8,0x38,0x34,0x30,0x08,0xe8,
  0xf8,0xf8,0xf8,0xf8,0xf8,0xf0,0xf8,0xf8,0xec,0xf8,0xf8,0xe4,0xf8,0xe0,0xe8,0xe0,
  0xf8,0xc4,0xf8,0xf8,0xbc,0xf8,0xf8,0xb8,0xf8,0xf0,0xb4,0xf8,0xf8,0xac,0xf8,0xf8,
  0xa4,0xf8,0xf0,0xa0,0xf8,0xf8,0x98,0xf8,0xf0,0x8c,0xf8,0xf8,0x88,0xf8,0xf0,0x84,
  0xf8,0xf0,0x7c,0xf8,0xf0,0x74,0xf8,0xf0,0x6c,0xf8,0xf0,0x68,0xf8,0xf0,0x60,0xf8,
  0xf0,0x58,0xf8,0xf0,0x50,0xf8,0xf0,0x48,0xf8,0xf0,0x44,0xf8,0xf0,0x3c,0xf8,0xf0,
  0x38,0xf8,0xe8,0x30,0xf8,0xf0,0x28,0xf8,0xe8,0x20,0xf8,0xe8,0x18,0xf8,0xf0,0x14,
  0xf8,0xe8,0x0c,0xf8,0xe8,0x08,0xf8,0xe8,0x00,0xf8,0xf8,0xe8,0xf8,0xf8,0xc8,0xf8,
  0xf8,0xc0,0xf8,0xf8,0xb4,0xf8,0xf8,0xa0,0xf8,0xf8,0x90,0xf8,0xf8,0x84,0xf8,0xf8,
  0x7c,0xf8,0xf8,0x74,0xf8,0xf8,0x6c,0xf8,0xf8,0x68,0xf8,0xf8,0x60,0xf8,0xf0,0x54,
  0xf8,0xf0,0x4c,0xf8,0xf0,0x30,0xf8,0xf0,0x20,0xf8,0xf0,0x1c,0xf8,0xf0,0x0c,0xf8,
  0xf0,0x08,0xf8,0xf0,0x00,0xf8,0xf8,0x94,0xf8,0xf8,0x8c,0xf8,0xf8,0x80,0xf8,0xf8,
  0x70,0xf8,0xf8,0x54,0xf8,0xf8,0x44,0xf8,0xf0,0x40,0xf8,0xe8,0x10,0xf8,0xf8,0xa8,
  0xf8,0xf8,0x9c,0xf8,0xf0,0x80,0xf8,0xf8,0x58,0xf8,0xf8,0x4c,0xf8,0xf8,0x38,0xf8,
  0xf0,0x24,0xf8,0xf0,0x04,0xf8,0xf8,0xe0,0xf8,0xf0,0x78,0xf8,0xf0,0x18,0xf8,0xf8,
  0xfc,0xe8,0xf8,0xfc,0xd8,0xf8,0xfc,0xc8,0xf8,0xfc,0xb8,0xf8,0xfc,0xb0,0xf8,0xfc,
  0xa8,0xf8,0xfc,0xa0,0xf8,0xf8,0x90,0xf8,0xfc,0x90,0xf8,0xfc,0x88,0xe8,0xe8,0xe0,
  0xf8,0xfc,0x68,0xf8,0xf8,0x60,0xf8,0xf8,0x50,0xf8,0xfc,0x48,0xf8,0xf8,0x40,0xf8,
  0xf8,0x38,0xf8,0xf8,0x28,0xf8,0xf8,0x20,0xf8,0xf8,0x18,0xf8,0xf8,0x10,0xf8,0xfc,
  0x10,0xf8,0xf8,0x00,0xf8,0xfc,0x00,0xf8,0xfc,0xf0,0xf8,0xfc,0xe0,0xf8,0xfc,0xd0,
  0xf8,0xfc,0xc0,0xf8,0xfc,0x98,0xf8,0xfc,0x70,0xf8,0xfc,0x60,0xf8,0xfc,0x58,0xf8,
  0xfc,0x50,0xf8,0xfc,0x40,0xf8,0xfc,0x38,0xf8,0xfc,0x30,0xf8,0xfc,0x28,0xf8,0xfc,
  0x18,0xf8,0xfc,0x08,0xf8,0xf8,0x48,0xf8,0xfc,0x20,0xf8,0xf8,0x08,0xf8,0xf8,0x70,
  0xf8,0xf8,0x30,0xf8,0xf8,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x28,0x00,0x14,0x00,0x00,0x08,0xfe,0x00,0x01,0x08,0x1c,0x48,0xb0,0xa0,
  0xc1,0x83,0x08,0x0b,0x06,0x10,0x20,0x60,0x00,0x81,0x02,0x06,0x0e,0x1c,0x40,0x80,
  0x20,0x81,0x82,0x05,0x0c,0x1a,0x38,0x78,0x00,0x21,0x82,0x84,0x09,0x14,0x2a,0x58,
  0xb8,0x80,0x21,0x83,0x86,0x0d,0x1c,0x3a,0x78,0xf8,0xe0,0x01,0x44,0x08,0x11,0x02,
  0x03,0x2c,0x1c,0x41,0x80,0x44,0x81,0x12,0x07,0x4c,0x9c,0x40,0x81,0xe2,0x22,0x83,
  0x14,0x2a,0x56,0x74,0x9c,0xc0,0xa2,0x42,0x8b,0x0b,0x17,0x5c,0x64,0x40,0xd9,0xe1,
  0xc3,0x0b,0x18,0x31,0x5e,0xc6,0x9c,0x39,0x82,0x04,0x89,0x88,0x3a,0x4f,0x28,0x50,
  0x20,0x23,0x05,0xd0,0xa1,0x44,0x67,0x8c,0x54,0x4a,0x83,0x46,0xca,0x1a,0x2f,0x6c,
  0xb8,0xbc,0x31,0x95,0x21,0x81,0x87,0x25,0x4c,0xe8,0x44,0x91,0x60,0x01,0xc6,0x14,
  0x0f,0x84,0x46,0x20,0x6a,0x14,0xa9,0x52,0x94,0x38,0x9c,0xc2,0x00,0x21,0x02,0x26,
  0x00,0x99,0x02,0x68,0x12,0x30,0x80,0xf5,0xc4,0x89,0x04,0x39,0xee,0xaa,0xe0,0x38,
  0x81,0xef,0xd8,0x0c,0x4b,0xcf,0xc2,0xd0,0x01,0x62,0x87,0xe1,0x84,0xa0,0x43,0x83,
  0x0e,0xc0,0xa3,0x87,0x8f,0x1f,0x40,0x3e,0x00,0x09,0x22,0x64,0x08,0x91,0x22,0x46,
  0x8e,0x20,0x49,0xa2,0x64,0x09,0x93,0x26,0x4e,0x9e,0x40,0x89,0x22,0x65,0x0a,0x95,
  0x2a,0x56,0xae,0x60,0xc9,0xa2,0x65,0x0b,0x97,0x2e,0x5e,0x62,0x96,0xfe,0xf2,0x43,
  0x30,0x98,0x30,0x43,0xc4,0xc0,0x1e,0x83,0x84,0x8c,0x92,0x32,0x66,0xce,0xa0,0x49,
  0xa3,0x26,0xca,0x1a,0x36,0xbf,0xad,0xfe,0xb4,0xc1,0xe2,0xe6,0xcd,0x16,0x38,0x71,
  0xe4,0x28,0x37,0xdd,0xfc,0x69,0x90,0x30,0x42,0xa4,0x1b,0x19,0x33,0x87,0x0c,0x9d,
  0x3a,0x66,0x9a,0xd8,0xd1,0x1d,0xe5,0xce,0x14,0x3c,0x79,0x88,0x47,0x9e,0x79,0x7a,
  0xa4,0xb7,0xde,0x69,0x82,0xbd,0x17,0x5d,0x11,0x7b,0xf0,0x51,0x9d,0x12,0x7d,0xe4,
  0xb7,0x9f,0x1a,0x7e,0xac,0xf1,0xc7,0x6f,0x80,0x8c,0x17,0x88,0x79,0x70,0x08,0x92,
  0xdc,0x61,0xa5,0xf9,0x30,0xc8,0x07,0x9b,0xbd,0x17,0x1f,0x6c,0x0e,0x5a,0x87,0x1d,
  0x21,0xdb,0xed,0xf6,0x1d,0x15,0x01,0x6a,0x58,0xc8,0x79,0x06,0x8a,0x66,0xe3,0x8d,
  0x53,0x19,0x62,0xc8,0x21,0x3c,0x22,0x82,0x48,0x22,0x89,0x28,0xb2,0x08,0x23,0x8c,
  0x34,0xe2,0xc8,0x23,0x90,0x40,0xf2,0x41,0x24,0x91,0x48,0x32,0xc9,0x24,0x94,0x54,
  0x52,0x89,0x25,0x97,0x5c,0x82,0x49,0x26,0x9a,0x6c,0xc2,0x49,0x27,0x53,0x79,0xa2,
  0xe3,0x27,0xa0,0x80,0x82,0x48,0x28,0x41,0x2a,0x42,0xa4,0x28,0x47,0x0a,0x36,0x4a,
  0x24,0xa4,0x94,0x62,0x8a,0x29,0x94,0x9c,0x82,0x4a,0x2a,0x97,0xa8,0x82,0xc9,0x2a,
  0x9a,0xb0,0xc2,0x49,0x97,0x3a,0xf2,0x28,0x26,0x99,0x89,0x2c,0x32,0x24,0x9a,0x8f,
  0x08,0xc6,0xa4,0x24,0xa5,0x94,0x42,0x49,0x2b,0xa8,0x58,0x42,0xa7,0x2b,0x78,0xb2,
  0xf2,0x0a,0x97,0x87,0x05,0xe0,0x89,0x27,0x9f,0x80,0xf9,0x67,0x99,0x83,0xa6,0xf9,
  0x82,0x0e,0xb0,0xb0,0x59,0x0a,0x94,0x94,0xa0,0x82,0x4a,0x2c,0x76,0xde,0x99,0xe7,
  0x9e,0x95,0x7a,0x99,0xe9,0x21,0x1e,0x9b,0x06,0x49,0xa4,0x23,0x69,0x6e,0xb6,0x26,
  0x29,0xb2,0xbc,0xd9,0xca,0x29,0x8e,0x5e,0xe2,0x8a,0x2b,0x79,0x4e,0x8a,0xe3,0xb0,
  0xc4,0x16,0x8b,0x63,0x40,0x00,0x3b
  };

const unsigned char hsvmode[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x28,0x00,0x14,0x00,0xf7,0x00,0x00,0xb2,0xc0,0xdc,
  0xf8,0x00,0x00,0xf8,0x28,0x00,0xf8,0x50,0x00,0xf8,0x78,0x00,0xf8,0xa0,0x00,0xf8,
  0xc8,0x00,0xf8,0xf0,0x00,0xe0,0xfc,0x00,0xb8,0xfc,0x00,0x90,0xfc,0x00,0x68,0xfc,
  0x00,0x40,0xfc,0x00,0x18,0xfc,0x00,0x00,0xfc,0x10,0x00,0xfc,0x30,0x00,0xfc,0x58,
  0x00,0xfc,0x88,0x00,0xfc,0xa8,0x00,0xfc,0xd0,0x00,0xfc,0xf8,0x00,0xd4,0xf8,0x00,
  0xac,0xf8,0x00,0x84,0xf8,0x00,0x5c,0xf8,0x00,0x34,0xf8,0x00,0x0c,0xf8,0x18,0x00,
  0xf8,0x40,0x00,0xf8,0x68,0x00,0xf8,0x90,0x00,0xf8,0xb8,0x00,0xf8,0xe0,0x00,0xf8,
  0xf8,0x00,0xf0,0xf8,0x00,0xc8,0xf8,0x00,0xa0,0xe0,0xe4,0xe0,0xe8,0xe8,0xe8,0xe8,
  0xfc,0x00,0x98,0xfc,0x00,0x48,0xfc,0x00,0x20,0xfc,0x00,0x00,0xfc,0x08,0x00,0xfc,
  0x38,0x00,0xfc,0x60,0x00,0xfc,0xd8,0x00,0xd8,0xf8,0x00,0x88,0xf8,0x00,0x38,0xf8,
  0x48,0x00,0xf8,0x80,0x80,0x80,0x38,0x34,0x38,0x00,0xfc,0xb0,0x00,0xb0,0xf8,0x98,
  0x00,0xf8,0xe8,0x00,0xf8,0xe8,0xe4,0xe8,0x38,0x34,0x30,0xc0,0xfc,0x00,0x70,0xfc,
  0x00,0x30,0x34,0x38,0xf8,0x00,0xd0,0x38,0x30,0x30,0xff,0xff,0xff,0xf8,0xf8,0xf0,
  0xf8,0xf0,0xf0,0xf8,0xe8,0xe8,0xf8,0xe0,0xe0,0xf8,0xdc,0xd8,0xf8,0xd4,0xd0,0xf8,
  0xcc,0xd0,0xf8,0xc8,0xc8,0xf8,0xc0,0xc0,0xf8,0xbc,0xb8,0xf8,0xb4,0xb0,0xf8,0xb0,
  0xa8,0xf8,0xa8,0xa8,0xf8,0xa0,0xa0,0xf8,0x9c,0x98,0xf8,0x94,0x90,0xf8,0x8c,0x90,
  0xe0,0xe8,0xe0,0xf8,0x74,0x70,0xf8,0x6c,0x68,0xf8,0x64,0x68,0xf8,0x5c,0x58,0xf8,
  0x58,0x58,0xf8,0x50,0x50,0xf8,0x48,0x48,0xf8,0x44,0x40,0xf8,0x3c,0x40,0xf8,0x38,
  0x30,0xf8,0x30,0x30,0xf8,0x28,0x28,0xf8,0x20,0x20,0xf8,0x18,0x18,0xf8,0x14,0x10,
  0xf8,0x0c,0x10,0xf8,0x08,0x08,0xf8,0xf8,0xf8,0xf8,0xe4,0xe0,0xf8,0xdc,0xe0,0xf8,
  0xd8,0xd8,0xf8,0xd0,0xd0,0xf8,0xc4,0xc0,0xf8,0xb4,0xb8,0xf8,0xac,0xb0,0xf8,0x94,
  0x98,0xf8,0x8c,0x88,0xf8,0x68,0x70,0xf8,0x64,0x60,0xf8,0x4c,0x48,0xf8,0x34,0x30,
  0xf8,0x2c,0x30,0xf8,0x1c,0x18,0xf8,0x14,0x18,0xf8,0x04,0x00,0xf8,0xec,0xe8,0xf8,
  0xe4,0xe8,0xf8,0xb0,0xb0,0xf8,0xa8,0xa0,0xf8,0x90,0x90,0xf8,0x70,0x70,0xf8,0x5c,
  0x60,0xf8,0x40,0x40,0xf8,0x10,0x18,0xf8,0x0c,0x08,0xf8,0x04,0x08,0xf8,0xe8,0xf0,
  0xf8,0xd4,0xd8,0xf8,0xbc,0xc0,0xf8,0xac,0xa8,0xf8,0x9c,0xa0,0xf8,0x6c,0x70,0xf8,
  0x44,0x48,0xf8,0xa4,0xa0,0xf8,0x98,0x98,0x30,0x34,0x30,0xf8,0x3c,0x38,0xf8,0x38,
  0x38,0xf8,0x1c,0x20,0x00,0x00,0x00,0x08,0x00,0x00,0x10,0x00,0x00,0x18,0x00,0x00,
  0x20,0x00,0x00,0x28,0x00,0x00,0x38,0x00,0x00,0x40,0x00,0x00,0x48,0x00,0x00,0x50,
  0x00,0x00,0x58,0x00,0x00,0x68,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x88,0x00,
  0x00,0x90,0x00,0x00,0x98,0x00,0x00,0xe0,0xe8,0xe8,0xe8,0xe8,0xe0,0xb0,0x00,0x08,
  0xb8,0x00,0x00,0xc0,0x00,0x00,0xc8,0x00,0x00,0xd0,0x00,0x00,0xd8,0x00,0x00,0xe0,
  0x00,0x00,0xf0,0x00,0x00,0x30,0x00,0x00,0x60,0x00,0x00,0x80,0x00,0x00,0x88,0x80,
  0x80,0xb0,0x00,0x00,0xe8,0x00,0x00,0xa0,0x00,0x00,0xe8,0xe4,0xe0,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x28,0x00,0x14,0x00,0x00,0x08,0xfe,0x00,0x01,0x08,0x1c,0x48,0xb0,0xa0,
  0xc1,0x83,0x08,0x0b,0x06,0x10,0x30,0x80,0x40,0x01,0x03,0x07,0x10,0x24,0x50,0xb0,
  0x80,0x41,0x03,0x07,0x0f,0x20,0x44,0x90,0x30,0x81,0x42,0x05,0x0b,0x17,0x30,0x64,
  0xd0,0xb0,0x81,0x43,0x07,0x0f,0x1f,0x40,0x84,0x10,0x31,0x82,0x44,0x09,0x12,0x02,
  0x17,0x36,0x7c,0x78,0xc0,0x44,0x82,0x13,0x0b,0x50,0xa4,0x50,0xb1,0x82,0xc5,0xc6,
  0x16,0x14,0x5c,0x58,0x78,0x81,0x01,0x06,0xc9,0x18,0x27,0x53,0xae,0x1c,0x51,0x42,
  0xc6,0x8c,0x98,0x0c,0x1d,0x42,0x94,0x88,0x13,0xc5,0xc5,0x15,0x1a,0x69,0x00,0xad,
  0x50,0x83,0xa8,0xd1,0x92,0x1d,0x6c,0x7c,0xb8,0xb1,0x14,0x87,0x8c,0x1c,0x50,0x67,
  0x42,0x34,0xa1,0x43,0xc1,0x0e,0x8b,0x18,0x35,0x72,0x0c,0x3a,0xb4,0xe8,0xd1,0xa4,
  0x64,0x59,0x36,0xe5,0x91,0x56,0x6a,0xc4,0x9b,0x39,0x77,0x3e,0xf0,0x29,0x61,0x6b,
  0x57,0x91,0x24,0x4d,0x8a,0x25,0xdb,0x63,0x04,0x8e,0x19,0x3e,0x12,0x4a,0x9e,0x4c,
  0xf9,0x07,0x90,0x20,0x42,0x86,0x10,0x29,0x62,0xe4,0x08,0x92,0x24,0x4a,0x96,0x30,
  0x69,0xe2,0xe4,0x09,0x94,0x28,0x25,0xa2,0x48,0x99,0x42,0xa5,0x8a,0x95,0x2b,0x58,
  0xb2,0x68,0xd9,0xc2,0xa5,0x8b,0x97,0x2f,0x60,0xc2,0x88,0x11,0xf8,0x63,0x0c,0x66,
  0x32,0x65,0xcc,0x9c,0x39,0x82,0x26,0x49,0x1a,0x35,0xa3,0x9d,0xac,0x61,0xd3,0x74,
  0x86,0x94,0x36,0x6e,0x5c,0x5f,0x79,0x23,0x1b,0x4e,0x1c,0xdb,0x72,0xe6,0x84,0xa1,
  0xc3,0xdb,0x77,0x1d,0x3b,0x44,0x84,0xfe,0x7b,0x36,0x7e,0x07,0x0f,0xe9,0x3c,0x50,
  0x9a,0xeb,0x61,0xbd,0xe7,0x35,0x16,0x3e,0x5a,0xe0,0xd4,0xf6,0x22,0xa7,0x8f,0x9f,
  0x3f,0xdd,0x83,0x00,0x22,0x33,0x24,0xd0,0x70,0x34,0x82,0xa4,0x31,0xc8,0x68,0x84,
  0x2c,0xd7,0x54,0x0e,0x7a,0x14,0x12,0x9d,0x7b,0x86,0xc4,0x77,0xdd,0x6d,0xf6,0xe1,
  0x07,0x40,0x6f,0x41,0x7c,0x17,0xdc,0x7f,0x82,0x28,0x71,0x07,0x13,0x87,0x20,0x62,
  0x5a,0x09,0x33,0x24,0xb2,0x1e,0x15,0xed,0x4d,0x97,0x85,0x22,0x8b,0xcc,0xc7,0x08,
  0x18,0x7e,0xec,0x46,0xd9,0x8b,0x30,0x0a,0xd4,0x88,0x23,0x8f,0x40,0x02,0x49,0x24,
  0x92,0x48,0x32,0x09,0x25,0x94,0x54,0x62,0x89,0x25,0x97,0x60,0x82,0x49,0x26,0x9a,
  0x68,0xb2,0xc9,0x26,0x9c,0x74,0x12,0x85,0x27,0x9f,0x80,0x12,0x8a,0x28,0xa3,0x8c,
  0x42,0x4a,0x29,0xa6,0x98,0x72,0xca,0x29,0x32,0x3a,0x42,0xe3,0x8d,0x92,0xa0,0x32,
  0xc9,0x8e,0x3e,0x5e,0x92,0x4a,0x2a,0x43,0x6a,0xa2,0xca,0x91,0x49,0x96,0xb0,0xca,
  0x0c,0xac,0x3c,0x29,0x25,0x95,0xa6,0xb4,0x72,0x4a,0x00,0x59,0x3a,0x62,0x23,0x8e,
  0x5e,0x82,0x09,0x24,0x99,0x98,0x14,0x79,0x26,0x27,0x9c,0xb8,0xf2,0x8a,0x0c,0x3c,
  0xb0,0x22,0x0a,0x94,0x53,0x52,0x79,0x25,0x9d,0x00,0xcc,0x68,0x27,0x97,0xa8,0x78,
  0x59,0x49,0x98,0x62,0x96,0xa9,0xca,0x9f,0x9d,0x34,0x67,0x28,0xa2,0x70,0xca,0xc9,
  0xa8,0xa3,0x77,0x76,0x89,0x0a,0x8f,0x61,0xf2,0xe9,0x27,0x92,0x81,0x7e,0x32,0x43,
  0xa1,0x6e,0x26,0x6a,0xe5,0x9c,0x08,0x31,0xc6,0x2a,0xeb,0xac,0x31,0x06,0x04,0x00,
  0x3b
  };

const unsigned char txtmode[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x28,0x00,0x14,0x00,0xf3,0x00,0x00,0xb2,0xc0,0xdc,
  0xf8,0x00,0x00,0x00,0x00,0x00,0xf8,0xec,0x00,0xf8,0xf0,0x00,0x38,0xfc,0x00,0x30,
  0xfc,0x00,0x00,0xfc,0xf8,0x00,0x18,0xf8,0x00,0x1c,0xf8,0xe0,0x00,0xf8,0xd8,0x00,
  0xf8,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x28,0x00,0x14,0x00,0x00,0x04,0x79,0x10,0xc8,0x49,0xab,0xbd,0xb8,0x86,
  0xbd,0xa5,0x98,0xc2,0x07,0x8a,0xa1,0x98,0x69,0x5c,0x60,0x85,0x14,0xeb,0x9e,0x70,
  0x2c,0x9f,0x43,0x5d,0x7b,0x23,0x0e,0x7c,0x24,0xcf,0xef,0x26,0x4a,0x8d,0x30,0x20,
  0xac,0x48,0x1e,0x53,0xef,0x35,0x6b,0x3a,0x25,0x85,0x68,0xc1,0xa0,0x03,0xb6,0x96,
  0x4e,0x69,0xf4,0x78,0xb5,0x06,0x9f,0xe0,0xe7,0x61,0x3c,0xae,0xfe,0x7c,0xc0,0x92,
  0x1a,0x46,0x2e,0x57,0xce,0xc9,0x5f,0x3a,0x4c,0x97,0x21,0x10,0x89,0xbc,0x39,0xc8,
  0x9a,0x37,0xef,0x09,0x77,0x5c,0x39,0x4c,0x75,0x86,0x30,0x0a,0x0a,0x0b,0x8a,0x7b,
  0x3a,0x72,0x2e,0x67,0x0c,0x17,0x89,0x94,0x83,0x3d,0x20,0x71,0x72,0x87,0x9b,0x9c,
  0x32,0x11,0x00,0x3b
  };

const unsigned char rgbmode[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x28,0x00,0x14,0x00,0xf7,0x00,0x00,0xb2,0xc0,0xdc,
  0x08,0x00,0x00,0x10,0x00,0x00,0x18,0x00,0x00,0x20,0x00,0x00,0x28,0x00,0x00,0x30,
  0x00,0x00,0x38,0x00,0x00,0x40,0x00,0x00,0x48,0x00,0x00,0x50,0x00,0x00,0x58,0x00,
  0x00,0x60,0x00,0x00,0x68,0x00,0x00,0x70,0x00,0x00,0x78,0x00,0x00,0x80,0x00,0x00,
  0x88,0x00,0x00,0x90,0x00,0x00,0x98,0x00,0x00,0xe0,0xe4,0xe0,0xe8,0xe8,0xe8,0xb8,
  0x00,0x00,0xc0,0x00,0x00,0xc8,0x00,0x00,0xd0,0x00,0x00,0xd8,0x00,0x00,0xe0,0x00,
  0x00,0xe8,0x00,0x00,0xf0,0x00,0x00,0xa0,0x00,0x00,0x80,0x80,0x80,0x38,0x34,0x38,
  0xe8,0xe4,0xe0,0x38,0x34,0x30,0xf8,0x00,0x00,0xb0,0x00,0x00,0x30,0x34,0x30,0x00,
  0x04,0x00,0x00,0x0c,0x00,0x00,0x14,0x00,0x08,0x18,0x00,0x08,0x20,0x00,0x08,0x24,
  0x00,0x08,0x2c,0x00,0x10,0x34,0x00,0x10,0x4c,0x00,0x10,0x50,0x00,0x10,0x58,0x00,
  0x10,0x5c,0x00,0x18,0x64,0x00,0x18,0x6c,0x00,0x18,0x70,0x00,0x18,0x78,0x00,0x18,
  0x7c,0x00,0x20,0x84,0x00,0x20,0x8c,0x00,0x18,0x90,0x00,0x20,0x98,0x00,0x20,0x9c,
  0x00,0x20,0xa4,0x00,0x20,0xac,0x00,0x20,0xb0,0x00,0x28,0xb8,0x00,0x28,0xbc,0x00,
  0x28,0xc4,0x00,0x28,0xc8,0x00,0x28,0xd0,0x00,0x28,0xd8,0x00,0x28,0xe0,0x00,0x30,
  0xe4,0x00,0x30,0xe8,0x00,0x30,0xf0,0x00,0x08,0x14,0x00,0x00,0x24,0x00,0x08,0x34,
  0x00,0xe0,0xe4,0xe8,0x10,0x54,0x00,0x18,0x60,0x00,0x18,0x68,0x00,0x10,0x6c,0x00,
  0x18,0x80,0x00,0x18,0x84,0x00,0x18,0x8c,0x00,0x20,0xa0,0x00,0x28,0xb0,0x00,0x20,
  0xc0,0x00,0x28,0xcc,0x00,0x28,0xd4,0x00,0x30,0xe0,0x00,0x28,0xec,0x00,0x00,0x18,
  0x00,0x00,0x20,0x00,0x10,0x60,0x00,0x10,0x68,0x00,0x18,0x74,0x00,0x20,0x94,0x00,
  0x20,0xb4,0x00,0x20,0xb8,0x00,0x28,0xe4,0x00,0x30,0xec,0x00,0xe0,0xe8,0xe8,0x10,
  0x70,0x00,0x28,0xc0,0x00,0x10,0x64,0x00,0x18,0x88,0x00,0x00,0x00,0x08,0x00,0x00,
  0x10,0x00,0x00,0x18,0x00,0x00,0x20,0x08,0x00,0x28,0x00,0x00,0x28,0x00,0x00,0x30,
  0x08,0x00,0x38,0x08,0x00,0x40,0x08,0x00,0x48,0x00,0x00,0x50,0x08,0x00,0x50,0x08,
  0x00,0x58,0x08,0x00,0x60,0x08,0x00,0x68,0x08,0x00,0x70,0x08,0x00,0x88,0x08,0x00,
  0x90,0x08,0x00,0x98,0x08,0x00,0xa0,0x08,0x00,0xa8,0x08,0x00,0xb0,0x10,0x00,0xc0,
  0x10,0x00,0xc8,0x08,0x00,0xd0,0x10,0x00,0xd8,0x10,0x00,0xe0,0x10,0x00,0xe8,0x10,
  0x00,0xf0,0x08,0x00,0x20,0x00,0x00,0x38,0x00,0x00,0x40,0x00,0x00,0x48,0x00,0x00,
  0x58,0x00,0x00,0x60,0x10,0x00,0x88,0x10,0x00,0xa0,0x10,0x00,0xb0,0x10,0x00,0xb8,
  0x08,0x00,0xc0,0x10,0x00,0xd0,0x08,0x00,0xf0,0x08,0x00,0x30,0x00,0x00,0x68,0x08,
  0x00,0x78,0x08,0x00,0xc8,0x08,0x00,0xd8,0x08,0x00,0xe0,0x08,0x00,0xb8,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x28,0x00,0x14,0x00,0x00,0x08,0xfe,0x00,0x01,0x08,0x1c,0x48,0xb0,0xa0,
  0xc1,0x83,0x08,0x0b,0x06,0x08,0x20,0x60,0x00,0x81,0x02,0x05,0x0c,0x1c,0x40,0x90,
  0x20,0x81,0x82,0x05,0x0c,0x18,0x34,0x70,0xf0,0xe0,0x01,0x84,0x08,0x12,0x26,0x4c,
  0xa0,0x50,0x81,0x82,0x05,0x0b,0x17,0x30,0x64,0xc8,0xa0,0x61,0x03,0x87,0x0e,0x02,
  0x17,0x0e,0x70,0xf8,0xf0,0xc0,0x44,0x8a,0x17,0x35,0x3a,0xe0,0xf8,0x51,0x42,0x48,
  0x0f,0x15,0x3e,0x80,0x40,0x89,0x41,0x65,0x4b,0x0e,0x2f,0x63,0x06,0x98,0xf9,0xd0,
  0x80,0x44,0x9c,0x39,0x1b,0x6c,0xf4,0x18,0x01,0xe4,0x04,0x0f,0x21,0x3e,0x88,0x40,
  0x79,0x61,0xe5,0x51,0x0e,0x23,0x94,0x36,0x7c,0x18,0x71,0x62,0xc5,0xa8,0x53,0x3f,
  0x46,0x10,0x09,0x54,0x28,0x89,0x94,0x46,0x5d,0x26,0x05,0x20,0x93,0x66,0x01,0x9b,
  0x14,0x13,0x2c,0xc0,0x28,0xb5,0xa3,0xda,0x9f,0x21,0x40,0x94,0xe0,0xea,0x55,0x2e,
  0xcc,0x84,0x88,0x13,0x27,0x36,0x71,0x02,0x45,0x0a,0x15,0x2b,0x58,0xb4,0x20,0x19,
  0xc2,0xc5,0x0b,0x18,0x31,0x64,0xcc,0xa0,0x51,0xc3,0xc6,0x0d,0x1c,0x39,0x74,0xec,
  0xe0,0xd1,0xc3,0xc7,0x0f,0x20,0x41,0x84,0x0c,0x21,0x52,0xc4,0xc8,0x11,0x24,0x02,
  0x19,0x27,0x79,0xac,0x84,0xc5,0x12,0x26,0x42,0x5d,0x34,0x81,0xe1,0xe4,0x09,0x14,
  0x1a,0x36,0xa2,0x48,0x99,0x12,0x9a,0x0a,0xe9,0x2a,0x3f,0xac,0x04,0xb9,0x82,0x85,
  0x48,0x16,0x23,0x5a,0x60,0x03,0x90,0xbd,0x85,0x4b,0xe4,0x16,0x59,0x45,0xe8,0x86,
  0xd1,0xc5,0xcb,0x8c,0x2f,0x9d,0x6f,0xfe,0x4c,0x01,0xb3,0xc3,0x78,0x8f,0x30,0x62,
  0x94,0x33,0x77,0x3e,0x86,0x8c,0x74,0xea,0x90,0x6d,0x97,0xc9,0xbd,0xdb,0x89,0x66,
  0x33,0x35,0x84,0x8f,0x17,0x4d,0xda,0xf4,0x99,0xe5,0xab,0xb5,0xe6,0x5e,0x6c,0x27,
  0x24,0xb1,0x45,0x7c,0x4b,0x04,0xa6,0xdd,0x6e,0x5d,0xa0,0xf1,0x5b,0x7e,0x69,0x80,
  0xa6,0x83,0x79,0x61,0x24,0xb7,0x5c,0x73,0xcf,0x45,0xa7,0xd8,0x86,0x1c,0x0e,0xa4,
  0x86,0x1a,0x6b,0xb0,0xd1,0x86,0x1b,0x6f,0xc0,0x11,0x87,0x1c,0x73,0xd0,0x51,0x87,
  0x1d,0x77,0xe0,0x81,0x47,0x1e,0x65,0x84,0x50,0x86,0x1e,0x7b,0xf0,0xc1,0x47,0x1f,
  0x7e,0xfc,0xf1,0x07,0x20,0x80,0x04,0x22,0xc8,0x20,0x83,0x10,0x52,0x88,0x21,0x02,
  0x7d,0xc8,0x06,0x1b,0x87,0xb4,0xf1,0x46,0x1c,0x88,0x24,0xa2,0xc8,0x1c,0x75,0x2c,
  0xc2,0x88,0x8b,0x79,0x04,0x05,0x42,0x23,0x35,0x3a,0xe2,0xc7,0x23,0x7f,0x40,0x02,
  0x48,0x24,0x82,0x48,0x12,0x64,0x21,0x93,0x10,0x09,0x80,0x91,0x22,0x96,0x48,0x09,
  0x22,0x28,0x2a,0x12,0x65,0x8b,0x95,0x58,0x82,0x1b,0x08,0x7a,0xd8,0x88,0x63,0x8e,
  0x90,0x44,0x72,0x49,0x20,0x92,0x60,0x92,0x89,0x90,0x66,0x7e,0x18,0xe2,0x21,0x6f,
  0xb8,0x01,0x07,0x9b,0x8a,0x28,0x62,0xc7,0x22,0x2d,0xbe,0x38,0x9f,0x08,0x34,0xde,
  0xe8,0xc8,0x1f,0x8f,0xe4,0x09,0x88,0x24,0x3f,0x0a,0x59,0x66,0x91,0x6a,0x1c,0xd9,
  0x86,0x92,0x88,0x9c,0xf8,0xe4,0x8a,0x8d,0xca,0x09,0x02,0x08,0x7b,0x64,0xe9,0xc7,
  0x96,0x9a,0x44,0x12,0xc8,0x25,0x0c,0x99,0x16,0x32,0x64,0x87,0xb4,0xd6,0x6a,0x6b,
  0x87,0x01,0x01,0x00,0x3b
  };


/*******************************************************************************/



// Separator item
FXColorSelector::FXColorSelector(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXPacker(p,opts,x,y,w,h){
  FXLabel *label;
  target=tgt;
  message=sel;

  // Buttons
  FXHorizontalFrame *buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH);
  accept=new FXButton(buttons,"&Accept",NULL,NULL,0,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);
  cancel=new FXButton(buttons,"&Cancel",NULL,NULL,0,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);

  // Separator
  new FXHorizontalSeparator(this,SEPARATOR_RIDGE|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);

  // Icons
  eyedropicon=new FXGIFIcon(getApp(),eyedrop);
  dialmodeicon=new FXGIFIcon(getApp(),dialmode);
  rgbmodeicon=new FXGIFIcon(getApp(),rgbmode);
  hsvmodeicon=new FXGIFIcon(getApp(),hsvmode);
  cmymodeicon=new FXGIFIcon(getApp(),cmymode);
  txtmodeicon=new FXGIFIcon(getApp(),txtmode);

  // Wells with custom colors
  FXHorizontalFrame *colors=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0, 0,0);
  colorwells[0]=new FXColorWell(colors,FXRGBA(255,255,255,255),this,ID_CUSTOM_FIRST+0,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[1]=new FXColorWell(colors,FXRGBA(  0,  0,  0,255),this,ID_CUSTOM_FIRST+1,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[2]=new FXColorWell(colors,FXRGBA(255,  0,  0,255),this,ID_CUSTOM_FIRST+2,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[3]=new FXColorWell(colors,FXRGBA(  0,255,  0,255),this,ID_CUSTOM_FIRST+3,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  colorwells[4]=new FXColorWell(colors,FXRGBA(  0,  0,255,255),this,ID_CUSTOM_FIRST+4,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[5]=new FXColorWell(colors,FXRGBA(  0,  0,255,255),this,ID_CUSTOM_FIRST+5,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[6]=new FXColorWell(colors,FXRGBA(255,255,  0,255),this,ID_CUSTOM_FIRST+6,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[7]=new FXColorWell(colors,FXRGBA(  0,255,255,255),this,ID_CUSTOM_FIRST+7,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  colorwells[8]=new FXColorWell(colors,FXRGBA(255,  0,255,255),this,ID_CUSTOM_FIRST+8,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[9]=new FXColorWell(colors,FXRGBA(128,  0,  0,255),this,ID_CUSTOM_FIRST+9,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[10]=new FXColorWell(colors,FXRGBA(  0,128,  0,255),this,ID_CUSTOM_FIRST+10,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[11]=new FXColorWell(colors,FXRGBA(  0,  0,128,255),this,ID_CUSTOM_FIRST+11,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  colorwells[12]=new FXColorWell(colors,FXRGBA(128,128,  0,255),this,ID_CUSTOM_FIRST+12,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[13]=new FXColorWell(colors,FXRGBA(128,  0,128,255),this,ID_CUSTOM_FIRST+13,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[14]=new FXColorWell(colors,FXRGBA(  0,128,128,255),this,ID_CUSTOM_FIRST+14,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[15]=new FXColorWell(colors,FXRGBA(  0,128,128,255),this,ID_CUSTOM_FIRST+15,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  colorwells[16]=new FXColorWell(colors,FXRGBA(255,  0,255,255),this,ID_CUSTOM_FIRST+16,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[17]=new FXColorWell(colors,FXRGBA(128,  0,  0,255),this,ID_CUSTOM_FIRST+17,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[18]=new FXColorWell(colors,FXRGBA(  0,128,  0,255),this,ID_CUSTOM_FIRST+18,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[19]=new FXColorWell(colors,FXRGBA(  0,  0,128,255),this,ID_CUSTOM_FIRST+19,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  colorwells[20]=new FXColorWell(colors,FXRGBA(128,128,  0,255),this,ID_CUSTOM_FIRST+20,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[21]=new FXColorWell(colors,FXRGBA(128,  0,128,255),this,ID_CUSTOM_FIRST+21,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[22]=new FXColorWell(colors,FXRGBA(  0,128,128,255),this,ID_CUSTOM_FIRST+22,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);
  colorwells[23]=new FXColorWell(colors,FXRGBA(  0,128,128,255),this,ID_CUSTOM_FIRST+23,COLORWELL_SOURCEONLY|LAYOUT_CENTER_Y|LAYOUT_CENTER_X, 0,0,0,0 ,0,0,0,0);

  // Main part
  FXHorizontalFrame *main=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

  FXVerticalFrame *wellframe=new FXVerticalFrame(main,LAYOUT_FILL_Y,0,0,0,0, 0,0,10,0,0,2);

  // Color sucker
  new FXPicker(wellframe,"\tPick color",eyedropicon,this,ID_COLORPICK,JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_X|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,56,32,0,0,0,0);

  // Main color well
  well=new FXColorWell(wellframe,FXRGBA(255,255,255,255),this,ID_WELL_CHANGED,COLORWELL_SOURCEONLY|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,64,0 ,0,0,0,0);

  // Tab book with switchable panels
  panels=new FXTabBook(main,this,ID_ACTIVEPANE,TABBOOK_TOPTABS|LAYOUT_FILL_Y|LAYOUT_FILL_X);

  // HSV Dial Mode
  new FXTabItem(panels,"\tHue, Saturation, Value",dialmodeicon,TAB_TOP_NORMAL,0,0,0,0, 6,6,0,0);

    // RGB Sliders
    FXHorizontalFrame *dialblock=new FXHorizontalFrame(panels,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10, 5,8);

    wheel=new FXColorWheel(dialblock,this,ID_DIAL_WHEEL,LAYOUT_CENTER_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,104,104,1,1,1,1);

    bar=new FXColorBar(dialblock,this,ID_COLOR_BAR,COLORBAR_VERTICAL|LAYOUT_CENTER_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,30,104,1,1,1,1);

  // RGB Mode
  new FXTabItem(panels,"\tRed, Green, Blue",rgbmodeicon,TAB_TOP_NORMAL,0,0,0,0, 6,6,0,0);

    // RGB Sliders
    FXMatrix *rgbblock=new FXMatrix(panels,3,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT|MATRIX_BY_COLUMNS,0,0,0,0,10,10,10,10, 5,8);

    // Red
    new FXLabel(rgbblock,"&Red:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    rgbatext[0]=new FXTextField(rgbblock,5,this,FXColorSelector::ID_RGB_RED_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    rgbaslider[0]=new FXSlider(rgbblock,this,FXColorSelector::ID_RGB_RED_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Green slider
    new FXLabel(rgbblock,"&Green:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    rgbatext[1]=new FXTextField(rgbblock,5,this,FXColorSelector::ID_RGB_GREEN_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    rgbaslider[1]=new FXSlider(rgbblock,this,FXColorSelector::ID_RGB_GREEN_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Blue slider
    new FXLabel(rgbblock,"&Blue:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    rgbatext[2]=new FXTextField(rgbblock,5,this,FXColorSelector::ID_RGB_BLUE_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    rgbaslider[2]=new FXSlider(rgbblock,this,FXColorSelector::ID_RGB_BLUE_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Alpha slider
    label=new FXLabel(rgbblock,"&Alpha:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    rgbatext[3]=new FXTextField(rgbblock,5,this,FXColorSelector::ID_ALPHA_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    rgbaslider[3]=new FXSlider(rgbblock,this,FXColorSelector::ID_ALPHA_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    label->setTarget(this);
    label->setSelector(ID_ALPHA_LABEL);

    // Set ranges and increment
    rgbaslider[0]->setRange(0,255);
    rgbaslider[1]->setRange(0,255);
    rgbaslider[2]->setRange(0,255);
    rgbaslider[3]->setRange(0,255);

  // HSV Mode
  new FXTabItem(panels,"\tHue, Saturation, Value",hsvmodeicon,TAB_TOP_NORMAL,0,0,0,0, 6,6,0,0);

    // RGB Sliders
    FXMatrix *hsvblock=new FXMatrix(panels,3,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT|MATRIX_BY_COLUMNS,0,0,0,0,10,10,10,10, 5,8);

    // Hue Slider
    new FXLabel(hsvblock,"Hue:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    hsvatext[0]=new FXTextField(hsvblock,5,this,FXColorSelector::ID_HSV_HUE_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    hsvaslider[0]=new FXSlider(hsvblock,this,FXColorSelector::ID_HSV_HUE_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Saturation slider
    new FXLabel(hsvblock,"Saturation:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    hsvatext[1]=new FXTextField(hsvblock,5,this,FXColorSelector::ID_HSV_SATURATION_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    hsvaslider[1]=new FXSlider(hsvblock,this,FXColorSelector::ID_HSV_SATURATION_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Value slider
    new FXLabel(hsvblock,"Value:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    hsvatext[2]=new FXTextField(hsvblock,5,this,FXColorSelector::ID_HSV_VALUE_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    hsvaslider[2]=new FXSlider(hsvblock,this,FXColorSelector::ID_HSV_VALUE_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Alpha slider
    label=new FXLabel(hsvblock,"Alpha:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    hsvatext[3]=new FXTextField(hsvblock,5,this,FXColorSelector::ID_ALPHA_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    hsvaslider[3]=new FXSlider(hsvblock,this,FXColorSelector::ID_ALPHA_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    label->setTarget(this);
    label->setSelector(ID_ALPHA_LABEL);

    // Set ranges and increment
    hsvaslider[0]->setRange(0,360);
    hsvaslider[1]->setRange(0,1000);
    hsvaslider[2]->setRange(0,1000);
    hsvaslider[3]->setRange(0,255);

  // CMY Mode
  new FXTabItem(panels,"\tCyan, Magenta, Yellow",cmymodeicon,TAB_TOP_NORMAL,0,0,0,0, 6,6,0,0);

    // RGB Sliders
    FXMatrix *cmyblock=new FXMatrix(panels,3,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT|MATRIX_BY_COLUMNS,0,0,0,0,10,10,10,10, 5,8);

    // Cyan Slider
    new FXLabel(cmyblock,"Cyan:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    cmytext[0]=new FXTextField(cmyblock,5,this,FXColorSelector::ID_CMY_CYAN_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    cmyslider[0]=new FXSlider(cmyblock,this,FXColorSelector::ID_CMY_CYAN_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Magenta slider
    new FXLabel(cmyblock,"Magenta:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    cmytext[1]=new FXTextField(cmyblock,5,this,FXColorSelector::ID_CMY_MAGENTA_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    cmyslider[1]=new FXSlider(cmyblock,this,FXColorSelector::ID_CMY_MAGENTA_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Yellow slider
    new FXLabel(cmyblock,"Yellow:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    cmytext[2]=new FXTextField(cmyblock,5,this,FXColorSelector::ID_CMY_YELLOW_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    cmyslider[2]=new FXSlider(cmyblock,this,FXColorSelector::ID_CMY_YELLOW_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    // Alpha slider
    label=new FXLabel(cmyblock,"Alpha:",NULL,LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|LAYOUT_RIGHT);
    cmytext[3]=new FXTextField(cmyblock,5,this,FXColorSelector::ID_ALPHA_TEXT,JUSTIFY_RIGHT|LAYOUT_FILL_ROW|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, DEFAULT_PAD,DEFAULT_PAD,0,0);
    cmyslider[3]=new FXSlider(cmyblock,this,FXColorSelector::ID_ALPHA_SLIDER,LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|SLIDER_HORIZONTAL|SLIDER_INSIDE_BAR,0,0,0,15);

    label->setTarget(this);
    label->setSelector(ID_ALPHA_LABEL);

    // Set ranges and increment
    cmyslider[0]->setRange(0,255);
    cmyslider[1]->setRange(0,255);
    cmyslider[2]->setRange(0,255);
    cmyslider[3]->setRange(0,255);

  // Named Color Mode
  new FXTabItem(panels,"\tBy Name",txtmodeicon,TAB_TOP_NORMAL,0,0,0,0, 6,6,0,0);

    // Name list
    FXHorizontalFrame *outer=new FXHorizontalFrame(panels,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_Y|LAYOUT_FILL_X);
    FXHorizontalFrame *frame=new FXHorizontalFrame(outer,LAYOUT_FILL_Y|LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK,0,0,0,0, 0,0,0,0);
    list=new FXList(frame,6,this,ID_COLOR_LIST,LAYOUT_FILL_Y|LAYOUT_FILL_X|LIST_BROWSESELECT);

    // Add color names
    for(FXuint i=0; i<fxnumcolornames; i++){
      list->appendItem(fxcolornames[i].name);
      }

  // Init RGBA
  rgba[0]=0.0;
  rgba[1]=0.0;
  rgba[2]=0.0;
  rgba[3]=1.0;

  // Init HSVA
  hsva[0]=360.0;
  hsva[1]=0.0;
  hsva[2]=0.0;
  hsva[3]=1.0;

  // Reflect color in well
  updateWell();

  // Initial focus on accept button
  accept->setFocus();
  }


// Init the panel
void FXColorSelector::create(){
  FXPacker::create();

  // Get custom well colors from defaults database
  colorwells[0]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[0],FXRGBA(255,255,255,255)));
  colorwells[1]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[1],FXRGBA(  0,  0,  0,255)));
  colorwells[2]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[2],FXRGBA(255,  0,  0,255)));
  colorwells[3]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[3],FXRGBA(  0,255,  0,255)));
  colorwells[4]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[4],FXRGBA(  0,  0,255,255)));
  colorwells[5]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[5],FXRGBA(  0,  0,255,255)));
  colorwells[6]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[6],FXRGBA(255,255,  0,255)));
  colorwells[7]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[7],FXRGBA(  0,255,255,255)));
  colorwells[8]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[8],FXRGBA(255,  0,255,255)));
  colorwells[9]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[9],FXRGBA(128,  0,  0,255)));
  colorwells[10]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[10],FXRGBA(  0,128,  0,255)));
  colorwells[11]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[11],FXRGBA(  0,  0,128,255)));
  colorwells[12]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[12],FXRGBA(128,128,  0,255)));
  colorwells[13]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[13],FXRGBA(128,  0,128,255)));
  colorwells[14]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[14],FXRGBA(  0,128,128,255)));
  colorwells[15]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[15],FXRGBA(  0,128,128,255)));
  colorwells[16]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[16],FXRGBA(255,  0,255,255)));
  colorwells[17]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[17],FXRGBA(128,  0,  0,255)));
  colorwells[18]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[18],FXRGBA(  0,128,  0,255)));
  colorwells[19]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[19],FXRGBA(  0,  0,128,255)));
  colorwells[20]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[20],FXRGBA(128,128,  0,255)));
  colorwells[21]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[21],FXRGBA(128,  0,128,255)));
  colorwells[22]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[22],FXRGBA(  0,128,128,255)));
  colorwells[23]->setRGBA(getApp()->reg().readColorEntry("SETTINGS",wellname[23],FXRGBA(  0,128,128,255)));

  // Switch to correct pane
  panels->setCurrent(getApp()->reg().readIntEntry("SETTINGS","activecolorpane",0));

  }


/*******************************************************************************/

// ALPHA

// Update well from Alpha slider
long FXColorSelector::onCmdAlphaSlider(FXObject* sender,FXSelector sel,void*){
  FXint value;
  sender->handle(this,MKUINT(ID_GETINTVALUE,SEL_COMMAND),(void*)&value);
  hsva[3]=rgba[3]=0.003921568627f*value;
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update well from Alpha text fields
long FXColorSelector::onCmdAlphaText(FXObject* sender,FXSelector,void*){
  FXdouble value;
  sender->handle(this,MKUINT(ID_GETREALVALUE,SEL_COMMAND),(void*)&value);
  hsva[3]=rgba[3]=0.003921568627f*value;
  updateWell();
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update Alpha text fields
long FXColorSelector::onUpdAlphaText(FXObject* sender,FXSelector,void*){
  if(isOpaqueOnly()){
    sender->handle(this,MKUINT(ID_HIDE,SEL_COMMAND),NULL);
    }
  else{
    FXString value=FXStringVal(255.0*rgba[3],1,FALSE);
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&value);
    sender->handle(this,MKUINT(ID_SHOW,SEL_COMMAND),NULL);
    }
  return 1;
  }


// Update Alpha sliders
long FXColorSelector::onUpdAlphaSlider(FXObject* sender,FXSelector,void*){
  if(isOpaqueOnly()){
    sender->handle(this,MKUINT(ID_HIDE,SEL_COMMAND),NULL);
    }
  else{
    FXint value=(FXint)(255.0*rgba[3]);
    sender->handle(this,MKUINT(ID_SETINTVALUE,SEL_COMMAND),(void*)&value);
    sender->handle(this,MKUINT(ID_SHOW,SEL_COMMAND),NULL);
    }
  return 1;
  }


// Update Alpha Labels
long FXColorSelector::onUpdAlphaLabel(FXObject* sender,FXSelector,void*){
  if(isOpaqueOnly()){
    sender->handle(this,MKUINT(ID_HIDE,SEL_COMMAND),NULL);
    }
  else{
    sender->handle(this,MKUINT(ID_SHOW,SEL_COMMAND),NULL);
    }
  return 1;
  }


/*******************************************************************************/


// Wheel & bar

// Update well from wheel
long FXColorSelector::onCmdWheel(FXObject*,FXSelector sel,void*){
  hsva[0]=wheel->getHue();
  hsva[1]=wheel->getSat();
  //hsva[2]=wheel->getVal();
  fxhsv_to_rgb(rgba[0],rgba[1],rgba[2],hsva[0],hsva[1],hsva[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update wheel
long FXColorSelector::onUpdWheel(FXObject*,FXSelector,void*){
  wheel->setHue(hsva[0]);
  wheel->setSat(hsva[1]);
  //wheel->setVal(hsva[2]);
  return 1;
  }


// Update well from bar
long FXColorSelector::onCmdBar(FXObject*,FXSelector sel,void*){
  hsva[0]=bar->getHue();
  hsva[1]=bar->getSat();
  hsva[2]=bar->getVal();
  fxhsv_to_rgb(rgba[0],rgba[1],rgba[2],hsva[0],hsva[1],hsva[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update bar
long FXColorSelector::onUpdBar(FXObject*,FXSelector,void*){
  bar->setHue(hsva[0]);
  bar->setSat(hsva[1]);
  bar->setVal(hsva[2]);
  return 1;
  }

/*******************************************************************************/


// RGB

// Update well from RGB slider
long FXColorSelector::onCmdRGBSlider(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_RGB_RED_SLIDER;
  rgba[which]=0.003921568627f*rgbaslider[which]->getValue();
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update well from RGB text fields
long FXColorSelector::onCmdRGBText(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_RGB_RED_TEXT;
  rgba[which]=0.003921568627f*FXFloatVal(rgbatext[which]->getText());
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update RGB text fields
long FXColorSelector::onUpdRGBText(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_RGB_RED_TEXT;
  rgbatext[which]->setText(FXStringVal(255.0f*rgba[which],1,FALSE));
  return 1;
  }


// Update RGB sliders
long FXColorSelector::onUpdRGBSlider(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_RGB_RED_SLIDER;
  rgbaslider[which]->setValue((FXint)(255.0f*rgba[which]));
  return 1;
  }


/*******************************************************************************/


// HSV

// Update well from HSV sliders
long FXColorSelector::onCmdHSVSlider(FXObject*,FXSelector sel,void*){
  const FXfloat factor[3]={1.0f,0.001f,0.001f};
  FXint which=SELID(sel)-ID_HSV_HUE_SLIDER;
  hsva[which]=factor[which]*hsvaslider[which]->getValue();
  fxhsv_to_rgb(rgba[0],rgba[1],rgba[2],hsva[0],hsva[1],hsva[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update well from HSV text fields
long FXColorSelector::onCmdHSVText(FXObject*,FXSelector sel,void*){
  const FXfloat factor[3]={1.0f,0.01f,0.01f};
  FXint which=SELID(sel)-ID_HSV_HUE_TEXT;
  hsva[which]=factor[which]*FXFloatVal(hsvatext[which]->getText());
  fxhsv_to_rgb(rgba[0],rgba[1],rgba[2],hsva[0],hsva[1],hsva[2]);
  updateWell();
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update HSV text fields
long FXColorSelector::onUpdHSVText(FXObject*,FXSelector sel,void*){
  const FXfloat factor[3]={1.0f,100.0f,100.0f};
  FXint which=SELID(sel)-ID_HSV_HUE_TEXT;
  hsvatext[which]->setText(FXStringVal(hsva[which]*factor[which],1,FALSE));
  return 1;
  }


// Update HSV sliders
long FXColorSelector::onUpdHSVSlider(FXObject*,FXSelector sel,void*){
  const FXfloat factor[3]={1.0f,1000.0f,1000.0f};
  FXint which=SELID(sel)-ID_HSV_HUE_SLIDER;
  hsvaslider[which]->setValue((FXint)(hsva[which]*factor[which]));
  return 1;
  }

/*******************************************************************************/


// CMY

long FXColorSelector::onCmdCMYSlider(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_CMY_CYAN_SLIDER;
  FXfloat val=0.003921568627f*cmyslider[which]->getValue();
  rgba[which]=1.0f-val;
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  hsva[3]=rgba[3];
  updateWell();
  handle(this,MKUINT(ID_COLOR,SELTYPE(sel)),(void*)(FXuval)well->getRGBA());
  return 1;
  }


long FXColorSelector::onCmdCMYText(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_CMY_CYAN_TEXT;
  FXfloat val=0.003921568627f*FXFloatVal(cmytext[which]->getText());
  rgba[which]=1.0f-val;
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  hsva[3]=rgba[3];
  updateWell();
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


long FXColorSelector::onUpdCMYText(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_CMY_CYAN_TEXT;
  FXfloat val=255.0f-255.0f*rgba[which];
  cmytext[which]->setText(FXStringVal(val,1,FALSE));
  return 1;
  }


long FXColorSelector::onUpdCMYSlider(FXObject*,FXSelector sel,void*){
  FXint which=SELID(sel)-ID_CMY_CYAN_SLIDER;
  FXint val=(FXint)(255.0f-255.0f*rgba[which]);
  cmyslider[which]->setValue(val);
  return 1;
  }


/*******************************************************************************/

// Color picker
long FXColorSelector::onCmdColorPick(FXObject*,FXSelector,void* ptr){
  FXPoint *point=(FXPoint*)ptr;
  FXDCWindow dc(getRoot());
  setRGBA(dc.readPixel(point->x,point->y));
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


/*******************************************************************************/


// Dropped color in main well
long FXColorSelector::onChgWell(FXObject*,FXSelector,void* ptr){
  FXColor color=(FXColor)(FXuval)ptr;
  if(isOpaqueOnly()) color|=FXRGBA(0,0,0,255);
  rgba[0]=0.003921568627f*FXREDVAL(color);
  rgba[1]=0.003921568627f*FXGREENVAL(color);
  rgba[2]=0.003921568627f*FXBLUEVAL(color);
  rgba[3]=0.003921568627f*FXALPHAVAL(color);
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  hsva[3]=rgba[3];
  return 1;
  }


// Command from main well
long FXColorSelector::onCmdWell(FXObject*,FXSelector,void*){
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Update main well
void FXColorSelector::updateWell(){
  well->setRGBA(FXRGBA((int)(rgba[0]*255.0),(int)(rgba[1]*255.0),(int)(rgba[2]*255.0),(int)(rgba[3]*255.0)));
  }


/*******************************************************************************/


// Clicked on color in list
long FXColorSelector::onCmdList(FXObject*,FXSelector,void* ptr){
  FXint index=(FXint)(FXival)ptr;
  FXColor clr=fxcolornames[index].color;
  if(isOpaqueOnly()) clr|=FXRGBA(0,0,0,255);
  rgba[0]=0.003921568627f*FXREDVAL(clr);
  rgba[1]=0.003921568627f*FXGREENVAL(clr);
  rgba[2]=0.003921568627f*FXBLUEVAL(clr);
  rgba[3]=0.003921568627f*FXALPHAVAL(clr);
  fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
  hsva[3]=rgba[3];
  updateWell();
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


/*******************************************************************************/


// Custom well changed
long FXColorSelector::onChgCustomWell(FXObject*,FXSelector sel,void* ptr){
  FXColor color=(FXColor)(FXuval)ptr;
  FXuint which=SELID(sel)-ID_CUSTOM_FIRST;
  FXASSERT(which<24);
  getApp()->reg().writeColorEntry("SETTINGS",wellname[which],color);
  return 1;
  }


// Custom well clicked
long FXColorSelector::onCmdCustomWell(FXObject*,FXSelector,void* ptr){
  FXColor color=(FXColor)(FXuval)ptr;
  if(isOpaqueOnly()) color|=FXRGBA(0,0,0,255);
  setRGBA(color);
  handle(this,MKUINT(ID_COLOR,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Switching active pane
long FXColorSelector::onCmdActivePane(FXObject*,FXSelector,void* ptr){
  getApp()->reg().writeIntEntry("SETTINGS","activecolorpane",(FXint)(FXival)ptr);
  return 1;
  }


/*******************************************************************************/


// Forward to target
long FXColorSelector::onCmdColor(FXObject*,FXSelector,void*){
  if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Forward to target
long FXColorSelector::onChgColor(FXObject*,FXSelector,void*){
  if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)(FXuval)well->getRGBA());
  return 1;
  }


// Set color
long FXColorSelector::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setRGBA((FXColor)(FXuval)ptr);
  return 1;
  }


// Change RGBA color
void FXColorSelector::setRGBA(FXColor clr){
  if(clr!=well->getRGBA()){
    rgba[0]=0.003921568627f*FXREDVAL(clr);
    rgba[1]=0.003921568627f*FXGREENVAL(clr);
    rgba[2]=0.003921568627f*FXBLUEVAL(clr);
    rgba[3]=0.003921568627f*FXALPHAVAL(clr);
    fxrgb_to_hsv(hsva[0],hsva[1],hsva[2],rgba[0],rgba[1],rgba[2]);
    hsva[3]=rgba[3];
    well->setRGBA(clr);
    }
  }


// Retrieve RGBA color
FXColor FXColorSelector::getRGBA() const {
  return well->getRGBA();
  }


// Return true if only opaque colors allowed
FXbool FXColorSelector::isOpaqueOnly() const {
  return well->isOpaqueOnly();
  }


// Change opaque only mode
void FXColorSelector::setOpaqueOnly(FXbool opaque){
  if(opaque){
    well->setOpaqueOnly(TRUE);
    setRGBA(well->getRGBA() | FXRGBA(0,0,0,255));
    }
  else{
    well->setOpaqueOnly(FALSE);
    }
  }


/*******************************************************************************/


// Save data
void FXColorSelector::save(FXStream& store) const {
  FXPacker::save(store);
  store << panels;
  store << well;
  store << list;
  store << accept;
  store << cancel;
  store << dialmodeicon;
  store << rgbmodeicon;
  store << hsvmodeicon;
  store << cmymodeicon;
  store << txtmodeicon;
  store << wheel;
  store << rgbaslider[0] << rgbaslider[1] << rgbaslider[2] << rgbaslider[3];
  store << hsvaslider[0] << hsvaslider[1] << hsvaslider[2] << hsvaslider[3];
  store << cmyslider[0]  << cmyslider[1]  << cmyslider[2]  << cmyslider[3];
  store << rgbatext[0] << rgbatext[1] << rgbatext[2] << rgbatext[3];
  store << hsvatext[0] << hsvatext[1] << hsvatext[2] << hsvatext[3];
  store << cmytext[0]  << cmytext[1]  << cmytext[2]  << cmytext[3];
  store << colorwells[0]  << colorwells[1]  << colorwells[2]  << colorwells[3];
  store << colorwells[4]  << colorwells[5]  << colorwells[6]  << colorwells[7];
  store << colorwells[8]  << colorwells[9]  << colorwells[10] << colorwells[11];
  store << colorwells[12] << colorwells[13] << colorwells[14] << colorwells[15];
  store << colorwells[16] << colorwells[17] << colorwells[18] << colorwells[19];
  store << colorwells[20] << colorwells[21] << colorwells[22] << colorwells[23];
  store.save(rgba,4);
  store.save(hsva,4);
  }


// Load data
void FXColorSelector::load(FXStream& store){
  FXPacker::load(store);
  store >> panels;
  store >> well;
  store >> list;
  store >> accept;
  store >> cancel;
  store >> dialmodeicon;
  store >> rgbmodeicon;
  store >> hsvmodeicon;
  store >> cmymodeicon;
  store >> txtmodeicon;
  store >> wheel;
  store >> rgbaslider[0] >> rgbaslider[1] >> rgbaslider[2] >> rgbaslider[3];
  store >> hsvaslider[0] >> hsvaslider[1] >> hsvaslider[2] >> hsvaslider[3];
  store >> cmyslider[0]  >> cmyslider[1]  >> cmyslider[2]  >> cmyslider[3];
  store >> rgbatext[0] >> rgbatext[1] >> rgbatext[2] >> rgbatext[3];
  store >> hsvatext[0] >> hsvatext[1] >> hsvatext[2] >> hsvatext[3];
  store >> cmytext[0]  >> cmytext[1]  >> cmytext[2]  >> cmytext[3];
  store >> colorwells[0]  >> colorwells[1]  >> colorwells[2]  >> colorwells[3];
  store >> colorwells[4]  >> colorwells[5]  >> colorwells[6]  >> colorwells[7];
  store >> colorwells[8]  >> colorwells[9]  >> colorwells[10] >> colorwells[11];
  store >> colorwells[12] >> colorwells[13] >> colorwells[14] >> colorwells[15];
  store >> colorwells[16] >> colorwells[17] >> colorwells[18] >> colorwells[19];
  store >> colorwells[20] >> colorwells[21] >> colorwells[22] >> colorwells[23];
  store.load(rgba,4);
  store.load(hsva,4);
  }


// Cleanup; icons must be explicitly deleted
FXColorSelector::~FXColorSelector(){
  delete eyedropicon;
  delete dialmodeicon;
  delete rgbmodeicon;
  delete hsvmodeicon;
  delete cmymodeicon;
  delete txtmodeicon;
  wheel=(FXColorWheel*)-1;
  eyedropicon=(FXIcon*)-1;
  dialmodeicon=(FXIcon*)-1;
  rgbmodeicon=(FXIcon*)-1;
  hsvmodeicon=(FXIcon*)-1;
  cmymodeicon=(FXIcon*)-1;
  txtmodeicon=(FXIcon*)-1;
  panels=(FXTabBook*)-1;
  well=(FXColorWell*)-1;
  accept=(FXButton*)-1;
  cancel=(FXButton*)-1;
  }


