/********************************************************************************
*                                                                               *
*                        O p e n G L   C o n e    O b j e c t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXGLCone.h,v 1.7 2001/04/25 05:47:37 jeroen Exp $                        *
********************************************************************************/
#ifndef FXGLCONE_H
#define FXGLCONE_H


/// OpenGL Cone Object
class FXAPI FXGLCone : public FXGLShape {
  FXDECLARE(FXGLCone)
public:
  FXfloat height;
  FXfloat radius;
protected:
  FXGLCone();
  virtual void drawshape(FXGLViewer* viewer);
public:

  /// Construct with specified origin, height and radius
  FXGLCone(FXfloat x,FXfloat y,FXfloat z,FXfloat h=1.0,FXfloat r=1.0);

  /// Construct with specified origin, height, radius and material
  FXGLCone(FXfloat x,FXfloat y,FXfloat z,FXfloat h,FXfloat r,const FXMaterial& mtl);

  /// Copy constructor
  FXGLCone(const FXGLCone& orig);

  /// Copy this object
  virtual FXGLObject* copy();

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);
  
  /// Destroy
  virtual ~FXGLCone();
  };

#endif
