/********************************************************************************
*                                                                               *
*                     D i r e c t o r y   B o x   O b j e c t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXDirBox.cpp,v 1.17 2001/08/22 04:01:55 jeroen Exp $                     *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXSize.h"
#include "FXPoint.h"
#include "FXRectangle.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXFile.h"
#include "FXSettings.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXBMPIcon.h"
#include "FXFont.h"
#include "FXDC.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXTextField.h"
#include "FXButton.h"
#include "FXMenuButton.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXScrollbar.h"
#include "FXScrollArea.h"
#include "FXTreeList.h"
#include "FXTreeListBox.h"
#include "FXDirBox.h"



/*
  Notes:
  - When setting path, it adds all directories from the top down to
    the lowest directory.
  - It also adds common places in the file system.
  - Add API's to set current path [from root down to whereever]
  - Add code to read path of selected item
  - Add some better icons
*/


/*******************************************************************************/


const unsigned char desktop[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x66,0x6c,
  0x77,0x77,0x77,0x7c,0x6c,0xc0,0x6e,0xc8,0x88,0x88,0x88,0x88,0xc8,0xc0,0x6c,0x88,
  0x80,0x78,0x88,0x88,0x8c,0x60,0x68,0xf8,0x08,0x07,0x88,0x88,0x88,0xc0,0x7f,0x80,
  0x8f,0x80,0x78,0x88,0x88,0x70,0x7f,0x08,0xff,0xf8,0x07,0x88,0x88,0x70,0x7f,0x87,
  0xff,0x0f,0x80,0x88,0x88,0x70,0x7f,0xf8,0x7f,0x33,0x07,0x88,0x88,0x70,0x68,0xff,
  0x87,0x3b,0x30,0x78,0x88,0x40,0x6c,0x8f,0xf8,0x73,0xb3,0x07,0x84,0xc0,0x66,0xc8,
  0xff,0x8f,0x3b,0x30,0x48,0xc0,0x6e,0x6c,0x8f,0xff,0xf3,0xb3,0x0c,0xc0,0x66,0x66,
  0x67,0x77,0x77,0x3b,0x30,0x70,0xdd,0xdd,0xdd,0xdd,0xdd,0xd3,0x91,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0x11,0xdd
  };

const unsigned char mycomputer[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
  0x00,0x00,0x00,0x00,0xdd,0xdd,0x7f,0xff,0xff,0xff,0xff,0xf8,0x0d,0xdd,0xd7,0x08,
  0x08,0x08,0x08,0x08,0x00,0xdd,0xdd,0x70,0x70,0x70,0x70,0x70,0x77,0x0d,0xdd,0x78,
  0x88,0x88,0x88,0x87,0x87,0x0d,0xdd,0xd7,0x00,0x00,0x00,0x00,0x78,0x0d,0xdd,0xd7,
  0xf8,0x88,0x88,0x87,0x07,0x7d,0xdd,0xd7,0xf0,0x77,0x77,0x87,0x70,0xdd,0xdd,0xd7,
  0xf0,0x66,0x67,0x87,0x70,0xdd,0xdd,0xd7,0xf0,0xe6,0x67,0x87,0x70,0xdd,0xdd,0xd7,
  0xf0,0x00,0x00,0x87,0x70,0xdd,0xdd,0xd7,0xff,0xff,0xff,0x87,0x70,0xdd,0xdd,0xdd,
  0x78,0x88,0x88,0x88,0x70,0xdd,0xdd,0xdd,0xd7,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char floppy[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x0d,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x70,0xdd,0x78,0x88,
  0xff,0xff,0x88,0x88,0x77,0x0d,0x78,0x77,0x00,0x00,0x77,0x78,0x77,0x0d,0x78,0x88,
  0x77,0x77,0x88,0x88,0x77,0x0d,0x78,0x88,0x88,0x88,0x88,0x98,0x77,0x0d,0x7f,0xff,
  0xff,0xff,0xf0,0x00,0x00,0x0d,0xd7,0x88,0x88,0x88,0x78,0x70,0x7f,0x80,0xdd,0x77,
  0x77,0x77,0x78,0x77,0x77,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0x88,0x88,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0xd7,0x77,0x77,0x7d
  };

const unsigned char harddisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x78,0xff,0xff,0xff,0xff,0xff,0x87,0x70,0x78,0x77,
  0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x82,0x87,0x70,0x7f,0xff,0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,
  0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char cdrom[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,
  0xff,0xff,0xf8,0x88,0x87,0x0d,0x7f,0xa2,0x00,0x00,0x00,0x00,0x87,0x0d,0x7f,0x88,
  0x88,0x87,0x78,0x88,0x00,0x0d,0x7f,0xff,0xff,0x78,0xf8,0x88,0xa7,0x0d,0xd7,0x77,
  0x77,0x78,0x8f,0x88,0xbe,0x70,0xdd,0xdd,0xd7,0x88,0x87,0x07,0xe8,0x80,0xdd,0xdd,
  0xd7,0x88,0xa0,0xd0,0x88,0x80,0xdd,0xdd,0xd7,0x8a,0xa7,0x07,0xf8,0x80,0xdd,0xdd,
  0xdd,0x7a,0xeb,0xb8,0x8f,0x0d,0xdd,0xdd,0xdd,0x7e,0xeb,0xb8,0x88,0x0d,0xdd,0xdd,
  0xdd,0xd7,0x7b,0xb8,0x77,0xdd,0xdd,0xdd,0xdd,0xdd,0xd7,0x77,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char networkdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0x00,0x00,0xdd,0xdd,0xdd,0x00,0x00,0x00,0xbf,0x30,0x00,0x00,0x00,0x88,0x88,
  0x88,0x33,0x30,0x88,0x88,0x88,0xdd,0xdd,0xdd,0xd8,0x0d,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xd0,0x0d,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x78,0xff,
  0xff,0xff,0xff,0xff,0x87,0x0d,0x78,0x77,0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x82,0xa7,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char zipdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x7f,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0x88,
  0x8f,0xff,0xff,0xf8,0x87,0x70,0x7f,0x88,0xf0,0x00,0x00,0x0f,0x87,0x70,0x7f,0x98,
  0x70,0x00,0x00,0x07,0x87,0x70,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char nethood[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0x00,0xdd,0xd0,0x00,0x00,0x00,0x0d,0x00,0xb3,
  0x00,0x78,0xa7,0x77,0x77,0x70,0x77,0xb3,0x07,0x7f,0xff,0xff,0xff,0x70,0xdd,0x70,
  0xdd,0x70,0x00,0x00,0x00,0x70,0xdd,0x70,0xdd,0x78,0x88,0x88,0x88,0x0d,0xd0,0x00,
  0x00,0x7f,0x07,0x77,0x78,0x0d,0x78,0xa7,0x77,0x7f,0x06,0x66,0x78,0x0d,0x7f,0xff,
  0xff,0x7f,0x0e,0x66,0x78,0x0d,0x70,0x00,0x00,0x7f,0x00,0x00,0x08,0x0d,0x78,0x88,
  0x88,0x7f,0xff,0xff,0xff,0x0d,0x7f,0x44,0x44,0x47,0x77,0x77,0x77,0x7d,0x7f,0x0c,
  0xcc,0x48,0x0d,0xdd,0xdd,0xdd,0x7f,0x0e,0xcc,0x48,0x0d,0xdd,0xdd,0xdd,0x7f,0x00,
  0x00,0x48,0x0d,0xdd,0xdd,0xdd,0x7f,0xff,0xff,0xff,0x0d,0xdd,0xdd,0xdd,0x67,0x77,
  0x77,0x77,0x7d,0xdd,0xdd,0xdd
  };

const unsigned char folder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };



/*******************************************************************************/


// Map
FXDEFMAP(FXDirBox) FXDirBoxMap[]={
  FXMAPFUNC(SEL_CHANGED,0,FXDirBox::onChanged),
  FXMAPFUNC(SEL_COMMAND,0,FXDirBox::onCommand),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXDirBox::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXDirBox::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXDirBox::onCmdGetStringValue),
  };


// Implementation
FXIMPLEMENT(FXDirBox,FXTreeListBox,FXDirBoxMap,ARRAYNUMBER(FXDirBoxMap))


// Directory box
FXDirBox::FXDirBox(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXTreeListBox(p,nvis,tgt,sel,opts,x,y,w,h, pl,pr,pt,pb){
  foldericon=new FXGIFIcon(getApp(),folder);
  cdromicon=new FXBMPIcon(getApp(),cdrom,0,IMAGE_ALPHAGUESS);
  desktopicon=new FXBMPIcon(getApp(),desktop,0,IMAGE_ALPHAGUESS);
  harddiskicon=new FXBMPIcon(getApp(),harddisk,0,IMAGE_ALPHAGUESS);
  networkicon=new FXBMPIcon(getApp(),networkdisk,0,IMAGE_ALPHAGUESS);
  floppyicon=new FXBMPIcon(getApp(),floppy,0,IMAGE_ALPHAGUESS);
  computericon=new FXBMPIcon(getApp(),mycomputer,0,IMAGE_ALPHAGUESS);
  nethoodicon=new FXBMPIcon(getApp(),nethood,0,IMAGE_ALPHAGUESS);
  zipdiskicon=new FXBMPIcon(getApp(),zipdisk,0,IMAGE_ALPHAGUESS);
#ifndef WIN32
  addItemLast(NULL,"/",foldericon,foldericon);
  setCurrentItem(getFirstItem());
  directory="/";
#else
  /*
  FXchar result[1024];
  fxgetcurrentdir(result);
  directory=FXString(result).left(2)+PATHSEPSTRING;
  addItemLast(NULL,directory,harddiskicon,harddiskicon);
  setCurrentItem(getFirstItem());
  */
  FXchar result[1024];
  fxgetcurrentdir(result);
  setDirectory(FXString(result).left(2)+PATHSEPSTRING);
#endif
  }


// Create
void FXDirBox::create(){
  FXTreeListBox::create();
  foldericon->create();
  cdromicon->create();
  desktopicon->create();
  harddiskicon->create();
  networkicon->create();
  floppyicon->create();
  computericon->create();
  nethoodicon->create();
  zipdiskicon->create();
  }


// Detach disconnects the icons
void FXDirBox::detach(){
  foldericon->detach();
  cdromicon->detach();
  desktopicon->detach();
  harddiskicon->detach();
  networkicon->detach();
  floppyicon->detach();
  computericon->detach();
  nethoodicon->detach();
  zipdiskicon->detach();
  FXTreeListBox::detach();
  }


// Destroy zaps the icons
void FXDirBox::destroy(){
  foldericon->destroy();
  cdromicon->destroy();
  desktopicon->destroy();
  harddiskicon->destroy();
  networkicon->destroy();
  floppyicon->destroy();
  computericon->destroy();
  nethoodicon->destroy();
  zipdiskicon->destroy();
  FXTreeListBox::destroy();
  }


// Set the current item's text from the message
long FXDirBox::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setDirectory((char*)ptr);
  return 1;
  }


// Change value
long FXDirBox::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setDirectory(*((FXString*)ptr));
  return 1;
  }


// Obtain value
long FXDirBox::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=directory;
  return 1;
  }


// Return item path
FXString FXDirBox::itempath(FXTreeItem *item){
  FXString string;
  if(item){
    while(item->getParent()){
      string.prepend(getItemText(item));
      item=item->getParent();
      if(item->getParent()) string.prepend(PATHSEPSTRING);
      }
    string.prepend(getItemText(item));
    }
  return string;
  }


// Changed current item in tree; pass path to current item
long FXDirBox::onChanged(FXObject*,FXSelector,void* ptr){
  FXString string=itempath((FXTreeItem*)ptr);
  if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)string.text());
  return 1;
  }


// Switch current item
long FXDirBox::onCommand(FXObject*,FXSelector,void* ptr){
  FXTreeItem *item=(FXTreeItem*)ptr;
  directory=itempath(item);
  removeItem(item->getFirst());
  if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)directory.text());
  return 1;
  }


// Set directory
void FXDirBox::setDirectory(const FXString& pathname){
  /*
  FXTreeItem *item;
  FXString    string;
  FXint       part;
  if(!pathname.empty()){
    FXTRACE((100,"%s::setDirectory(%s)\n",getClassName(),pathname.text()));
    FXString path=FXFile::absolute(pathname);
    while(!FXFile::isTopDirectory(path) && !FXFile::isDirectory(path)){
      path=FXFile::upLevel(path);
      }
    if(directory!=path){
      directory=path;
      clearItems();
#ifndef WIN32
      item=addItemFirst(NULL,PATHSEPSTRING,foldericon,foldericon);
      part=1;
      while(1){
        string=directory.extract(part,PATHSEP);
        if(string.empty()) break;
        item=addItemLast(item,string,foldericon,foldericon);
        part++;
        }
      setCurrentItem(item);
#else
#endif
      recalc();
      }
    }
  */

  FXchar abspath[MAXPATHLEN+1];
  FXString string;
  FXTreeItem *item;
  FXuint part=1;

  // Empty path:- ignore
  if(pathname.empty()) return;

  // Exactly equal already
  if(directory!=pathname){
    fxabspath(abspath,NULL,pathname.text());

    // Equal
    if(directory!=abspath){

      // Perhaps got trailing filename?
      while(!fxistopdir(abspath) && !fxisdir(abspath)){
        fxupdir(abspath,abspath);
        }

      // Switch
#ifndef WIN32
      if(directory!=abspath){
        directory=abspath;
        clearItems();
        item=addItemFirst(NULL,PATHSEPSTRING,foldericon,foldericon);    // Add root
        while(1){
          string=directory.extract(part,PATHSEP);
          if(string.empty()) break;
          item=addItemLast(item,string,foldericon,foldericon);
          part++;
          }
        setCurrentItem(item);
        recalc();
        }
#else
      if(directory!=abspath){
        directory=abspath;
        clearItems();

        //FXTreeItem *desktopitem=addItemLast(NULL,"Desktop",desktopicon,desktopicon);
	//FXTreeItem *computeritem=addItemLast(desktopitem,"My Computer",computericon,computericon);
	FXTreeItem *computeritem=NULL;

	LPTSTR lpDriveStrings=0;
	DWORD dwCount=GetLogicalDriveStrings(0,lpDriveStrings); // Get required size
	if(dwCount>0){
	  FXMALLOC(&lpDriveStrings,TCHAR,dwCount+1);
	  if(dwCount>=GetLogicalDriveStrings(dwCount,lpDriveStrings)){
	    DWORD dwDriveMask=GetLogicalDrives();
	    TCHAR szRootPathName[]=TEXT("?:\\");
	    LPTSTR lpParse=lpDriveStrings;
	    for(szRootPathName[0]=TEXT('a'); szRootPathName[0]<=TEXT('z'); szRootPathName[0]++){
	      if(dwDriveMask&1){
		UINT drivetype=GetDriveType(lpParse);
		FXString caption;
		switch(drivetype){
		  case DRIVE_REMOVABLE:
		    if(szRootPathName[0]==TEXT('a') || szRootPathName[0]==TEXT('b')){
		      //caption=FXString("Floppy (")+FXString(lpParse[0],1)+FXString(":)");
		      caption=lpParse;
		      item=addItemLast(computeritem,caption,floppyicon,floppyicon);
		      }
		    else{
		      //caption=FXString("Removable Disk (")+FXString(lpParse[0],1)+FXString(":)");
		      caption=lpParse;
		      item=addItemLast(computeritem,caption,zipdiskicon,zipdiskicon);
		      }
		    break;
		  case DRIVE_FIXED:
		    //caption=FXString("(")+FXString(lpParse[0],1)+":)";
		    caption=lpParse;
    		    item=addItemLast(computeritem,caption,harddiskicon,harddiskicon);
		    break;
		  case DRIVE_REMOTE:
		    //caption=FXString("Network Disk (")+FXString(lpParse[0],1)+":)";
		    caption=lpParse;
    		    item=addItemLast(computeritem,caption,networkicon,networkicon);
		    break;
		  case DRIVE_CDROM:
		    //caption=FXString("CD-ROM (")+FXString(lpParse[0],1)+":)";
		    caption=lpParse;
		    item=addItemLast(computeritem,caption,cdromicon,cdromicon);
		    break;
		  case DRIVE_UNKNOWN:
		  case DRIVE_NO_ROOT_DIR:
		  case DRIVE_RAMDISK:
		    FXASSERT(FALSE);
		    break;
		  default:
		    FXASSERT(FALSE);
		  }

                // Fix from John Burnell <j.burnell@irl.cri.nz> lpParse is NOT always uppercase.
                if(islower((FXuchar)lpParse[0]))
                  directory[0]=tolower((FXuchar)directory[0]);
                else
                  directory[0]=toupper((FXuchar)directory[0]);

		// Is the selected directory on this drive?
		if(directory[0]==lpParse[0]){
		  while(TRUE){
		    string=directory.extract(part,PATHSEP);
		    if(string.empty()) break;
		    item=addItemLast(item,string,foldericon,foldericon);
		    part++;
		    }
		  setCurrentItem(item);
		  }

		// Move on to the next drive
		lpParse+=lstrlen(lpParse)+1;
		}
	      dwDriveMask>>=1;
	      }
	    }
	  FXFREE(&lpDriveStrings);
	  }
	//addItemLast(desktopitem,"Network Neighborhood",nethoodicon,nethoodicon);
	//addItemLast(desktopitem,"My Briefcase",briefcaseicon,briefcaseicon);
        recalc();
        }
#endif
      }
    }
  }


// Save object to stream
void FXDirBox::save(FXStream& store) const {
  FXTreeListBox::save(store);
  store << directory;
  store << foldericon;
  store << cdromicon;
  store << desktopicon;
  store << harddiskicon;
  store << networkicon;
  store << floppyicon;
  store << computericon;
  store << nethoodicon;
  store << zipdiskicon;
  }


// Load object from stream
void FXDirBox::load(FXStream& store){
  FXTreeListBox::load(store);
  store >> directory;
  store >> foldericon;
  store >> cdromicon;
  store >> desktopicon;
  store >> harddiskicon;
  store >> networkicon;
  store >> floppyicon;
  store >> computericon;
  store >> nethoodicon;
  store >> zipdiskicon;
  }


// Delete it
FXDirBox::~FXDirBox(){
  delete foldericon;
  delete cdromicon;
  delete desktopicon;
  delete harddiskicon;
  delete networkicon;
  delete floppyicon;
  delete computericon;
  delete nethoodicon;
  delete zipdiskicon;
  foldericon=(FXIcon*)-1;
  cdromicon=(FXIcon*)-1;
  desktopicon=(FXIcon*)-1;
  harddiskicon=(FXIcon*)-1;
  networkicon=(FXIcon*)-1;
  floppyicon=(FXIcon*)-1;
  computericon=(FXIcon*)-1;
  nethoodicon=(FXIcon*)-1;
  zipdiskicon=(FXIcon*)-1;
  }

