/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#include "fplll.h"

void printhelp(void)
{
  cerr<<"Options  : "<< endl
      << " r <d> <b> : gen_intrel"<<endl
      << " s <d> <b> <b2> : gen_simdioph"<< endl
      << " u <d> <b> : gen_uniform"<< endl
      << " n <d> <b> <q> : gen_ntrulike"<<endl
      << " m <d> <b> <q> : gen_ntrulike2"<<endl
      << " a <d> <f> : gen_ajtai"<<endl;
}

int main(int argc,char*argv[])
{
  if (argc<4)
    {
      printhelp();
      abort();
    }
  ZZ_mat<mpz_t>* m;
  int d= atoi(argv[2]);

  //initialization+filling of the matrix
  switch(argv[1][0])
    {
    case 'r':
      {
	int b=atoi(argv[3]);
	m= new ZZ_mat<mpz_t>(d,d+1);
	m->gen_intrel(b);
	break;
      }
    case 's':
      {
	int b=atoi(argv[3]);
	int b2=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(d+1,d+1);
	m->gen_simdioph(b,b2);
	break;
      }
    case 'u':
      {
	int b=atoi(argv[3]);
	m=new ZZ_mat<mpz_t>(d,d);
	m->gen_uniform(b);
	break;
      }
    case 'n':
      {
	int b=atoi(argv[3]);
	int q=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(2*d,2*d);
	m->gen_ntrulike(b,q);
	break;
      }
    case 'm':
      {
	int b=atoi(argv[3]);
	int q=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(2*d,2*d);
	m->gen_ntrulike2(b,q);
	break;
      }
    case 'a':
      {
	double alpha=atof(argv[3]);
	m=new ZZ_mat<mpz_t>(d,d);
	m->gen_ajtai(alpha);
	break;
      }
    default:
      {
	printhelp();
	abort();
	break;
      }
    }
  m->print();
  delete m;
}
