/* C Mode */

/* libdtypes.c
   Implements init function for the DTypes library, including consing and OS functions
   Originally implemented by Ken Haase in the Machine Understanding Group
     at the MIT Media Laboratory.

   Copyright (C) 1994-2001 Massachusetts Institute of Technology
   Copyright (C) 2001-2002 beingmeta, inc. (A Delaware Corporation)

   This program comes with absolutely NO WARRANTY, including implied
   warranties of merchantability or fitness for any particular purpose.

    Use, modification, and redistribution of this program is permitted
    under the terms of either (at the developer's discretion) the GNU
    General Public License (GPL) Version 2, the GNU Lesser General Public
    License.

    This program is based on the FramerD library released in Fall 2001 by
    MIT under both the GPL and the LGPL licenses, both of which accompany
    this distribution.  Subsequent modifications by beingmeta, inc. are
    also released under both the GPL and LGPL licenses (at the developer's
    discretion).

*/ 

static char vcid[] =
  "$Id: libdtypes.c,v 1.11 2002/07/17 01:29:10 haase Exp $";

#include <locale.h>
#include "dtypes.h"

fd_exception fd_ConfigSyntaxError=_("Error in config file syntax");

static int dtypes_initialized=0;
static int load_profile=0, load_config=1, profile_loaded=0;
static char *config_file=NULL; /* The config file which was loaded */

extern void fd_initialize_except_c(void);
extern void fd_initialize_i18n_c(void);
extern void fd_initialize_data_c(void);
extern void fd_initialize_hash_c(void);
extern void fd_initialize_io_c(void);
extern void fd_initialize_slotmaps_c(void);
extern void fd_initialize_choices_c(void);
extern void fd_initialize_oids_c(void);
extern void fd_initialize_xdata_c(void);
extern void fd_initialize_fdprintf_c(void);
extern void fd_initialize_fdmalloc_c(void);
extern void fd_initialize_envfns_c(void);
extern void fd_initialize_timefns_c(void);
extern void fd_initialize_network_c(void);

static void initialize_text_encoding()
{
  char *encoding_name=NULL;
  encoding_name=fd_string_getenv("TEXT-ENCODING");
#if (HAVE_LANGINFO_H)
  if (encoding_name == NULL)
    encoding_name=nl_langinfo(CODESET);
  if (encoding_name)
    encoding_name=fd_strdup(encoding_name);
#endif
  if (encoding_name == NULL) {
    char *lcdata=getenv("LC_ALL");
    if (lcdata == NULL) lcdata=getenv("LC_CTYPE");
    if (lcdata == NULL) lcdata=getenv("LANG");
    if (lcdata) {
      char *dot=strchr(lcdata,'.');
      if (dot) {
	char *chset=fd_strdup(dot+1);
	char *at=strchr(chset,'@');
	if (at) *at=0; encoding_name=chset;}}}
  if (encoding_name)
    fd_set_default_encoding(encoding_name);
  else fd_set_default_encoding("ASCII");
  if (encoding_name) fd_xfree(encoding_name);
}

DTYPES_EXPORT void fd_load_user_profile()
{
  char *profile;
  if (profile_loaded) {}
  else {
    profile_loaded=1;
    profile=fd_string_getenv("FRAMERD_PROFILE");
    if (profile) 
      if (strcmp(profile,"none") == 0) {fd_xfree(profile);}
      else {
	WITH_HANDLING {
	  fd_load_config(profile); free(profile);}
	ON_EXCEPTION {
	  fd_xfree(profile); CLEAR_ERR();}
	END_HANDLING;}
    else {
      WITH_HANDLING {
	fd_load_config("~/.fdprofile");}
      ON_EXCEPTION {
	CLEAR_ERR();}
      END_HANDLING;}}
}

DTYPES_EXPORT char *fd_get_config_file()
{
  if (config_file) return config_file;
  else if (getenv("FRAMERD_CONFIG")) return getenv("FRAMERD_CONFIG");
  else return DEFAULT_FRAMERD_CONFIG;
}

DTYPES_EXPORT void fd_use_profile() { load_profile=1; }
DTYPES_EXPORT void fd_suppress_config() { load_config=0; }

DTYPES_EXPORT void fd_initialize_dtypes()
{
  FD_CLEAR_ERR();
  if (dtypes_initialized) return; else dtypes_initialized=1;
  fd_initialize_except_c();
  fd_initialize_fdmalloc_c();
  fd_initialize_data_c();
  fd_initialize_hash_c();
  fd_initialize_io_c();
  fd_initialize_choices_c();
  fd_initialize_oids_c();
  fd_initialize_slotmaps_c();
  fd_initialize_xdata_c();
  fd_initialize_network_c();
  fd_initialize_i18n_c();
  fd_initialize_fdprintf_c();
  fd_initialize_envfns_c();
  fd_initialize_timefns_c();
  fd_setup_signal_handlers();
  config_file=fd_string_getenv("FRAMERD_CONFIG");
  if (load_config) 
    if (config_file)
      if (strcmp(config_file,"none") == 0) {}
      else if (!(fd_file_existsp(config_file))) 
	fd_warn(_("Configuration file %s doesn't exist"),config_file);
      else {
	WITH_HANDLING {
	  fd_load_config(config_file);}
	ON_EXCEPTION {
	  CLEAR_ERR();}
	END_HANDLING;}
    else if (fd_file_existsp(DEFAULT_FRAMERD_CONFIG)) {
      WITH_HANDLING {
	config_file=fd_strdup(DEFAULT_FRAMERD_CONFIG);
	fd_load_config(DEFAULT_FRAMERD_CONFIG);}
      ON_EXCEPTION {
	CLEAR_ERR();}
      END_HANDLING;}
    else fd_warn(_("No configuration file"));
  else fd_notify(_("Configuration file suppressed"));
  if (load_profile) fd_load_user_profile();
  if (setlocale(LC_ALL,"") == NULL) {
    char *errdata=strerror(errno);
    FD_CLEAR_ERR();
#if FD_ISSUE_LOCALE_WARNING
    fd_notify(_("Invalid locale information, using default (error was %s)"),
	      errdata);
#endif
  }
  FD_TIDY_ERRNO("after setlocale");
  setlocale(LC_NUMERIC,"POSIX");
  {WITH_HANDLING
     initialize_text_encoding();
   ON_EXCEPTION {
     fd_clear_exception();
     fd_warn(_("Error %m (%m) while initializing text encoding"),
	     fd_theException(),fd_exception_details());}
   END_HANDLING}
  textdomain("framerd");
  /* Initialize network timeouts */
  {
    fd_lisp ctimeout=fd_getenv("CONNECT_TIMEOUT");
    fd_lisp rtimeout=fd_getenv("RECEIVE_TIMEOUT");
    int ct=0, rt=0;
    if (FD_FIXNUMP(ctimeout)) ct=FD_FIXLISP(ctimeout);
    else if (FD_STRINGP(ctimeout)) 
      sscanf(FD_STRING_DATA(ctimeout),"%d",&ct);
    if (FD_FIXNUMP(rtimeout)) ct=FD_FIXLISP(rtimeout);
    else if (FD_STRINGP(rtimeout)) 
      sscanf(FD_STRING_DATA(rtimeout),"%d",&rt);
    fd_set_network_timeouts(ct,rt,0);}
  fd_show_startup_herald();
}

#if ((defined(WIN32)) && (!(defined(STATICLINK))))
BOOL APIENTRY DllMain( HANDLE hModule, 
                        DWORD ul_reason_for_call, 
                        LPVOID lpReserved )
{
    switch( ul_reason_for_call ) {
    case DLL_PROCESS_ATTACH:
      fd_initialize_dtypes(); break;
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
      {}
    }
    return TRUE;
}
#endif




/* File specific stuff */

/* The CVS log for this file
   $Log: libdtypes.c,v $
   Revision 1.11  2002/07/17 01:29:10  haase
   GET-CONFIG-FILE (and its C foundation) will now return the file where the configuration file would be loaded from if it existed

   Revision 1.10  2002/06/06 18:55:15  haase
   Clear errno before the dtype init so we don't end up claiming someone else's messes

   Revision 1.9  2002/04/15 18:23:03  haase
   Allow config or env vars to set network timeouts

   Revision 1.8  2002/04/02 21:39:30  haase
   Added log and emacs init entries to C source files

*/

/* Emacs local variables
;;;  Local variables: ***
;;;  compile-command: "cd ../..; make" ***
;;;  End: ***
*/
