/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */


package net.sf.freecol.common.model;


import java.util.Map;

import net.sf.freecol.common.util.Xml;

import org.w3c.dom.Node;


public final class GoodsType
{

    public final  int        index;
    public        String     id;
    public        String     name;
    public        boolean    isFarmed;
    public boolean improvedByPlowing = false;
    public boolean improvedByRiver = false;
    public boolean improvedByRoad = false;
    public        GoodsType  madeFrom;
    public        GoodsType  makes;



    // ----------------------------------------------------------- constructors

    public GoodsType(int index) {

        this.index = index;
    }


    // ------------------------------------------------------------ API methods

    public void readFromXmlElement( Node xml, Map<String, GoodsType> goodsTypeByRef ) {

        id = Xml.attribute( xml, "name" );
        name = Xml.attribute( xml, "name" );
        isFarmed = Xml.booleanAttribute( xml, "is-farmed" );

        if ( Xml.hasAttribute(xml, "made-from") ) {

            String  madeFromRef = Xml.attribute( xml, "made-from" );
            GoodsType  rawMaterial = goodsTypeByRef.get( madeFromRef );
            madeFrom = rawMaterial;
            rawMaterial.makes = this;
        }

        if (Xml.hasAttribute(xml, "improved-by-plowing") &&
            Xml.booleanAttribute(xml, "improved-by-plowing")) {
            improvedByPlowing = true;
        }
        if (Xml.hasAttribute(xml, "improved-by-river") &&
            Xml.booleanAttribute(xml, "improved-by-river")) {
            improvedByRiver = true;
        }
        if (Xml.hasAttribute(xml, "improved-by-road") &&
            Xml.booleanAttribute(xml, "improved-by-road")) {
            improvedByRoad = true;
        }
    }


    public boolean isRawMaterial() {

        return makes != null;
    }


    public boolean isRefined() {

        return madeFrom != null;
    }

    public boolean isFarmed() {

        return isFarmed;

    }

    public boolean isImprovedByPlowing() {

        return improvedByPlowing;

    }

    public boolean isImprovedByRoad() {

        return improvedByRoad;

    }

    public boolean isImprovedByRiver() {

        return improvedByRiver;

    }

    /**
     * gets the type a good is stored at
     *
     * @param goodsType
     * @return stored goods type or -1, if it is not stored (in the warehouse)
     */
    public static int getStoredAs(int goodsType) {
        switch(goodsType) {
            case Goods.FISH:
                return Goods.FOOD;
            case Goods.BELLS:
            case Goods.CROSSES:
            case Goods.HAMMERS:
                //not stored
                return -1;
            default:
                return goodsType;
        }
    }

}
