/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.freecol.common.model;

import java.util.HashSet;

import net.sf.freecol.util.test.FreeColTestCase;

public class ModelMessageTest extends FreeColTestCase {

    public void testHashCode() {
        
        ModelMessage mm1 = new ModelMessage(getGame(), "buildColony.landLocked", null, ModelMessage.MISSING_GOODS,
                new Goods(Goods.FISH));
        ModelMessage mm2 = new ModelMessage(getGame(), "buildColony.landLocked", null, ModelMessage.MISSING_GOODS,
                new Goods(Goods.FISH));
        assertEquals(mm1, mm2);
        assertEquals(mm1.hashCode(), mm2.hashCode());
    }
    
    public void testModelMapSet() {
        ModelMessage mm1 = new ModelMessage(getGame(), "buildColony.landLocked", null, ModelMessage.MISSING_GOODS,
                new Goods(Goods.FISH));
        ModelMessage mm2 = new ModelMessage(getGame(), "buildColony.landLocked", null, ModelMessage.MISSING_GOODS,
                new Goods(Goods.FISH));
        HashSet<ModelMessage> set = new HashSet<ModelMessage>();
        set.add(mm1);
        assertTrue(set.remove(mm2));
    }
    
    public void testModelMapSet2() {
        ModelMessage mm1 = new ModelMessage(getGame(), "model.building.warehouseSoonFull",
                                    new String [][] {{"%goods%", Goods.getName(Goods.COTTON)},
                                                     {"%colony%", getName()},
                                                     {"%amount%", String.valueOf(10)}},
                                    ModelMessage.WAREHOUSE_CAPACITY,
                                    new Goods(Goods.COTTON));
        ModelMessage mm2 = new ModelMessage(getGame(), "model.building.warehouseSoonFull",
                new String [][] {{"%goods%", Goods.getName(Goods.COTTON)},
                                 {"%colony%", getName()},
                                 {"%amount%", String.valueOf(10)}},
                ModelMessage.WAREHOUSE_CAPACITY,
                new Goods(Goods.COTTON));
        HashSet<ModelMessage> set = new HashSet<ModelMessage>();
        assertEquals(mm1, mm2);
        assertEquals(mm1.hashCode(), mm2.hashCode());
        set.add(mm1);
        assertTrue(set.remove(mm2));
    }
    
}
