//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: DomainExpression.cpp,v 1.4 2003/09/04 20:18:35 delpinux Exp $

#include <DomainExpression.hpp>
#include <Variable.hpp>

#include <Scene.hpp>
#include <Domain.hpp>

ReferenceCounting<Domain> DomainExpression::domain() const
{
  assert(__domainType != DomainExpression::undefined);
  return __domain;
}

DomainExpression::DomainExpression(const DomainExpression& e)
  : Expression(e),
    __domain(e.__domain),
    __domainType(e.__domainType)
{
  ;
}

DomainExpression::DomainExpression(ReferenceCounting<Domain> domain,
				   const DomainExpression::DomainType& t)
  : Expression(Expression::domain),
    __domain(domain),
    __domainType(t)
{
  ;
}

DomainExpression::~DomainExpression()
{
  ;
}


std::ostream& DomainExpressionSet::put(std::ostream& os) const
{
  os << __FILE__ << ':' << __LINE__ << ": NOT IMPLEMENTED\n";
  return os;
}

ReferenceCounting<SceneExpression>
DomainExpressionSet::scene()
{
  return __scene;
}

void DomainExpressionSet::execute()
{
  ffout(2) << "Building Domain ...\n";
  (*__scene).execute();
  const Scene& S = *(*__scene).scene();

  __domain = new Domain(S);

  if(__definition != 0) {
    (*__definition).execute();
    ffout(2) << "\tDomain is: " << *__definition << '\n';
    (*__domain).setObjects((*__definition).objects(S));
  }
  ffout(2) << "Done\n";
}

DomainExpressionSet::
DomainExpressionSet(ReferenceCounting<SceneExpression> S,
		    ReferenceCounting<InsideListExpression> def)
  : DomainExpression(0,
		     DomainExpression::set),
    __scene(S),
    __definition(def)
{
  ;
}


DomainExpressionSet::
DomainExpressionSet(const DomainExpressionSet& m)
  : DomainExpression(m),
    __scene(m.__scene)
{
  ;
}

DomainExpressionSet::
~DomainExpressionSet()
{
  ;
}

ReferenceCounting<DomainExpression>
DomainExpressionVariable::domainExpression() const
{
  return (*__domainVariable).expression();
}

DomainExpressionVariable::
DomainExpressionVariable(ReferenceCounting<DomainVariable> r)
  : DomainExpression(0,
		     DomainExpression::variable),
    __domainVariable(r)
{
  ;
}

DomainExpressionVariable::
DomainExpressionVariable(const DomainExpressionVariable& e)
  : DomainExpression(e),
    __domainVariable(e.__domainVariable)
{
  ;
}

DomainExpressionVariable::~DomainExpressionVariable()
{
  ;
}

void DomainExpressionVariable::execute()
{
  __domain = (*(*__domainVariable).expression()).domain();
}


DomainExpressionUndefined
::DomainExpressionUndefined()
  : DomainExpression(0,
		     DomainExpression::undefined)
{
  ;
}

DomainExpressionUndefined
::DomainExpressionUndefined(const DomainExpressionUndefined& m)
  : DomainExpression(m)
{
  ;
}

DomainExpressionUndefined
::~DomainExpressionUndefined()
{
  ;
}

