//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2005 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: DiscretizationType.hpp,v 1.1 2005/09/25 14:11:47 delpinux Exp $

#ifndef DISCRETIZATION_TYPE_HPP
#define DISCRETIZATION_TYPE_HPP

/**
 * @file   DiscretizationType.hpp
 * @author Stephane Del Pino
 * @date   Mon May 30 23:28:37 2005
 * 
 * @brief  This class describes type of Discretization
 * 
 */
class DiscretizationType
{
public:
  enum Type {
    LagrangianFEM1 = 0,		/**< Lagrangian finite element of degree 1 */
    LagrangianFEM2 = 1		/**< Lagrangian finite element of degree 2 */
  };

private:
  const Type __type;

public:
  const Type& type() const
  {
    return __type;
  }

  DiscretizationType(const DiscretizationType::Type& type = LagrangianFEM1)
    : __type(type)
  {
    ;
  }

  DiscretizationType(const DiscretizationType& d)
    : __type(d.__type)
  {
    ;
  }

  ~DiscretizationType()
  {
    ;
  }
};


#endif // DISCRETIZATION_TYPE_HPP
