//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: P2TetrahedronFiniteElement.cpp,v 1.1 2005/09/25 14:04:32 delpinux Exp $

#include <P2TetrahedronFiniteElement.hpp>

TinyVector<3, real_t> P2TetrahedronFiniteElement::__massCenter(0.25, 0.25, 0.25);
const size_t

P2TetrahedronFiniteElement::
facesDOF[Tetrahedron::NumberOfFaces][P2TetrahedronFiniteElement::numberOfFaceLivingDegreesOfFreedom]
= {{1,2,3,5,8,9},
   {0,2,3,6,7,9},
   {0,1,3,4,7,8},
   {0,1,2,4,5,6}};

real_t
P2TetrahedronFiniteElement::W(const size_t& i,
			      const TinyVector<3>& X) const
{
  const real_t& x = X[0];
  const real_t& y = X[1];
  const real_t& z = X[2];

  switch (i) {
    // Vertices basis functions 
  case 0: {
    return (1-x-y-z)*(1-x-y-z);
  }
  case 1: {
    return x*x;
  }
  case 2: {
    return y*y;
  }
  case 3: {
    return z*z;
  }
    // Edges basis functions
  case 4: {
    return 4*(1-x-y-z)*x;
  }
  case 5: {
    return 4*x*y;
  }
  case 6: {
    return 4*(1-x-y-z)*y;
  }
  case 7: {
    return 4*(1-x-y-z)*z;
  }
  case 8: {
    return 4*x*z;
  }
  case 9: {
    return 4*y*z;
  }
  default: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "unexpected basis function number",
		       ErrorHandler::unexpected);
    return 0.;
  }
  }
}

real_t
P2TetrahedronFiniteElement::dxW(const size_t& i,
				const TinyVector<3>& X) const
{
  const real_t& x = X[0];
  const real_t& y = X[1];
  const real_t& z = X[2];

  switch (i) {
    // Vertices basis functions 
  case 0: {
    return -2*(1-x-y-z);
  }
  case 1: {
    return 2*x;
  }
  case 2: {
    return 0;
  }
  case 3: {
    return 0;
  }
    // Edges basis functions
  case 4: {
    return 4*(1-2*x-y-z);
  }
  case 5: {
    return 4*y;
  }
  case 6: {
    return -4*y;
  }
  case 7: {
    return -4*z;
  }
  case 8: {
    return 4*z;
  }
  case 9: {
    return 0;
  }
  default: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "unexpected basis function number",
		       ErrorHandler::unexpected);
    return 0.;
  }
  }
}

real_t
P2TetrahedronFiniteElement::dyW(const size_t& i,
				const TinyVector<3>& X) const
{
  const real_t& x = X[0];
  const real_t& y = X[1];
  const real_t& z = X[2];

  switch (i) {
    // Vertices basis functions 
  case 0: {
    return -2*(1-x-y-z);
  }
  case 1: {
    return 0;
  }
  case 2: {
    return 2*y;
  }
  case 3: {
    return 0;
  }
    // Edges basis functions
  case 4: {
    return -4*x;
  }
  case 5: {
    return 4*x;
  }
  case 6: {
    return 4*(1-x-2*y-z);
  }
  case 7: {
    return -4*z;
  }
  case 8: {
    return 0;
  }
  case 9: {
    return 4*z;
  }
  default: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "unexpected basis function number",
		       ErrorHandler::unexpected);
    return 0.;
  }
  }
}

real_t 
P2TetrahedronFiniteElement::dzW(const size_t& i,
				const TinyVector<3>& X) const
{
  const real_t& x = X[0];
  const real_t& y = X[1];
  const real_t& z = X[2];

  switch (i) {
    // Vertices basis functions 
  case 0: {
    return -2*(1-x-y-z);
  }
  case 1: {
    return 0;
  }
  case 2: {
    return 0;
  }
  case 3: {
    return 2*z;
  }
    // Edges basis functions
  case 4: {
    return -4*x;
  }
  case 5: {
    return 0;
  }
  case 6: {
    return -4*y;
  }
  case 7: {
    return 4*(1-x-y-2*z);
  }
  case 8: {
    return 4*x;
  }
  case 9: {
    return 4*y;
  }
  default: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "unexpected basis function number",
		       ErrorHandler::unexpected);
    return 0.;
  }
  }
}
