package freenet;

import freenet.support.Fields;
import java.util.StringTokenizer;

/**
 * Central spot for stuff related to the versioning of the codebase.
 */
public abstract class Version {

    /** FReenet Reference Daemon */
    public static final String nodeName = "Fred";
    
    /** The current version tree */ 
    public static final String nodeVersion = "0.4";
    
    /** The protocolversion supported */
    public static final String protocolVersion = "1.45";
    
    /** The build number of the current revision */
    public static final int buildNumber = 465;
    
    /** Oldest build of Fred we will talk to */
    public static final int lastGoodBuild = 465;
    
    /** Revision number of Version.java as read from CVS */
    public static final String cvsRevision;
    static {    
        StringTokenizer cvsId = new StringTokenizer(
            "$Id: Version.java,v 1.22 2002/04/11 02:35:19 sanity Exp $"
        );
        cvsId.nextToken();
        cvsId.nextToken();
        cvsRevision = cvsId.nextToken();
    }
    
    private static final String[] versionArray = new String[]
        { nodeName, nodeVersion, protocolVersion, ""+buildNumber };
    private static final String versionString = Fields.commaList(versionArray);
    
    
    /**
     * @return  the node's version designators as an array
     */
    public static final String[] getVersion() {
        return versionArray;
    }

    /**
     * @return  the version string that should be presented
     *          in the NodeReference
     */
    public static final String getVersionString() {
        return versionString;
    }

    /**
     * @return  true if requests should be accepted from nodes
     *          brandishing this version string
     */
    public static final boolean checkGoodVersion(String version) {
        String[] v = Fields.commaList(version);
        if (v.length < 3 || !v[2].equals(protocolVersion)) {
            return false;
        }
        if (v.length >= 4 && v[0].equals(nodeName)) {
            int build = Integer.parseInt(v[3]);
            if (build < lastGoodBuild)
                return false;
        }
        return true;
    }

    /**
     * @return  why a version string is rejected
     */
    public static final String explainBadVersion(String version) {
        String[] v = Fields.commaList(version);
        if (v.length < 3 || !v[2].equals(protocolVersion)) {
            return "Required protocol version is "+protocolVersion;
        }
        if (v.length >= 4 && v[0].equals(nodeName)) {
            int build = Integer.parseInt(v[3]);
            if (build < lastGoodBuild)
                return "Build older than last good build "+lastGoodBuild;
        }
        return null;
    }
}

