package freenet.client;

import freenet.*;
import freenet.crypt.*;
import freenet.keys.SVK;
import java.io.*;
import java.util.Random;
import java.math.BigInteger;

/**
 * ClientKey implementation for KSKs
 *
 * @author sgm
 */
public class ClientKSK extends ClientSVK {

    public static ClientKey createFromInsertURI(Random r, FreenetURI uri) throws KeyException {
        return new ClientKSK(r, uri.getDocName());
    }
    
    public static ClientKey createFromRequestURI(FreenetURI uri) throws KeyException {
        if (uri.getDocName() == null)
            throw new KeyException("Unspecified KSK name");
        return new ClientKSK(uri.getDocName());
    }

    
    // for KSK, all we need to do is set up all the internal
    // values immediately on construction, then act like an SVK

    private String keyword;

    public ClientKSK(String keyword) throws KeyException {
        this(null, keyword);
    }

    public ClientKSK(Random r, String keyword) throws KeyException {
        super( r, null, null,
               new DSAPrivateKey(new BigInteger(1, Util.hashString(new SHA1(), keyword))),
               getDefaultDSAGroup() );
        this.keyword = keyword;
        this.svk = new SVK(pk, null, SVK.SVK_LOG2_MAXSIZE);
    }

    /** @return "KSK"
      */
    public String keyType() {
        return "KSK";
    }
    
    protected void makeCryptoKey() throws UnsupportedEncodingException {
        byte[] entropy = keyword.getBytes("UTF8");
        cryptoKey = new byte[cipher.getKeySize() >> 3];
        Util.makeKey(entropy, cryptoKey, 0, cryptoKey.length);
    }
    
    public static DSAGroup getDefaultDSAGroup() {
        return Global.DSAgroupA;
    }

    public FreenetURI getURI() {
        return new FreenetURI(keyType(), keyword);
    }

    public String getKeyword() {
        return keyword;
    }

/*
    public static void main(String[] args) throws Exception {
        ClientKSK s=new ClientKSK(new Yarrow(), args[0]);
        s.getKey();
        s.getEncryptionKey(16);
        System.err.println(s.getURI());
        FreenetURI n=new FreenetURI(s.getURI().toString());
        n.decompose();
    }
*/
}



        
        
