package freenet.client;
import java.util.Vector;
import java.util.Enumeration;

/**
 * Event handeling for clients. SimpleEventProducer is a simple
 * ClientEventProducer implementation that can be used for others.
 *
 * @author oskar
 **/
public class SimpleEventProducer implements ClientEventProducer {

    private Vector listeners;

    /**
     * Create a new SimpleEventProducer
     *
     **/
    public SimpleEventProducer() {
	listeners = new Vector();
    }
    
    /** Create a new SimpleEventProducer with the given listeners. */
    public SimpleEventProducer(ClientEventListener[] cela) {
	this();
	for (int i = 0 ; i < cela.length ; i++)
	    addEventListener(cela[i]);
    }

    public void addEventListener(ClientEventListener cel) {
	listeners.addElement(cel);
    }

    public boolean removeEventListener(ClientEventListener cel) {
	return listeners.removeElement(cel);
    }

    /**
     * Sends the ClientEvent to all registered listeners of this object.
     **/
    public void produceEvent(ClientEvent ce) {
	for (Enumeration e = listeners.elements() ; 
	     e.hasMoreElements();) {
	    ((ClientEventListener) e.nextElement()).receive(ce);
	}
    }
    
    /** Returns the listeners as an array. */
    public ClientEventListener[] getEventListeners() {
	ClientEventListener[] ret =
	    new ClientEventListener[listeners.size()];
	listeners.copyInto(ret);
	return ret;
    }

    /** Adds all listeners in the given array. */
    public void addEventListeners(ClientEventListener[] cela) {
	for (int i = 0 ; i < cela.length ; i++)
	    addEventListener(cela[i]);
    }
}
