package freenet.client.listeners;

import freenet.client.*;
import freenet.client.events.*;
import java.util.Stack;

public class SegmentCompleteListener implements ClientEventListener
{
    private boolean isComplete = false;

    public synchronized void waitEvent() throws InterruptedException {
        while(!isComplete) wait();
    }
    
    public void receive(ClientEvent ce) {
        if (ce instanceof SegmentCompleteEvent) {
            synchronized(this) {
                isComplete=true;
                notifyAll();  
            }
        }
        else if (ce instanceof StateReachedEvent) {
            int state=((StateReachedEvent)ce).getState();
            if((state==Request.DONE)||(state==Request.FAILED)) {
               synchronized(this) {
                 isComplete=true;
                 notifyAll();
               }
            }
        }
    }
}
