package freenet.fs;

/**
 * A token that can be registered with a lock in order to be
 * notified when that lock advances or unlocks completely.
 * @author tavin
 */
public interface LockSignal {

    /**
     * Notifies that a lock has moved forward.
     * @param src  the ticket of the lock raising the signal
     * @param pos  the new byte-pointer value
     */
    void signalMove(LockTicket src, long pos);

    /**
     * Notifies that a lock has unlocked.
     * @param src      the ticket of the lock that unlocked
     * @param failed   true if the lock unlocked before
     *                 reading/writing its entire byte range
     */
    void signalUnlock(LockTicket src, boolean failed);
}


