package freenet.fs.acct;

import freenet.fs.*;
import freenet.crypt.Digest;
import java.io.IOException;

/**
 * A SingleAccountingProcess that blindly increases the size of
 * the AccountingTable whenever necessary (so that the AccountingTable
 * always occupies a single Fragment of the needed size, located at
 * the beginning of the storage).  Intended for use with the
 * UnlimitedRAFStorage to create dedicated database files.
 * 
 * @see freenet.fs.UnlimitedRAFStorage
 * @author tavin
 */
public class UnlimitedAccountingProcess extends SingleAccountingProcess {

    public UnlimitedAccountingProcess(AccountingInitializer init) {
        super(init);
    }

    
    private void resizeTo(int blockCount) {
        AccountingTable acct = getAccountingTable();
        Fragment f = new Fragment(blockCount * acct.getBlockWidth());
        setAccountingTable(new AccountingTable(acct, new Fragment[] {f}));
    }


    public void flush() throws IOException {
        if (getFreeCount() < 0)
            resizeTo(getBlockCount() - getFreeCount());
        super.flush();
    }

    public void freeze() throws IOException {
        if (getFreeCount() < 0)
            resizeTo(getBlockCount() - getFreeCount());
        super.freeze();
    }
}


