package freenet.fs.acct.sys;

import freenet.fs.*;
import freenet.fs.acct.*;
import freenet.crypt.SHA1;
import freenet.support.*;
import freenet.support.BinaryTree.Node;
import freenet.config.Params;
import java.io.*;

/**
 * This is a toy program I wrote to demonstrate, and test out,
 * rudimentary AccountingTree functions.
 * @author tavin
 */
public class WordFile extends AccountingFile {

    public static void main(String[] args) throws Exception {
        new WordFile().mainImpl(args);
    }
    
    
    UnlimitedAccountingProcess proc;
    AccountingTree tree;


    protected void usage() throws IOException {
        System.out.println("Usage: java " + WordFile.class.getName() +
                           " <file> [<command>]");
        switches.printUsage(System.out);
    }
    
    protected void handle(Params params, AccountingTable acct) throws Exception {

        String cmd = params.getArg(1);
        if (cmd == null)
            cmd = "";

        if (cmd.equals("keys") && params.getNumArgs() == 2) {
            init(acct);
            Walk keys = keys();
            String k;
            while (null != (k = (String) keys.getNext()))
                System.out.println(k);
        }
        else if (cmd.equals("get") && params.getNumArgs() == 3) {
            init(acct);
            System.out.println(get(params.getArg(2)));
        }
        else if (cmd.equals("put") && params.getNumArgs() == 4) {
            init(acct);
            System.out.println(proc);
            put(params.getArg(2), params.getArg(3));
            System.out.println(proc);
            proc.flush();
            System.out.println(proc);
        }
        else {
            super.handle(params, acct);
        }
    }

    private void init(AccountingTable acct) throws IOException {
        AccountingInitializer init = new AccountingInitializer(acct);
        proc = new UnlimitedAccountingProcess(init);
        tree = new AccountingTree(proc, new WordPair.Marshal(), new NullCache());
        init.initialize(tree);
    }
    
    
    Walk keys() {
        return new KeysWalk(tree.treeWalk(true));
    }

    private static final class KeysWalk implements Walk {
    
        private final Walk walk;
        
        KeysWalk(Walk walk) {
            this.walk = walk;
        }
        
        public final Object getNext() {
            Node n = (Node) walk.getNext();
            return n == null ? null : ((WordPair) n.getObject()).key;
        }
    }
    
    

    String get(String key) {
        Node n = tree.treeSearch(new WordPair(key, null));
        return n == null ? null : ((WordPair) n.getObject()).val;
    }

    String put(String key, String val) throws IOException {
        Node old = tree.treeInsert(new AccountingTreeNode(new WordPair(key, val)), true);
        return old == null ? null : ((WordPair) old.getObject()).val;
    }



    private static final class WordPair implements freenet.support.Comparable {

        private static final class Marshal implements AccountingTreeMarshal {
            public final freenet.support.Comparable readEntry(DataInput din, int len)
                                                throws IOException {

                byte[] key = new byte[din.readUnsignedShort()];
                din.readFully(key);
                byte[] val = new byte[din.readUnsignedShort()];
                din.readFully(val);
                return new WordPair(new String(key), new String(val));
            }
            public final int getEntryLength(freenet.support.Comparable entry) {
                WordPair wp = (WordPair) entry;
                return 4 + wp.key.getBytes().length + wp.val.getBytes().length;
            }
            public final void writeEntry(freenet.support.Comparable entry, DataOutput out)
                                                        throws IOException {
                WordPair wp = (WordPair) entry;
                byte[] key = wp.key.getBytes();
                byte[] val = wp.val.getBytes();
                out.writeShort(key.length);
                out.write(key);
                out.writeShort(val.length);
                out.write(val);
            }
        }


        final String key, val;

        WordPair(String key, String val) {
            this.key = key;
            this.val = val;
        }

        public final int compareTo(Object o) {
            return compareTo((WordPair) o);
        }

        public final int compareTo(WordPair wp) {
            return key.compareTo(wp.key);
        }
    }
}


