package freenet.fs.dir;

import freenet.fs.acct.Fragment;
import freenet.support.Comparable;

/**
 * An entry in the accounting tables for a fragment allocation.
 * @author tavin
 */
abstract class FragmentRecord extends Fragment implements Comparable {

    final long ticketID;
    

    FragmentRecord(long size) {
        super(size);
        this.ticketID = -1;
    }
    
    
    FragmentRecord(Fragment f) {
        this(f, -1);
    }
    
    FragmentRecord(Fragment f, long ticketID) {
        super(f);
        this.ticketID = ticketID;
    }
    

    FragmentRecord(long lo, long hi) {
        this(lo, hi, -1);
    }
    
    FragmentRecord(long lo, long hi, long ticketID) {
        super(lo, hi);
        this.ticketID = ticketID;
    }

    
    /**
     * @return  the ticket ID associated with this fragment
     */
    final long id() {
        return ticketID;
    }
}


