/*
 *$Id: DataRequest.java,v 1.1.1.1 2002/01/13 05:24:38 sanity Exp $

  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Node (1.0)
                    Address (1.0)
		    Message (1.0)
 */

/**
 * This is the DataRequest message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.node.states.FNP.NewDataRequest;
import freenet.support.*;
//import java.net.*;

public class DataRequest extends Request {

    public static final String messageName = "DataRequest";
    
    public DataRequest(long idnum, long htl, Key key, NodeReference ref) {
	super(idnum, htl, key, ref);
    }

    public DataRequest(long idnum, long htl, Key key, NodeReference ref,
                       FieldSet otherFields) {
	super(idnum, htl, key, ref, otherFields);
    }

    public DataRequest(ConnectionHandler source, RawMessage raw) throws InvalidMessageException {
	super(source, raw);
    }
  	
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	//raw.messageType="DataRequest";
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    public State getInitialState() {
	return new NewDataRequest(id);
    }

}


/*
 *$Log: DataRequest.java,v $
 *Revision 1.1.1.1  2002/01/13 05:24:38  sanity
 *Imported source
 *
 *Revision 1.43  2001/08/23 01:22:10  oierw
 *merge 0.4 to HEAD (hopefully)
 *
 *Revision 1.41.8.8  2001/07/26 22:03:35  hobbex
 *Redid the states of the connectionhandler, it works but there could still be some bugs. Also made NodeMessage abstract on Message
 *
 *Revision 1.41.8.7  2001/06/19 20:41:57  hobbex
 *Implemented Announcement protocol on Bobs side.
 *
 *Revision 1.41.8.6  2001/05/10 06:38:28  scipient
 *various tweaks to support NodeRef. in Request Source, DFS buckets
 *
 *Revision 1.41.8.5  2001/04/28 16:41:51  scipient
 *changed initial states to NewRequest states in Freenet.node.states.FNP
 *
 *Revision 1.41.8.4  2001/04/14 19:15:28  hobbex
 *Client ideas
 *
 *Revision 1.41.8.3  2001/04/01 20:59:58  hobbex
 *Broke everything again. Sigh.
 *
 *Revision 1.41.8.2  2001/01/28 21:15:48  hobbex
 *Data and Request states finally compile!!!!
 *
 *Revision 1.41.8.1  2001/01/17 01:51:23  hobbex
 *Committing updates to experimental
 *
 *Revision 1.41  2000/08/28 14:00:43  hobbex
 *Finished the changeover from Callbacks objects MessageObjects
 *
 *Revision 1.40  2000/08/26 17:52:30  hobbex
 *New heap based ticker which operates on MessageObjects instead of callbacks (some of the support for this is still sketchy and not heavily tested). Also fixed bug in CIS, interrupting CHK tunnels works smoothly now
 *
 *Revision 1.39  2000/08/24 13:03:59  hobbex
 *Added support for DNS names in DataSource reference, and changed the names of the new Clients to the old names. The old clients can be found in Freenet.client.old though they don't quite build I think.
 *
 *Revision 1.38  2000/08/12 06:40:35  hobbex
 *Renamed incorrectly named 'Transport' layer to Presentation
 *
 *Revision 1.37  2000/08/08 06:46:18  hobbex
 *Changed logger and fixed up ClientCore, ClientMessageHandler. The syntax to log a comment is now Freenet.Core.logger.log(javaa.lang.Object,java.lang.String,int) , see support.Logger and support.StandardLogger for more.
 *
 *Revision 1.36  2000/08/05 06:40:48  hobbex
 *Much better model for handeling message related code (Restarting, Verifying data, failing etc)
 *
 *Revision 1.35  2000/08/02 16:25:40  hobbex
 *CHK, KSK, and SVK support. Stream verifying, stream forking, and more.
 *
 *Revision 1.34  2000/05/26 01:25:16  trost
 *1. Removed the "Metadata" classes that Brandon indicated should have been
 *removed, along with files that depended on them.
 *
 *2. Extracted Request.RequestAbortException into a standalone class.
 *Nesting the class was doing no one any favors, and kept confusing kaffe.
 *
 *Revision 1.33  2000/05/16 08:51:40  scgmille
 *
 *Moved Document to client/Document.
 *Renamed node.Document to node.Entity.  Modified all affected files
 *Completed document-level crypto and verification.
 *TODO: Add cipher selection, Symmetric-cipher storable on insert, Fix
 *requestclient's failure to terminate after transfer.
 *
 *Revision 1.32  2000/05/09 00:02:09  hobbex
 *Added pluggable presentation protocols.
 *Added plugs for implementing crypto.
 *The new presentation handles dotted fields, and reads and writes all numbers as hex rather then decimal or hex as before. We can back out of the latter if people really don't like it.
 *Bumped protocol to 1.21 and build to 129.
 *
 *Revision 1.31  2000/04/27 14:37:41  trost
 *Multicastecomy.
 *
 *Revision 1.30  2000/04/26 22:46:01  trost
 *Multicasted DataRequest queries added.  Also fixed a bug in
 *Message.sendReply() regarding which ConnectionHandler to use.
 *
 *Revision 1.29  2000/04/23 20:49:10  hobbex
 *Fixed serialization of datastore (version 2 now, includes properties and actually works).
 *Added functionality to close on inactive to the ConnectionHandler. If the last message had no "Source", it will not close.
 *Fixed timeout to soon in java clients.
 *
 *Revision 1.28  2000/04/17 16:29:51  scgmille
 *
 *sgm - Added random number source interface and two implementations, an SHA1
 *based entropy pool, and a random data file (/dev/urandom, f.e.)
 *Modified all existing uses of java.util.Random to use the random source,
 *which is currently the EntropyPool (since it's cross platform).
 *
 *Revision 1.27  2000/04/17 02:19:18  thong
 *Added support for Storable.* headers
 *
 *Revision 1.26  2000/04/07 20:34:09  hobbex
 *Fixed building and running with Kaffe (scripts/kbuild.sh). Added canceling of timer callback and sending of requestfailed on loosing MessageMemory (not too well tested). And fixed a bug in the datastore + some exception catching in requestfailed.
 *
 *Revision 1.25  2000/04/05 22:14:08  hobbex
 *Unknown message fields are passed, and source is now optional for clients
 *
 *Revision 1.24  2000/03/30 11:32:27  hobbex
 *Close connections after sending KeepAlive=false message
 *
 *Revision 1.23  2000/03/29 18:49:14  hobbex
 *Subclassed Node from Core, added Freenet.node package
 *
 *Revision 1.22  2000/03/27 21:02:32  hobbex
 *Sustained streams
 *
 *Revision 1.21  2000/03/06 10:00:32  hobbex
 *Large change to the way Inserts are handled. The chain is now InsertRequest->InsertReply->DataInsert.
 *
 *Revision 1.20  2000/02/29 06:47:31  blanu
 *Fixed DataRequest not generating DataLength field in DataReply.
 *
 *Revision 1.19  2000/02/23 20:52:42  blanu
 *Fixed timeout in client.
 *
 *Revision 1.18  2000/02/20 03:22:39  blanu
 *Connections now timeout after connectTimeout milliseconds, as per the config file.
 *
 *Revision 1.17  2000/02/13 21:11:01  hobbex
 *removed searchKey field from DataReply
 *
 *Revision 1.16  2000/02/13 14:06:27  sanity
 *Changed so that timeouts always start with a timeout of 256 to ensure that
 *they reach their destination.
 *
 *Revision 1.15  2000/02/08 14:24:30  hobbex
 *Added timeout and restart on no reply functionality to requests
 *
 *Revision 1.14  2000/02/02 15:58:57  sanity
 *Changed Freenet client so that keys are now hashed!
 *
 *Revision 1.13  2000/01/31 13:22:50  hobbex
 *Changed the method for setting the DataSource in replies, and added a couple more get mthods to the connection
 *
 *Revision 1.12  2000/01/27 15:45:39  sanity
 *Some bug fixes, added localAddress field to Node.java which is used by
 *DataRequest and DataReply messages to set dataSource field.  Also removed
 *untidy debugging stuff from RawMessage.
 *
 *Revision 1.11  2000/01/27 10:01:11  sanity
 *Added "origin" field to DataReply which stores either the node where the
 *data originated, or a node closer to where the data originated.  This is
 *the functionality as described in the Freenet report.
 *
 *Revision 1.10  2000/01/27 00:52:34  hobbex
 *Added backtracking QueryAborted messages
 *
 *Revision 1.9  2000/01/19 15:12:21  hobbex
 *Fixed handeling of bad node addresses (SendFailedException)
 *
 *Revision 1.8  2000/01/11 01:01:46  hobbex
 *added Depth field to all messages for setting hopsToLive of replies
 *
 *Revision 1.7  2000/01/10 21:54:46  hobbex
 *Fixed timeout of Requests, all messages sent as a result of a Request now inherit the HTL of the original
 *
 *Revision 1.6  2000/01/09 18:46:41  hobbex
 *Fixed setting of source field on multihomed nodes - I hope
 *
 *Revision 1.5  2000/01/06 01:04:50  hobbex
 *Don't forward Inserts and Reuqests to self or source, don't accept inserts if key is known, and added an Address.equals method
 *
 *Revision 1.4  2000/01/03 10:20:48  hobbex
 *Removed deleting of MM on Loop and Failed Request
 *
 *Revision 1.3  2000/01/02 19:10:49  michaels
 *Reverted last change - has to be discussed first
 *
 *Revision 1.2  2000/01/02 14:30:04  michaels
 *On a loop pReceived returns sb not null - seems to work, don't know
 *about sideeffects
 *
 */




