package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;

/** This is the message for FCP ClientGet
  */
public class ClientGet extends ClientRequest {

    public static final String messageName = "ClientGet";

    public ClientGet(ConnectionHandler source, RawMessage raw) {
        super(source, raw);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing ClientGet message.")
            : (State) new NewClientGet(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}


