package freenet.node.http.infolets;
import freenet.node.http.Infolet;
import freenet.node.Node;
import freenet.node.FailureTable;

import java.io.PrintWriter;

/**
 * Prints the contents of the FailureTable.
 */

public class FailureTableInfolet extends Infolet {

    private FailureTable ft;

    public String longName() {
        return "Failure table.";
    }

    public String shortName() {
        return "ftable";
    }

    public void init(Node n) {
        ft = n.ft;
    }

    public void toHtml(PrintWriter pw) {
        pw.println("<h3>Table of recently failed keys.</h3>");
        pw.println("The node keeps a list of keys that recently could not be "
                   + "found, and automatically ends requests for them with " 
                   + "the same or lower HTL.<br><br>");
        ft.writeHtml(pw);
    }


}

