package freenet.node.rt;

import freenet.Identity;
import freenet.node.NodeReference;
import freenet.support.Walk;
import freenet.support.BinaryTree.Node;
import java.util.Hashtable;

/**
 * This iterates over a metric walk of Reference nodes in the binary tree.
 * Each time a unique Identity is encountered it becomes the next route,
 * if its RoutingMemory can pass the isRoutable() test.
 * @author tavin
 */
class TreeRouting implements Routing {

    protected final Hashtable steps = new Hashtable();

    protected final TreeRoutingTable rt;
    
    protected final Walk refWalk;

    protected RoutingMemory mem;
    

    TreeRouting(TreeRoutingTable rt, Walk refWalk) {
        this.rt = rt;
        this.refWalk = refWalk;
    }
    

    public NodeReference getNextRoute() {
        synchronized (rt) {
            while (true) {
                Node n = (Node) refWalk.getNext();
                if (n == null) {
                    mem = null;
                    return null;
                }
                Reference ref = (Reference) n.getObject();
                if (!steps.containsKey(ref.ident)) {
                    mem = rt.routingStore.getNode(ref.ident);
                    if (mem == null) {  // race condition ?
                        continue;
                    }
                    if (rt.isRoutable(mem)) {
                        steps.put(ref.ident, ref.ident);
                        //rt.attempted(mem);
                        return mem.getNodeReference();
                    }
                }
            }
        }
    }

    public final Identity getLastIdentity() {
        return mem == null ? null : mem.getIdentity();
    }

    public final void routeConnected() {
        rt.routeConnected(mem);
    }

    public final void routeAccepted() {
        rt.routeAccepted(mem);
    }

    public final void routeSucceeded() {
        rt.routeSucceeded(mem);
    }

    public final void connectFailed() {
        rt.connectFailed(mem);
    }

    public final void authFailed() {
        rt.authFailed(mem);
    }

    public final void timedOut() {
        rt.timedOut(mem);
    }

    public final void transferFailed() {
        rt.transferFailed(mem);
    }

    public final void verityFailed() {
        rt.verityFailed(mem);
    }

    public final void queryRejected(long attenuation) {
        rt.queryRejected(mem, attenuation);
    }
}


