package freenet.node.states.announcing;

import freenet.*;
import freenet.node.*;
import freenet.crypt.*;

public abstract class AnnouncingState extends State implements AggregatedState {

    
    static final Digest ctx = new SHA1();
    
    
    final int hopsToLive;
    final int tryNumber;
    final Peer target;
    
    byte[] myVal;

    
    AnnouncingState(long id, int hopsToLive, int tryNumber, Peer target) {
        super(id);
        this.hopsToLive = hopsToLive;
        this.tryNumber = tryNumber;
        this.target = target;
    }

    AnnouncingState(AnnouncingState as) {
        super(as.id());
        hopsToLive = as.hopsToLive;
        tryNumber = as.tryNumber;
        target = as.target;
        myVal = as.myVal;
    }
        
    public State received(Node n, MessageObject mo) throws StateException {
        // customary source check
        if (mo instanceof Message &&
            !target.equalsIdent(((Message) mo).peerIdentity())) {
            throw new BadStateException("Reply from wrong node: "+mo);
        }
        return super.received(n, mo);
    }

    public void lost(Node n) {}
    
    /**
     * 99% confidence interval
     */
    public static final long getTime(long htl) {
        return (long) (Core.hopTimeExpected * htl 
                       + 2.33 * Math.sqrt(htl) * Core.hopTimeDeviation);
    }
}


