package freenet.session;

import java.math.BigInteger;
import freenet.crypt.*;
import freenet.*;
import freenet.support.Logger;
import java.util.*;
import java.io.IOException;

interface LinkToken {
    
    // This interface seems a little pointless...
    // ... I'll find a point!

    /** @return  the timestamp in millis when this link is considered
      *          expired for inbound connections
      *
      * This must be later than the outboundExpiresAt() time, by
      * a reasonable grace period.
      */
    long inboundExpiresAt();

    /** @return  the timestamp in millis when this link is considered
      *          expired for outbound connections 
      */
    long outboundExpiresAt();

    /** Called before the LinkToken is thrown away;  for whatever 
      * cleanup needs doing.
      */
    void expire();

    /**
     * Returns a ConnectionHandler that is not busy sending at the moment
     * for this link.
     */
    //    ConnectionHandler freeLink();

    /**
     * Returns a ConnectionHandler that is not busy and has the specified 
     * address.
     */
    //    ConnectionHandler freeLink(Address addr);
    
    /**
     * Returns a ConnectionHandler that is not busy and has the specified 
     * transport.
     */
    //    ConnectionHandler freeLink(Transport transport);


    //    void addPhysicalLink(ConnectionHandler l);
    
    // public void removePhysicalLink(ConnectionHandler l);

}

