package freenet.support;

/**
 * Contains synchronized methods for a count.
 * @author oskar
 */

public class Count {

    private Object sync;
    private int count;

    /**
     * Create a new toggle that synchronizes on itself.
     * @param initialCount The initial count of the switch.
     */
    public Count(int initialCount) {
        this.count = initialCount;
        this.sync = this;
    }

    /**
     * Create a new toggle that synchronizes on another object to switch.
     * @param initialCount The initial count of the switch.
     * @param sync   The object to synchonize on.
     */
    public Count(int initialCount, Object sync) {
        this.count = initialCount;
        this.sync = sync;
    }

    /**
     * Incremement the count. Synchronizes as instructed by constructor.
     * @return  the new value
     */
    public int incCount() {
        synchronized(sync) {
            return ++count;
        }
    }

    /**
     * Decremenet the count. Synchronizes as instructed by constructor.
     * @return  the new value
     */
    public int decCount() {
        synchronized(sync) {
            return --count;
        }
    }

    /**
     * Return the count. Synchronizes as instructed by constructor.
     */
    public int count() {
        synchronized(sync) {
            return count;
        }
    }

    /**
     * Returns the object given as the second argument of the second
     * constructor, or this if the first was used.
     */
    public Object getSync() {
        return sync;
    }
}
