package freenet.support;

import java.util.Enumeration;

public class LRUQueue {

    /*
     * I moves this over to a linked list from a vector, because thinking
     * about the way it was was keeping me awake at night. 
     *
     * It is still O(n) but at least this looses all the memcopies.
     */
    private final DoublyLinkedListImpl list = new DoublyLinkedListImpl();

    /**
     *       push()ing an object that is already in
     *       the queue moves that object to the most
     *       recently used position, but doesn't add
     *       a duplicate entry in the queue.
     */
    public final synchronized void push(Object obj) {
        QItem insert = null;
        for (Enumeration e = list.forwardElements() ; e.hasMoreElements() ;) {
            QItem qi = (QItem) e.nextElement();
            if (obj.equals(qi.obj)) {
                insert = qi;
                list.remove(qi);
                break;
            }
        }
        if (insert == null)
            insert = new QItem(obj);

        list.unshift(insert);
    } 

    // Least recently pushed Object.
    public final synchronized Object pop() {
        return list.size() > 0 ? ((QItem) list.pop()).obj : null;
    }

    public final int size() {
        return list.size();
    }

    public final synchronized void remove(Object obj) {
        for (Enumeration e = list.forwardElements() ; e.hasMoreElements() ;) {
            QItem qi = (QItem) e.nextElement();
            if (obj.equals(qi.obj)) {
                list.remove(qi);
                break;
            }
        }
    }

    public Enumeration elements() {
        return new ItemEnumeration();
    }

    private class ItemEnumeration implements Enumeration {
        private Enumeration source = list.reverseElements();
       
        public boolean hasMoreElements() {
            return source.hasMoreElements();
        }

        public Object nextElement() {
            return ((QItem) source.nextElement()).obj;
        }
    }

    private static class QItem extends DoublyLinkedListImpl.Item {
        public Object obj;

        public QItem(Object obj) {
            this.obj = obj;
        }
    }
}








