package freenet.support.io;
import java.io.*;

/**
 * This extends BufferedReader with the difference that readLine() results
 * that are only whitespace or start with the comment character are ignored.
 * 
 * @author oskar
 */
public class CommentedBufferedReader extends BufferedReader {

    /**
     * The characters that are considered comments.
     */
    public final String comment;

    /**
     * @param reader   The inputstream to read from.
     * @param comment  The characters that denote comments if they appear at
     *                 the beginning of a line (not counting whitespace);
     */
    public CommentedBufferedReader(Reader in, String comment) {
        super(in);
        this.comment = comment;
    }

    public String readLine() throws IOException {
        String s;
        do {
            s = super.readLine();
        }
        while (s != null && 
               (s.trim().equals("") || 
                comment.indexOf(s.trim().charAt(0)) != -1));
        return s;
    }
}


