package freenet.support.servlet.http;

import java.util.*;


/**
 * Class to keep HttpSessionImpl's.  Note: This interface is specific to
 * HttpSessionImpl's and will not hold HttpSession's.  This is because
 * we seem to be using some methods which are not in the HttpSession interface.
 *
 * @author oskar
 */
public class SessionHolderImpl extends Hashtable implements SessionHolder {
    public HttpSessionImpl getSession(String id) {
	return ((HttpSessionImpl) get(id));
    }

    public void putSession(HttpSessionImpl s) {
	put(s.getId(), s);
    }
}
