package freenet.thread;

/**
 * Executes Runnable jobs using (we hope) an internal pool of threads
 * managed for efficiency.  There should be a nominal limit on the
 * number of active threads, so that a ThreadUnavailableException
 * is thrown if there aren't enough threads to run a job.  The limit
 * may be overridden however.
 * @author tavin
 */
public interface ThreadHandler {

    /**
     * @return  the instantaneous number of available threads
     *          (may be negative if the limit was overridden)
     */
    int availableThreads();

    /**
     * @return  the instantaneous number of currently executing threads
     */
    int activeThreads();

    /**
     * Attempts to start a thread executing the given job.
     * @param job   the job to execute
     * @throws ThreadUnavailableException
     *         if the number of active threads has reached the limit
     */
    void startThread(Runnable job) throws ThreadUnavailableException;

    /**
     * Starts a thread executing the given job.  Ignores the limit.
     * @param job   the job to execute
     */
    void forceThread(Runnable job);
}


