package freenet.transport;
import freenet.*;
import java.net.*;
import java.io.IOException;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

final class tcpListeningAddress extends ListeningAddress {

    private int port;
    private InetAddress bindAddr;
    private int designator = -1;

    private final tcpTransport t;

    tcpListeningAddress(tcpTransport t, int portnum) {
        super(t);
        this.t = t;
        port = portnum;
    }

    tcpListeningAddress(tcpTransport t, InetAddress bindAddr, 
                        int desginator, int portnum) {
        
        this(t, portnum);
        this.bindAddr = bindAddr;
        this.designator = designator; 
    }

    public final Listener getListener() throws ListenException {
        return new tcpListener(t, this, bindAddr, designator);
    }

    public final String getValString() {
        return Integer.toString(port);
    }

    final int getPort() {
        return port;
    }
}


