#!/bin/sh

# determine OS
OS=`uname`
# some OS use bash as sh, f.ex. Linux
# other has a real old Bourne Shell, f.ex SunOS/Solaris
# this is important since they do not behave in the same way
SH_IS_BASH=0
if test $OS != "SunOS"
then
SH_IS_BASH=1
fi
# and get java implementation too, Sun JDK or Kaffe
JAVA_IMPL=`java -version 2>&1 | head -1 | cut -f1 -d' '`

if test ! -f lib/freenet-ext.jar; then
  echo lib/freenet-ext.jar not found.  It can be downloaded from
  echo http://freenetproject.org/snapshots/freenet-ext.jar
  exit
fi

CLASSPATH=lib/freenet.jar:lib/freenet-ext.jar:$CLASSPATH 
export CLASSPATH
# why are we permanently altering the environment?
# because bourne shell needs it!


if test ! -f seednodes.ref; then
  echo seednodes.ref not found, would you like to download some seeds
  
  echo from http://hawk.freenetproject.org/~freenet4/seednodes.ref?
  # wow, different echos on bash and sh
  if test "$SH_IS_BASH" = "1"; then echo -n "[y/N] "; else echo '[y/N]\c';fi
  read resp
  if test "$resp" = "y" -o "$resp" = "Y"; then
    wget http://hawk.freenetproject.org/~freenet4/seednodes.ref
  fi
fi

if test ! -f freenet.conf; then
  echo "No freenet.conf file found.  Running auto-config."
  if test -f scripts/preconfig.sh; then
    ./scripts/preconfig.sh
  else
    ./preconfig.sh
  fi
  java freenet.node.Main --config
  echo "Running Freenet..."
fi

# if Sun JDK set -server option as suggested on mailing list
if java -help | grep "[-]server" >/dev/null ;
then
  JAVA_ARGS="-server"
else
  JAVA_ARGS=""
fi

java $JAVA_ARGS freenet.node.Main $@ &
echo $! > freenet.pid
