#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# Ҵ᤿ե뤿Υ饹
#
package FreePWING::Control;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Reference;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	'handle' => FileHandle->new(),
	'file_name' => '',
	'entry_count' => 0,
	'reference' => FreePWING::Reference->new(),
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name, reference_file_name)
#           file_name
#		Ҵե̾
#           reference_file_name
#		Ⱦե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹Ѥ˽Ҵե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $reference_file_name) = @ARG;

    #
    # Ҵե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
    binmode($self->{'handle'});

    #
    # Ⱦե򳫤
    #
    if (!$self->{'reference'}->open($reference_file_name)) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->{'handle'}->close();
        return 0;
    }

    #
    # Ƭ 16 Х (ҹǿͽΰ 2)  0x00 롣
    #
    if (!$self->{'handle'}->print("\0" x 16)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ҴեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤Ԥ 0 ֤
#
sub close {
    my $self = shift;

    if (!$self->{'handle'}->fileno()) {
	return 1;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length - $self->{'handle'}->tell() % $block_length;
    if ($pad_length < $block_length
	&& !$self->{'handle'}->print("\0" x $pad_length)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }

    #
    # ҹǿ񤭹ࡣ
    #
    if (!$self->{'handle'}->seek(0, FileHandle->SEEK_SET)) {
	$self->{'error_message'} = 
	    "failed to seek the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
    if (!$self->{'handle'}->print(pack('n', $self->{'entry_count'}))) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
	
    #
    # եĤ롣
    #
    $self->close_internal();

    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	¾Υ᥽åɽ˰۾郎νԤ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
    $self->{'reference'}->close_internal();
}

#
# :
#	add_entry(id, parameter, file_name...)
#	    id
#		ҹǤ ID  (: ˥塼ʤ 0x20)
#           parameter
#		ҹǤΥѥ᥿
#           file_name
# 		ե̾
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	Ҵե˥ȥɲä롣κǽ
#	Υե̾Ƭ֤ȥƬɥ쥹ˤʤꡢ
#	եΥιפȥΰ襵ˤʤ롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    my ($id, $parameter, @file_names) = @ARG;
    my $length = 0;

    #
    # $file_name Υ (֥å) 롣
    #
    my $f;
    foreach $f (@file_names) {
	my $size = -s $f;
	if (!defined($size)) {
	    $self->{'error_message'} = "failed to stat the file, $ERRNO: $f";
	    $self->close_internal();
	    return 0;
	}
	$length += ($size + $block_length - 1) / $block_length;
    }

    #
    # ȥ (16 Х) 񤭹ࡣ
    #
    if (!$self->{'handle'}->print(pack('CCNNNn', $id, "\0", 0,
				       $length, $parameter, 0))) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    #
    # Ƭɥ쥹 (ۤɤ pack κǽ 'N' ΰ) ˻Ⱦ
    # 񤭹ࡣ
    #
    my $position = $self->{'handle'}->tell() - 14;
    if (!$self->{'reference'}->add_block_entry($position, 0, $file_names[0])) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }

    $self->{'entry_count'}++;

    return 1;
}

######################################################################
# <ҹǤɲä᥽åɷ>
#
# :
#	᥽å̾(file_name...)
#           file_name
# 		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ҴեνҹǤɲäե̾
#       ȷդ롣
# :
#	 1 ֤Ԥ 0 ֤
#

#
# ʸǡ
#
sub add_text_entry {
    my $self = shift;
    my ($file_name) = @ARG;
    return $self->add_entry(0x00, 0x02000000, $file_name);
}

#
# Ф
#
sub add_heading_entry {
    my $self = shift;
    my ($file_name) = @ARG;
    return $self->add_entry(0x05, 0x02000000, $file_name)
	&& $self->add_entry(0x07, 0x02000000, $file_name);
}

#
# ˥塼ɽѥǡ
#
sub add_menu_entry {
    my $self = shift;
    my ($file_name) = @ARG;
    return $self->add_entry(0x01, 0x02000000, $file_name);
}

#
# ɽǡ
#
sub add_copyright_entry {
    my $self = shift;
    my ($file_name) = @ARG;
    return $self->add_entry(0x02, 0x02000000, $file_name);
}

#
# ץǥå
#
sub add_endindex_entry {
    my $self = shift;
    my (@file_names) = @ARG;
    return $self->add_entry(0x71, 0x02415554, @file_names);
}

#
# ︡ǥå
#
sub add_keyindex_entry {
    my $self = shift;
    my (@file_names) = @ARG;
    return $self->add_entry(0x80, 0x02415554, @file_names);
}

#
# ץǥå
#
sub add_index_entry {
    my $self = shift;
    my (@file_names) = @ARG;
    return $self->add_entry(0x91, 0x02415554, @file_names);
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;

