#ifndef __FWEELIN_MIDIIO_H
#define __FWEELIN_MIDIIO_H

#include <alsa/asoundlib.h>

#include "fweelin_event.h"

class Fweelin;

class MidiIO : public EventProducer, public EventListener {
public:
  MidiIO (Fweelin *app) : bendertune(0), curbender(0), echoport(1), 
    echochan(-1), numins(0), numouts(0),
    app(app), seq_handle(0), in_ports(0), out_ports(0),
    midithreadgo(0) {
    note_port = new int[MAX_MIDI_NOTES];
    note_chan = new int[MAX_MIDI_NOTES];
    memset(note_port,0,sizeof(int) * MAX_MIDI_NOTES);
  };
  virtual ~MidiIO ();

  void ReceiveEvent(Event *ev, EventProducer *from);

  int activate ();
  void close ();

  void SetBenderTune(int tuning) { bendertune = tuning; };
  int GetBenderTune() { return bendertune; };
  void ResetBenderTune() { bendertune = 0; };

  char IsActive () { return midithreadgo; };  

  // Value to offset bender amounts by-- used to do tuning from
  // bender
  int bendertune;
  // Current bender value (before tuning adjustment)
  int curbender;

  // Echo MIDI events out which ALSA MIDI port?
  // (0 is off, port #s ascending from 1 reference out_ports)
  int echoport;
  // Echo out which MIDI channel?
  // (-1 echoes without changing channel information)
  int echochan;

  // Number of MIDI in/out ports
  int numins, numouts;

protected:
  // Core app
  Fweelin *app;

  /* Open ALSA sequencer wit num_in writeable ports and num_out readable ports. */
  /* The sequencer handle and the port IDs are returned.                        */  
  int open_seq(int num_in, int num_out);

  // Midi event handler thread
  static void *run_midi_thread (void *ptr);

  snd_seq_t *seq_handle;
  int *in_ports, *out_ports;

  // For each MIDI note, what port and channel was the note on sent to?
  // This allows us to send note offs to appropriate ports and avoid
  // stuck notes
  int *note_port, *note_chan;

  pthread_t midi_thread;
  char midithreadgo;
};

#endif
