/*
 *  $Id: rk_spclval.h $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/***********************************************************************
                        rk_spclval.h
                                                87.12. 3   

        ѴǻȤäƤüͤʳˤФˡޥ
        ؿ⡢ctype.hȤΰʳϤƤ롣
        rk_macros.h includeƤ롣
***********************************************************************/
/*      Version 3.0
 */
#ifndef EOLTTR

typedef unsigned int letter;    /* ʸϰ̤ˤηɽ */
typedef unsigned char uns_chr;

#define LTRHUG  (~(0xff000000))
        /* ɽ ڤӵʸletterμ */


        /* ʲͤϡǾ̥ХȤ255ǤʤФʤʤ
           Τ˽ФΤ EOLTTRCHMSIGNISEBPLTREOF
           REDRAWʵǥ꡼ȤȤNISEDLȤNISEDLˡ */

#define EOLTTR  ((letter)-1)    /* ʸνüɽ */
                        /* Ϥäɬɤ֤֤ˤ
                           ȡä֤٤ΤʤϤ֤ */
#define ERRCOD  ((letter)-2)    /* (error)ɽ */
#define CHMSIG  ((letter)-3)    /* ⡼ɥ󥸤ɽ */
#define NISEBP  ((letter)-4)    /* 顼ٹѤεBEL */
#define VARRNG  ((letter)-5)    /* Ѱ褬Ĥʸδ֤ǤΤ򼨤 */
#define UNUSDC  ((letter)-6)    /* ޥåԤ뤿 */
#define REASIG  ((letter)-7)    /* ɽκ׵᤹뤿 */
#define URBFCL  ((letter)-8)    /* ΢ХåեŪꥢ׵᤹ */
#define LTREOF  ((letter)-9)    /* romkan_next()Ʊgetc()EOF֤
                                   ʤǤEOFƱˤġ */
#define REDRAW  ((letter)-10)   /* WnnѴԤredraw׵᤹ü쥳 */
#define NISEDL  ((letter)-11)   /* ǥ꡼ȤȤȤͤΤ˽
                                   줿âȤʤлȤʤƤ
                                   ˡѿnisedl˥åȤƻȤ */


        /* romkan_init3()ΰΥե饰˻Ȥ */

#define RK_CHMOUT 01            /* ⡼ɥ󥸤Τ餻륳ɤ֤ */
#define RK_KEYACK 02            /* Фɬ֤ */
#define RK_DSPNIL 04            /* ⡼ɽʸ̵λ˶ʸ֤ʥǥ
                                   ȤNULLˡߴݻΤ */
#define RK_NONISE 010           /* ɤФʤ褦ˤ뤫 */
#define RK_REDRAW 020           /* Wnnüե饰redrawѤΥե饰Фɤ */
#define RK_SIMPLD 040           /* deleteưñˤ뤫 */
#define RK_VERBOS 0100          /* ѤɽΰݡȤ뤫 */


        /* ɤζ̤˻Ȥޥ */

#define HG1BIT  (0x80000000)    /* Ǿ̥ӥåȤ */
#define SHUBET(X) ((letter)(X) >> (int)24)
                              /* ɽǡ壱ХȤɽ˻ȤäƤ */
#define LWRMSK(X) ((X) & ~(0xff000000)) /* 壱ХȤ */
#define LWRCUT(X) ((X) &= ~(0xff000000))        /* 壱ХȤ */

#define is_HON(X) (SHUBET(X) == 0)      /* ʪʸ */
#define NAIBEX(X) (0 < SHUBET(X) && SHUBET(X) < 0x80)   /* ɽ򼨤ͤ */
#define isNISE(X) (SHUBET(X) == 0x80)   /* ʪʸʺǾ̥ӥåȤΩġ */
#define isSPCL(X) (SHUBET(X) == 0xff)   /* rk_spclval.hͤɤ */
 /* NISEDLʤɤޤ᤿ʸǤ뤫ɤȽꤹˤϡ~is_HON(X) 
    isNISE(X) || isSPCL(X) ȤȽꤷʤȤʤ */

#define toNISE(X) ((X) | HG1BIT)
#define to_HON(X) ((X) & ~HG1BIT)

 /* ߴΤѰդƤ̾ */
#define REALCD(X) is_HON(X)
#define NISECD(X) isNISE(X)
#define SPCLCD(X) isSPCL(X)


         /** ȾʸΥɤdefine */

#ifndef HNKAK1
#  ifdef IKIS
#    define HNKAK1 0xA8
#  else
#    define HNKAK1 0x8E
#  endif
#endif

        /** rk_bltinfn.c 䴰ΤΥޥ
            ʰʣɾΤ¿Τա*/

#define HKKBGN  (HNKAK1 * 0x100 + 0xA1) /* Ⱦѥʤζ */
#define HKKEND  (HNKAK1 * 0x100 + 0xDF) /*         Ⱦ */
#define HIRBGN  (0xA4A1)        /*  */
#define HIREND  (0xA4F3) /*  */       /* Ҥ餬ʡ"""" */
#define KATBGN  (0xA5A1)        /*  */
#define KATEND  (0xA5F6) /*  */       /* ʡ"""""" */

#define _to_kata(l) ((l) + (KATBGN - HIRBGN)) /** ʤء¡*/
#define _to_hira(l) ((l) - (KATBGN - HIRBGN)) /** Ҥ餬ʤء¡*/
#define is_hira(l) (HIRBGN <= (l) && (l) <= HIREND) /** Ҥ餬ʤ */
#define is_kata(l) (KATBGN <= (l) && (l) <= KATEND) /** ʤ */
#define is_kata2(l) (_to_kata(HIRBGN) <= (l) && (l) <= _to_kata(HIREND))
                                /** бҤ餬ʤΤ륫ʤ */
#define to_kata(l) (is_hira(l) ? _to_kata(l) : (l)) /** ʤ */
#define to_hira(l) (is_kata2(l) ? _to_hira(l) : (l))
                        /** Ҥ餬ʤء֥פϥʤΤޤ޻Ĥ롣*/
#define is_hankata(l) (HKKBGN <= (l) && (l) <= HKKEND)
                                /** Ⱦѥʡʶʤɤޤˤ */



        /* ¾ΥޥؿʰʣɾΤ¿Τա */

#define numberof(array) (sizeof(array) / sizeof(*array))

 /* ݥ󥿤letterؤäƤletter *lp */
#define totail(lp) {while(*(lp) != EOLTTR) (lp)++;}

 /* ʸؤΥݥ󥿤򤽤ʸκǸءtotailcharǡchar *sp */
#define strtail(sp) {while(*(sp)) (sp)++;}

        /* romkan_init3 */
#define romkan_init4(pathname, delchr, nisedl, keyin, bytecount, flg) \
        romkan_init3(pathname, delchr, nisedl, EOLTTR, \
                     keyin, bytecount, bytecount, 0, flg)

#define romkan_init5(pathname, delchr, keyin, bytecount, flg) \
        romkan_init4(pathname, delchr, toNISE(delchr), keyin, bytecount, flg)


#endif /* of ifndef EOLTTR */
