
/* GNU INDENT - po endif */
int rawio_getc (rawio_t * rawio, int *c) {
  char buf;
  fd_set rfds;
  struct timeval tv;

  tv.tv_sec = rawio->tout_sec;
  tv.tv_usec = rawio->tout_usec;
  FD_ZERO (&rfds);
  FD_SET (rawio->io_fd, &rfds);

  if (select (rawio->io_fd + 1, &rfds, NULL, NULL, &tv))
    {
#ifdef DEBUG
    {
      double t;
      t = (rawio->tout_sec - tv.tv_sec) +
	(0.000001 * (rawio->tout_usec - tv.tv_usec));
      fprintf (stderr, "DEBUG rawio_getc buffer has data, time from "
	       "previous %gs\n", t);
    }
#endif
  if (read (rawio->io_fd, &buf, 1) != 1)
    return 0;           /* unknown error... 'select' said
    there was a byte in the buffer
    but read could not read it */
  *c = buf;
  return 1;                     // success
    }
  return 0;                     // timeout occoured
}