#ifndef CONFIG_H
#define CONFIG_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>

#include <abz/aton.h>
#include <abz/tokens.h>

#include "clients.h"

typedef enum { OTHER, MONITOR, MSTMT } state_t;

struct monitor
{
   char *label;
   char *description;
   struct network *network;
   struct bandwidth input,output;
   size_t n;
   struct monitor *next;
};

struct config
{
   char *chain;
   char *table;
   state_t from;
   struct monitor *head,*tail;
};

/*
 * Initialize parser.
 */
extern void config_create (struct config *config);

/*
 * Clean up.
 */
extern void config_destroy (struct config *config);

/*
 * Parse a command,
 *
 * Return 0 if successful, -1 if some error occurred. Call
 * abz_get_error() to see the error message.
 */
extern int config_parse (struct config *config,const struct tokens *tokens);

/*
 * Symantic analysis.
 *
 * Return 0 if successful, -1 if some error occurred. Call abz_get_error()
 * to see the error message.
 */
extern int config_analyze (struct config *config);

#endif	/* #ifndef CONFIG_H */
