/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BuiltinDialog.cc,v 1.40 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Group.hh"

#include "BuiltinDialog.hh"
#include "main_window.hh"
#include "helpers.hh"

#include "fwbuilder/Policy.hh"
#include "fwbuilder/NAT.hh"

#include "DialogPlugin.hh"
#include "DialogFactory.hh"

#include "FWObjectBook.hh"

#include "PixmapButton.hh"
#include "StockButton.hh"

#include <gtk--.h>

#include <algorithm>
#include <functional>
#include <stack>

using namespace libfwbuilder;

BuiltinDialog::BuiltinDialog(string &id)
{
    set_name("BuiltinDialog");
    glademm_set_Widget("BuiltinDialog", this);
    
    data_changed=false;
    original=FWObjectDatabase::db->getById( id , true);

    assert(original!=NULL);
    
    scratch=FWObjectDatabaseGUI::getInstance()->getScratchCopy(original);
    assert(scratch!=NULL);
    
    *scratch = *original;
    scratch->setDirty(false,true);
    
    dialog_body = DialogFactory::createDialog(scratch);
    assert(dialog_body!=NULL);
    manage(dialog_body);

/*
 * Building navigation bar
 */
    if (Preferences::global_prefs->getOptBool(
	     "/FWBuilderPreferences/UI/HideNavigationBar") ) {
	navbar=NULL;
    } else {
	navbar=manage(new Gtk::Packer());

	navbar_location_lbl=manage(new Gtk::Label("Location: "));
	navbar->add(*navbar_location_lbl, GTK_SIDE_LEFT,GTK_ANCHOR_CENTER,0,0,10 );

	Gtk::Frame *frm=manage(new Gtk::Frame());
	frm->set_usize(300, -1);
	frm->set_shadow_type(GTK_SHADOW_IN);

	navbar_location=manage(new Gtk::Label());
	navbar_location->set_name("navbar_location");
	navbar_location->set_alignment(0.0,0.5);

	frm->add(*navbar_location);
	navbar->add(*frm, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,0,2 );

	navbar_up  =manage(new PixmapButton("UpArrow"));
	navbar_up->set_relief(GTK_RELIEF_NONE);
	navbar_prev=manage(new PixmapButton("LeftArrow"));
	navbar_prev->set_relief(GTK_RELIEF_NONE);
	navbar_next=manage(new PixmapButton("RightArrow"));
	navbar_next->set_relief(GTK_RELIEF_NONE);


	navbar->add(*(manage(new Gtk::Label(""))),   // blank
		    GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,20 );

	navbar->add(*(manage(new Gtk::Label("Navigate:"))), 
		    GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,0 );

	navbar->add(*navbar_up  , GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
	navbar->add(*navbar_prev, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
	navbar->add(*navbar_next, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER,0,0,10 );
	navbar_up->clicked.connect(SigC::slot(this, 
					&BuiltinDialog::on_up_clicked));
	navbar_prev->clicked.connect(SigC::slot(this, 
					&BuiltinDialog::on_prev_clicked));
	navbar_next->clicked.connect(SigC::slot(this, 
					&BuiltinDialog::on_next_clicked));



	add(*navbar,GTK_SIDE_TOP,GTK_ANCHOR_CENTER,GTK_FILL_X);

	Gtk::HSeparator  *sep = manage(new Gtk::HSeparator());
	add(*sep, GTK_SIDE_TOP, GTK_ANCHOR_CENTER,GTK_FILL_X,0,0,4 );

    }
/*
 *  Building dialog body
 */    
    vbox = manage(new Gtk::VBox(false,0));
    add(*vbox,
        GTK_SIDE_TOP,
        GTK_ANCHOR_CENTER,
        GTK_PACK_EXPAND | GTK_FILL_X | GTK_FILL_Y
    );
    vbox->show();

    save_btn    = NULL;
    undo_btn    = NULL;
    separator   = NULL;
    action_area = NULL;
    
    if(dialog_body->needDialogButtons() &&
       Resources::global_res->getObjResourceBool(original,"write") ) 
    {
        
        action_area = manage(new Gtk::HBox(false,5));
        action_area->set_border_width(10);
        action_area->set_usize(-1, 50);
        action_area->set_name("action_area");
        action_area->set_border_width(10);


	save_btn=manage(new StockButton(StockButton::APPLY));
	undo_btn=manage(new StockButton(StockButton::UNDO));
	    
        action_area->pack_end(*undo_btn,false,false,0);
        action_area->pack_end(*save_btn,false,false,0);

        vbox->pack_end(*action_area,false,true,0);

        save_btn->set_sensitive(false);
        undo_btn->set_sensitive(false);

        save_btn->show();
        undo_btn->show();
        action_area->show();

        separator = manage(new Gtk::HSeparator());
        vbox->pack_end(*separator,false,true,0);
        separator->show();

        save_btn->clicked.connect(SigC::slot((BuiltinDialog*)this, 
                                             &BuiltinDialog::on_save_clicked));
      
        undo_btn->clicked.connect(SigC::slot((BuiltinDialog*)this, 
                                             &BuiltinDialog::on_undo_clicked));

    }

    vbox->pack_end( *dialog_body,true,true,0);

    dialog_body->show();
    show_all();

//    dialog_body->wrk2dlg(); 
//    data_changed_flag(false);


    if(undo_btn)
        undo_btn->set_sensitive(false);

    // this should be done after we initialize entry fields
    ConnectSignals();     
    
}

/*
 *   Note:  dialog_body gets destroyed BEFORE this destructor gets called. 
 *          Go figure
 */
BuiltinDialog::~BuiltinDialog()
{
    if (dialog_body!=NULL) {
#ifdef WITH_SCROLLED_WINDOW
	scrolled_win->remove();
#endif

//	delete dialog_body;

#ifdef WITH_SCROLLED_WINDOW
	delete scrolled_win;
#endif
//	if (separator)   delete separator;
//	if (undo_btn)    delete undo_btn;
//	if (save_btn)    delete save_btn;
//	if (action_area) delete action_area;
//	delete vbox;
    }
    glademm_set_Widget("BuiltinDialog", NULL);
}

void  BuiltinDialog::on_next_clicked() 
{
    if(!main_w->safe_to_close_right_pane()) return ;

    FWObject *p=original->getParent();
    if (p) {
	vector<FWObject*>::iterator m=std::find(p->begin(),p->end(),original);
	do { 
	    ++m;
	} while (m!=p->end() && original->getLibrary()!=(*m)->getLibrary());
	if (m!=p->end() && ! Resources::global_res->getObjResourceBool((*m),"hidden"))
		main_w->schedule_open_object( (*m)->getId() );
    }
}

void  BuiltinDialog::on_prev_clicked() 
{
    if(!main_w->safe_to_close_right_pane()) return ;

    FWObject *p=original->getParent();
    if (p) {
	vector<FWObject*>::iterator m=std::find(p->begin(),p->end(),original);
	do { 
	    --m;
	} while (m!=p->begin() && m!=p->end() && original->getLibrary()!=(*m)->getLibrary());
	if (m!=p->begin() && m!=p->end() && ! Resources::global_res->getObjResourceBool((*m),"hidden"))
		main_w->schedule_open_object( (*m)->getId() );
    }
}

void  BuiltinDialog::on_up_clicked() 
{
    if(!main_w->safe_to_close_right_pane()) return ;

    FWObject *p=original->getParent();
    if (p)  main_w->schedule_open_object( p->getId() );
    return;

/* alternative method */
    FWObjectBook *w=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
    if (w!=NULL)  {
	w->showObject( original->getId() );
	main_w->schedule_open_object( w->getParentId() );
    }
}


void BuiltinDialog::set_policy(gint allow_shrink, 
			       gint allow_grow, 
			       gint auto_shrink){}

void BuiltinDialog::set_position(GtkWindowPosition position){}

void BuiltinDialog::set_title(const Gtk::nstring& title){}


  
void BuiltinDialog::dialog_set_changed_callback_helper(Gtk::Widget *wp)
{
  Gtk::Editable     *ed;
  Gtk::ToggleButton *tb;

  if (wp==NULL) return;

  if ( Gtk::Editable::isA(wp) ) {
      ed=(Gtk::Editable*)(wp);
      ed->changed.connect(SigC::slot((BuiltinDialog*)this, 
				     &BuiltinDialog::OnDataChanged));
      return;
  }
  if (Gtk::ToggleButton::isA(wp)) {
      tb=(Gtk::ToggleButton*)(wp);
      tb->toggled.connect(SigC::slot((BuiltinDialog*)this, 
				     &BuiltinDialog::OnDataChanged));
      return;
  }
  if (Gtk::Combo::isA(wp)) {
      ((Gtk::Combo*)wp)->get_entry()->changed.connect(
	  SigC::slot((BuiltinDialog*)this, 
		     &BuiltinDialog::OnDataChanged));
      return;
  }
  if ( Gtk::Box::isA(wp) || Gtk::Fixed::isA(wp) ) {
    Gtk::Box      *bptr=(Gtk::Box*)wp;
    Gtk::Box_Helpers::BoxList   bl= bptr->children();
    Gtk::Box_Helpers::BoxList::iterator bl_i;
    Gtk::Box_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      dialog_set_changed_callback_helper( ch->get_widget() );
    }
  }
  if ( Gtk::Packer::isA(wp) ) {
    Gtk::Packer      *bptr=(Gtk::Packer*)wp;
    Gtk::Packer_Helpers::PackerList   bl= bptr->children();
    Gtk::Packer_Helpers::PackerList::iterator bl_i;
    Gtk::Packer_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      dialog_set_changed_callback_helper( ch->get_widget() );
    }
  }
  if ( Gtk::Notebook::isA(wp) ) {
    for (int i=0; i<20; ++i)
      dialog_set_changed_callback_helper
	(((Gtk::Notebook*)wp)->get_nth_page(i) );
    return;
  }
  if ( Gtk::Bin::isA(wp) ) {
    dialog_set_changed_callback_helper( ((Gtk::Bin*)wp)->get_child() );
    return;
  }

/*
 *   TODO:
 *
 *   This is broken in gtk-- 1.2.3  Since this is what is shipped with
 *   RedHat 6.2, we will provide workarounds until we either completely
 *   switch to RedHat 7.0 (for which gtk-- 1.2.5 is available as rpms) or
 *   newer version of gtk-- will be available as rpm for RH 6.2
 *
 *   As a workaround we are going to have to attach "on_changed" callback
 *   to dialog elements which are positioned inside tables, or we won't use
 *   tables where possible
 *

  if ( Gtk::Table::isA(wp) ) {
      Gtk::Table_Helpers::TableList lst= ((Gtk::Table*)wp)->children();
      Gtk::Table_Helpers::TableList::iterator m;
      for (m=lst.begin(); m!=lst.end(); m++) {
	  if ( (*m)==NULL ) continue;
	  Gtk::Widget *w = (*m);
	  dialog_set_changed_callback_helper(w);
      }
  }
*/
}


void BuiltinDialog::ConnectSignals()
{
   dialog_set_changed_callback_helper( dialog_body );
}

void BuiltinDialog::data_changed_flag(bool f)
{
    if (save_btn!=NULL) {

	save_btn->set_sensitive(f);
	undo_btn->set_sensitive(f);

	data_changed=f;

/*
	Gdk_Color    btn_color;
	btn_color.parse((f)?"red":"black");
	
	Gtk::Style       *btn_style;

	btn_style= save_btn->get_child()->get_style () -> copy ();
	btn_style->set_fg( GTK_STATE_NORMAL      , btn_color );
	save_btn->get_child()->set_style( *btn_style );
	btn_style->unref();
	save_btn->show();
*/
    }
}

/*
 * fill location in navbar
 */
void  BuiltinDialog::fill_navbar_location()
{
    if (navbar!=NULL) {
	string loc("");
	FWObject *o=original;
	while(o!=NULL && o->getParent()!=NULL){//stop one step shy of the tree root
	    string nm=o->getName();
	    if (nm.empty())  nm=o->getTypeName();
	    if (loc.empty()) loc=nm;
	    else             loc=nm+"/"+loc;
	    o=o->getParent();
	};
	if (main_w->getCurrentLibrary()!="")  
	    loc="/"+main_w->getCurrentLibrary()+"/"+loc;
	else
	    loc="/User/"+loc;
	
	navbar_location->set_text(loc);

	navbar_up->set_sensitive(
	    ( original->getId()!=FWObjectDatabase::db->std.rootId )  );
    }
}

void BuiltinDialog::LoadData()
{
    dialog_body->wrk2dlg(); 
    data_changed_flag(false);
    /*
     * If name is empty, this is brand new object
     */
    if(original->getTypeName()!=Policy::TYPENAME &&
       original->getTypeName()!=NAT::TYPENAME ) 
    {
        if (original->getName()=="") 
            data_changed_flag(true);
    }
    scratch->setDirty(false,true);
    
    fill_navbar_location();
}

void BuiltinDialog::SaveData()
{
    if (data_changed && dialog_body!=NULL && dialog_body->dlg2wrk() ) {

	*original = *scratch;

	data_changed_flag(false);

	FWObjectBook *w=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
	if (w!=NULL) {
	    w->showObject( original->getId() );
	    w->changeTreeLabel( original->getId());
	}
	fill_navbar_location();

	scratch->setDirty(false,true);
    }
}

void BuiltinDialog::UndoChanges()
{
    if (dialog_body!=NULL) {
	if (data_changed) {
	    *scratch = *original;
	    LoadData();
	    if (original->getTypeName()!=Policy::TYPENAME &&
		original->getTypeName()!=NAT::TYPENAME ) {
		if (original->getName()=="")  data_changed_flag(true);
	    }
	}
    }
}


void BuiltinDialog::OnDataChanged()
{
    data_changed_flag(true);
}

gint BuiltinDialog::on_focus_out_event(GdkEventFocus *ev)
{
  return(0);
}

void BuiltinDialog::OnHide()
{
}

void  BuiltinDialog::on_save_clicked()
{
  SaveData();
}

void  BuiltinDialog::on_undo_clicked()
{
  UndoChanges();
}

