/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CustomServiceDialog.cc,v 1.6 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/CustomService.hh"
#include "CustomServiceDialog.hh"

#include "Resources.hh"

#include "helpers.hh"

using namespace libfwbuilder;

CustomServiceDialog::CustomServiceDialog(libfwbuilder::FWObject *obj) 
{ 
    object=obj;


    platforms=Resources::global_res->getPlatforms();
    platforms.insert( platforms.begin() , "Undefined" );
}

/**
 *   this callback is called when user changes firewall platform
 */
void CustomServiceDialog::on_platform_changed()
{

    const string *new_platform=
	(const string*)(platform->get_menu()->get_active()->get_user_data());
    assert(new_platform!=NULL);

    code->set_text( codes[*new_platform] );
}

void CustomServiceDialog::on_code_changed()
{
    const string *cur_platform=
	(const string*)(platform->get_menu()->get_active()->get_user_data());
    assert(cur_platform!=NULL);

    codes[ *cur_platform ] = code->get_text();

    
    on_changed();
}

void CustomServiceDialog::wrk2dlg()
{
    CustomService *cs=CustomService::cast(object);

    name->set_text(object->getName());

    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    vector<string>::iterator i;
    string   active_item;
    for (i=platforms.begin(); i!=platforms.end(); ++i) {
	codes[ (*i) ] = cs->getCodeForPlatform( (*i) );
	if ( ! cs->getCodeForPlatform( (*i) ).empty() )
	    active_item= (*i);
    }

    platform->remove_menu();
    platform->set_menu( createOptionsMenu(platforms,active_item,
		  SigC::slot(this,&CustomServiceDialog::on_platform_changed)));
    platform->show();

    code->set_text( codes[active_item] );

    name->grab_focus();
}

bool CustomServiceDialog::dlg2wrk()
{
    CustomService *cs=CustomService::cast(object);

/*
 *  check if name is valid
 */
    if ( ! checkObjectName(name->get_text()) ) return(false);


    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    vector<string>::iterator i;
    for (i=platforms.begin(); i!=platforms.end(); ++i) 
	cs->setCodeForPlatform( (*i) , codes[(*i)] );


    return(true);
}

void CustomServiceDialog::on_changed()
{
  data_changed_flag(true);
}


