/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Druid.hh,v 1.2 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _DRUID_HH
#define _DRUID_HH

#include "config.h"

#include <gtk--.h>
#include "gtk--/packer.h"

#include <map>

class Druid : public Gtk::Window
{
    string logo;
    string title;

    class Gtk::Label    *druid_title;
    class Gtk::Pixmap   *druid_pixmap;
    class Gtk::Packer   *packer1;
    class Gtk::Notebook *nbook;
    class Gtk::HBox     *hbox1;
    class Gtk::VBox     *vbox1;

    class Gtk::Button   *back;
    class Gtk::Button   *next;
    class Gtk::Button   *cancel;
    class Gtk::Button   *finish;

    map<int,Gtk::Widget*> druid_pages;
    int                   current_page;
    int                   start_page_id;
    int                   finish_page_id;

    void on_back_clicked();
    void on_next_clicked();
    void on_cancel_clicked();
    void on_finish_clicked();


    public:

    Druid(const string& title, const string& logo);

    int          getPageID(Gtk::Widget* pid);
    void         setPage(int page_id);

    void         createStartPage(   int page_id,const char* text);
    Gtk::VBox*   createStandardPage(int page_id);
    void         createStandardPage(int page_id,Gtk::Widget *page);
    void         createFinishPage(  int page_id,const char* text);

    void         set_buttons_sensitive(bool back,bool next,bool cancel);

    int          get_current_page_id() { return current_page; }

    virtual void     on_prepare();
    virtual gboolean on_next()    =0;
    virtual gboolean on_back()    =0;
    virtual gboolean on_cancel()  =0;
    virtual void     on_finish();


};

#endif
