/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: GenericBackgroundOpDialog.cc,v 1.2 2001/09/22 01:39:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "GenericBackgroundOpDialog.hh"

using namespace libfwbuilder;

GenericBackgroundOpDialog::GenericBackgroundOpDialog( BackgroundOp *b )
{
    bo=b;
    brd=manage(new BackgroundOpWidget(b,true));
    add(*brd);

    set_usize(400,250);
    set_position(GTK_WIN_POS_CENTER);
    set_policy(true, true, false);

    delete_event.connect( SigC::slot(this,&GenericBackgroundOpDialog::on_delete_event));

    show_all();
}

GenericBackgroundOpDialog::~GenericBackgroundOpDialog() {}

gint GenericBackgroundOpDialog::on_delete_event(GdkEventAny* ev)
{
    brd->stop();
    return 0;
}

int GenericBackgroundOpDialog::execute()
{
    try
    {
        brd->execute();

	Gtk::Main::grab_add(*this);
	Gtk::Main::run();
	Gtk::Main::grab_remove(*this);

        return 0;
    } catch(const FWException &ex)
    {
        return -1; //TODO: more meaningful number
    }
}







