/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceListWidget.cc,v 1.2 2001/12/07 00:17:51 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "InterfaceListWidget.hh"

#define COL_NAME     0
#define COL_ADDR     1
#define COL_NETMASK  2
#define COL_EXT      3
#define COL_DYN      4
#define COL_MAC      5
#define COL_LABEL    6

using namespace libfwbuilder;


InterfaceListWidget::InterfaceListWidget() : CList(7)
{
    show_addr= show_name= show_netmask= show_ext= show_dyn= show_mac= show_label=true;

    show_security_level=false;

    column(COL_NAME    ).set_title("Name");
    column(COL_ADDR    ).set_title("Address");
    column(COL_NETMASK ).set_title("Netmask");
    column(COL_EXT     ).set_title("Ext");
    column(COL_DYN     ).set_title("Dyn");
    column(COL_MAC     ).set_title("MAC");
    column(COL_LABEL   ).set_title("Label");

    column(COL_NAME    ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_ADDR    ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_NETMASK ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_EXT     ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_DYN     ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_MAC     ).set_justification(GTK_JUSTIFY_LEFT);
    column(COL_LABEL   ).set_justification(GTK_JUSTIFY_LEFT);


    column(COL_NAME    ).set_min_width(80 );
    column(COL_ADDR    ).set_min_width(60 );
    column(COL_NETMASK ).set_min_width(60 );
    column(COL_EXT     ).set_min_width(20 );
    column(COL_DYN     ).set_min_width(20 );
    column(COL_MAC     ).set_min_width(60 );
    column(COL_LABEL   ).set_min_width(80 );


    column(COL_NAME    ).set_auto_resize(true);
    column(COL_ADDR    ).set_auto_resize(true);
    column(COL_NETMASK ).set_auto_resize(true);
    column(COL_EXT     ).set_auto_resize(true);
    column(COL_DYN     ).set_auto_resize(true);
    column(COL_MAC     ).set_auto_resize(true);
    column(COL_LABEL   ).set_auto_resize(true);


/*
    set_column_width(COL_NAME   , 80  );
    set_column_width(COL_ADDR   , 100 );
    set_column_width(COL_NETMASK, 100 );
    set_column_width(COL_EXT    , 20  );
    set_column_width(COL_DYN    , 20  );
    set_column_width(COL_MAC    , 100 );
    set_column_width(COL_LABEL  , 80  );
*/


    set_selection_mode(GTK_SELECTION_BROWSE);
    column_titles_show();


}

/*
 *   in gtkmm 1.2.5 it is "set_visiblity", not "set_visibility"
 */    
void InterfaceListWidget::set_show_name(bool onoff)    { show_name=onoff;    column(COL_NAME    ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_address(bool onoff) { show_addr=onoff;    column(COL_ADDR    ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_netmask(bool onoff) { show_netmask=onoff; column(COL_NETMASK ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_ext(bool onoff)     { show_ext=onoff;     column(COL_EXT     ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_dyn(bool onoff)     { show_dyn=onoff;     column(COL_DYN     ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_mac(bool onoff)     { show_mac=onoff;     column(COL_MAC     ).set_visiblity(onoff); }
void InterfaceListWidget::set_show_label(bool onoff)   { show_label=onoff;   column(COL_LABEL   ).set_visiblity(onoff); }

void InterfaceListWidget::set_show_security_level(bool onoff)
{
    show_security_level=onoff;
    if (show_security_level)
	column(COL_EXT     ).set_title("SecurityLvl");
    else
	column(COL_EXT     ).set_title("Ext");
}


void InterfaceListWidget::addInterface(libfwbuilder::Interface *iface)
{
    char *crow[7]={"","","","","","",""};
            
    rows().push_back( (const char**)crow );

    gint row=rows().size()-1;

    cell(row,COL_NAME   ).set_spacing(6);    
    cell(row,COL_NAME   ).set_text( iface->getName() );

    cell(row,COL_ADDR   ).set_spacing(6);    
    cell(row,COL_ADDR   ).set_text( iface->getStr("address"));

    cell(row,COL_NETMASK).set_spacing(6);    
    cell(row,COL_NETMASK).set_text( iface->getStr("netmask"));

    cell(row,COL_EXT    ).set_spacing(6);    
    if (show_security_level) {
	char str[80];
	sprintf(str,"%d",iface->getSecurityLevel() );
	cell(row,COL_EXT    ).set_text( str );

    } else
	cell(row,COL_EXT    ).set_text( ( iface->isExt())?"ext":"");

    cell(row,COL_DYN    ).set_spacing(6);    
    cell(row,COL_DYN    ).set_text( ( iface->isDyn())?"dyn":"");

    cell(row,COL_MAC    ).set_spacing(6);    
    cell(row,COL_MAC    ).set_text( iface->getPhysicalAddress() );

    cell(row,COL_LABEL  ).set_spacing(6);    
    cell(row,COL_LABEL  ).set_text( iface->getLabel() );

    // We return pointer to actuall string residing
    // within Interface object holding it's ID.
    // If interface object is deleted, this string will
    // become invalid.
    // We assume here that this would not happen, while
    // this dialogue is running.
    // (lord)
    rows()[row].set_data( (void*)&(iface->getId()) );
    

}

void   InterfaceListWidget::clear()
{
    rows().clear();
}

string InterfaceListWidget::getIdByRow(int row)
{
    const string* id = (const string*)(get_row_data(row));
    return (id!=NULL) ? *id : "";
}


string InterfaceListWidget::getSelectedInterfaceId()
{
    if (rows().empty()) return "";

    Gtk::CList_Helpers::SelectionList sl = selection();
    if (sl.empty()) return NULL;

    Gtk::CList_Helpers::Row row = sl.front();
    int   rn = row.get_row_num();

    return getIdByRow(rn);
}

