/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: HostDialog.cpp,v 1.15 2004/06/17 06:37:00 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "HostDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Host.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/FWException.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

using namespace std;
using namespace libfwbuilder;

void HostDialog::loadFWObject(FWObject *o)
{
    obj=o;
    Host *s = dynamic_cast<Host*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    Management *mgmt=s->getManagementObject();
    assert(mgmt!=NULL);

    FWOptions  *opt =s->getOptionsObject();

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    snmpCommunity->setText( mgmt->getSNMPManagement()->getReadCommunity().c_str() );
    MACmatching->setChecked( opt->getBool("use_mac_addr_filter") );

    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    snmpCommunity->setEnabled(!o->isReadOnly());
    setDisabledPalette(snmpCommunity);

    MACmatching->setEnabled(!o->isReadOnly());
    setDisabledPalette(MACmatching);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void HostDialog::changed()
{
    apply->setEnabled( true );
}

void HostDialog::validate(bool *res)
{
    *res=true;
}

void HostDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void HostDialog::libChanged()
{
    changed();
}

void HostDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    Host *s = dynamic_cast<Host*>(obj);
    assert(s!=NULL);

    Management *mgmt=s->getManagementObject();
    assert(mgmt!=NULL);

    FWOptions  *opt =s->getOptionsObject();

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );
    mgmt->getSNMPManagement()->setReadCommunity( snmpCommunity->text().latin1() );
    opt->setBool("use_mac_addr_filter", MACmatching->isChecked() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) &&
	libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    apply->setEnabled( false );
}

void HostDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void HostDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

