/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: pixAdvancedDialog.cpp,v 1.18.4.1 2005/09/13 04:55:41 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "global.h"
#include "utils.h"

#include "pixAdvancedDialog.h"
#include "SimpleTextEditor.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"
#include "fwbuilder/Interface.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>
#include <qtextview.h>
#include <qtabwidget.h>
#include <qlistbox.h>
#include <qlabel.h>

#include <iostream>
#include <sstream>

using namespace std;
using namespace libfwbuilder;


pixAdvancedDialog::pixAdvancedDialog(QWidget *parent,FWObject *o)
    : pixAdvancedDialog_q(parent)
{
    obj=o;

    string vers="version_"+obj->getStr("version");
    string platform = obj->getStr("platform");   // could be 'pix' or 'fwsm'

    QString      s;
    QStringList  logLevels;
    QStringList  logLevelMapping;
    logLevelMapping.push_back("");
    logLevelMapping.push_back("");

/* filling pop-down menu and pushing the same strings to the mapping
 * list at the same time so we could use translation
 */
    s=QObject::tr("0 - System Unusable");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("0");

    s=QObject::tr("1 - Take Immediate Action");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("1");

    s=QObject::tr("2 - Critical Condition");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("2");

    s=QObject::tr("3 - Error Message");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("3"); 

    s=QObject::tr("4 - Warning Message");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("4"); 

    s=QObject::tr("5 - Normal but significant condition");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("5"); 

    s=QObject::tr("6 - Informational");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("6"); 

    s=QObject::tr("7 - Debug Message");
    logLevels.push_back(s);
    logLevelMapping.push_back(s);
    logLevelMapping.push_back("7"); 

/* do not need to translate syslog facilities, but will use the same
 * method just in case */

    QStringList syslogFacilities;
    QStringList syslogFacilityMapping;
    syslogFacilities.push_back("");
    syslogFacilityMapping.push_back("");
    syslogFacilityMapping.push_back("");

    syslogFacilities.push_back("LOCAL0");
    syslogFacilityMapping.push_back("LOCAL0");
    syslogFacilityMapping.push_back("16");

    syslogFacilities.push_back("LOCAL1");
    syslogFacilityMapping.push_back("LOCAL1");
    syslogFacilityMapping.push_back("17");

    syslogFacilities.push_back("LOCAL2");
    syslogFacilityMapping.push_back("LOCAL2");
    syslogFacilityMapping.push_back("18");

    syslogFacilities.push_back("LOCAL3");
    syslogFacilityMapping.push_back("LOCAL3");
    syslogFacilityMapping.push_back("19");

    syslogFacilities.push_back("LOCAL4");
    syslogFacilityMapping.push_back("LOCAL4");
    syslogFacilityMapping.push_back("20");

    syslogFacilities.push_back("LOCAL5");
    syslogFacilityMapping.push_back("LOCAL5");
    syslogFacilityMapping.push_back("21");

    syslogFacilities.push_back("LOCAL6");
    syslogFacilityMapping.push_back("LOCAL6");
    syslogFacilityMapping.push_back("22");

    syslogFacilities.push_back("LOCAL7");
    syslogFacilityMapping.push_back("LOCAL7");
    syslogFacilityMapping.push_back("23");



    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    bool f1=fwoptions->getBool("pix_acl_basic");
    bool f2=fwoptions->getBool("pix_acl_no_clear");
    bool f3=fwoptions->getBool("pix_acl_substitution");
    bool f4=fwoptions->getBool("pix_add_clear_statements");

    /*
     * If none of the new pix_acl_* options is set and old pix_add_clear_statements
     * option is true, set pix_acl_basic to true.
     * 
     * If old option pix_add_clear_statements iss false, set
     * pix_acl_no_clear to true
     */
    if (!f1 && !f2 && !f3)
    {
        if ( f4 ) fwoptions->setBool("pix_acl_basic",true);
        else fwoptions->setBool("pix_acl_no_clear",true);
    }

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

/* Page "Compiler Options" */
    data.registerOption( outputFileName       , fwoptions,
                         "output_file"  );

    data.registerOption( pix_assume_fw_part_of_any  , fwoptions,  
                         "pix_assume_fw_part_of_any" );

    data.registerOption( pix_replace_natted_objects  , fwoptions,  
                         "pix_replace_natted_objects" );

    data.registerOption( pix_emulate_out_acl  , fwoptions,  
                         "pix_emulate_out_acl" );


    data.registerOption( pix_acl_basic , fwoptions,  
                         "pix_acl_basic" );

/*
    data.registerOption( pix_acl_alwaysNew , fwoptions,  
                         "pix_acl_always_new" );
*/

    data.registerOption( pix_acl_no_clear , fwoptions,  
                         "pix_acl_no_clear" );

    data.registerOption( pix_acl_substitution , fwoptions,  
                         "pix_acl_substitution" );

    data.registerOption( pix_acl_temp_addr , fwoptions,  
                         "pix_acl_temp_addr" );


    data.registerOption( pix_include_comments , fwoptions,  
                         "pix_include_comments" );

    data.registerOption( pix_use_acl_remarks , fwoptions,  
                         "pix_use_acl_remarks" );

    data.registerOption( pix_regroup_commands , fwoptions,  
                         "pix_regroup_commands" );

    data.registerOption( pix_use_manual_commit , fwoptions,  
                         "pix_use_manual_commit" );

    pix_use_manual_commit->setEnabled(platform=="fwsm");
/*
    data.registerOption( pix_add_clear_statements , fwoptions,  
                         "pix_add_clear_statements" );
*/

    data.registerOption( pix_optimize_default_nat , fwoptions,  
                         "pix_optimize_default_nat" );

    data.registerOption( pix_check_shadowing    , fwoptions,  
                         "check_shading"  );

    data.registerOption( pix_ignore_empty_groups , fwoptions,  
                         "ignore_empty_groups" );


    data.registerOption( pix_check_duplicate_nat    , fwoptions,  
                         "pix_check_duplicate_nat"  );

    data.registerOption( pix_check_overlapping_global_pools , fwoptions,  
                         "pix_check_overlapping_global_pools" );

    data.registerOption( pix_check_overlapping_statics , fwoptions,  
                         "pix_check_overlapping_statics" );

    data.registerOption( pix_check_overlapping_global_statics , fwoptions,  
                         "pix_check_overlapping_global_statics" );

    data.registerOption( mgmt_ssh     , fwoptions,  "mgmt_ssh"  );
    data.registerOption( mgmt_addr    , fwoptions,  "mgmt_addr" );

/* page Installer */

    data.registerOption( user             ,fwoptions, "admUser"         );
    data.registerOption( altAddress       ,fwoptions, "altAddress"      );
    data.registerOption( sshArgs          ,fwoptions, "sshArgs"         );

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );


/* page "Prolog/Epilog" */
    data.registerOption( pix_prolog_script    , fwoptions,  
                         "pix_prolog_script"  );

    data.registerOption( pix_epilog_script    , fwoptions,  
                         "pix_epilog_script"  );

/* page "Timeouts" */
    data.registerOption( xlate_hh       , fwoptions, "xlate_hh"      );
    data.registerOption( xlate_mm       , fwoptions, "xlate_mm"      );
    data.registerOption( xlate_ss       , fwoptions, "xlate_ss"      );

    data.registerOption( conn_hh        , fwoptions, "conn_hh"       );
    data.registerOption( conn_mm        , fwoptions, "conn_mm"       );
    data.registerOption( conn_ss        , fwoptions, "conn_ss"       );

    data.registerOption( udp_hh         , fwoptions, "udp_hh"        );
    data.registerOption( udp_mm         , fwoptions, "udp_mm"        );
    data.registerOption( udp_ss         , fwoptions, "udp_ss"        );

    data.registerOption( rpc_hh         , fwoptions, "rpc_hh"        );
    data.registerOption( rpc_mm         , fwoptions, "rpc_mm"        );
    data.registerOption( rpc_ss         , fwoptions, "rpc_ss"        );

    data.registerOption( h323_hh        , fwoptions, "h323_hh"       );
    data.registerOption( h323_mm        , fwoptions, "h323_mm"       );
    data.registerOption( h323_ss        , fwoptions, "h323_ss"       );

    data.registerOption( sip_hh         , fwoptions, "sip_hh"        );
    data.registerOption( sip_mm         , fwoptions, "sip_mm"        );
    data.registerOption( sip_ss         , fwoptions, "sip_ss"        );

    data.registerOption( sip_media_hh   , fwoptions, "sip_media_hh"  );
    data.registerOption( sip_media_mm   , fwoptions, "sip_media_mm"  );
    data.registerOption( sip_media_ss   , fwoptions, "sip_media_ss"  );
                                                                  
    data.registerOption( half_closed_hh , fwoptions, "half-closed_hh");
    data.registerOption( half_closed_mm , fwoptions, "half-closed_mm");
    data.registerOption( half_closed_ss , fwoptions, "half-closed_ss");

    data.registerOption( uauth_hh       , fwoptions, "uauth_hh"      );
    data.registerOption( uauth_mm       , fwoptions, "uauth_mm"      );
    data.registerOption( uauth_ss       , fwoptions, "uauth_ss"      );
    data.registerOption( uauth_abs      , fwoptions, "uauth_abs"     );
    data.registerOption( uauth_inact    , fwoptions, "uauth_inact"   );

    data.registerOption( telnet_timeout , fwoptions, "pix_telnet_timeout");
    data.registerOption( ssh_timeout    , fwoptions, "pix_ssh_timeout"   );

/* page Fixups */

    allFixups.push_back(fixupControl( pix_ctiqbe_switch,   pix_ctiqbe_port,       NULL,               NULL,             "ctiqbe_fixup"    , "ctiqbe"    , 0));
    allFixups.push_back(fixupControl( pix_dns_switch,      pix_dns_max_length,    NULL,               NULL,             "dns_fixup"       , "dns"       , 1));
    allFixups.push_back(fixupControl( pix_espike_switch,   NULL,                  NULL,               NULL,             "espike_fixup"    , "esp-ike"   , 2));
    allFixups.push_back(fixupControl( pix_ftp_switch,      pix_ftp_port,          NULL,               pix_ftp_strict,   "ftp_fixup"       , "ftp"       , 3));
    allFixups.push_back(fixupControl( pix_h323h225_switch, pix_h323h225_port1,    pix_h323h225_port2, NULL,             "h323_h225_fixup" , "h323 h225" , 4));
    allFixups.push_back(fixupControl( pix_h323ras_switch,  pix_h323ras_port1,     pix_h323ras_port2,  NULL,             "h323_ras_fixup"  , "h323 ras"  , 5));
    allFixups.push_back(fixupControl( pix_http_switch,     pix_http_port1,        pix_http_port2,     NULL,             "http_fixup"      , "http"      , 6));
    allFixups.push_back(fixupControl( pix_icmperror_switch, NULL,                 NULL,               NULL,             "icmp_error_fixup", "icmp error", 7));
    allFixups.push_back(fixupControl( pix_ils_switch,      pix_ils_port1,         pix_ils_port2,      NULL,             "ils_fixup"       , "ils"       , 8));
    allFixups.push_back(fixupControl( pix_mgcp_switch,     pix_mgcp_gateway_port, pix_mgcp_call_agent_port, NULL,       "mgcp_fixup"      , "mgcp"      , 9));
    allFixups.push_back(fixupControl( pix_pptp_switch,     pix_pptp_port,         NULL,               NULL,             "pptp_fixup"      , "pptp"      , 10));
    allFixups.push_back(fixupControl( pix_rsh_switch,      pix_rsh_port1,         NULL,               NULL,             "rsh_fixup"       , "rsh"       , 11));
    allFixups.push_back(fixupControl( pix_rtsp_switch,     pix_rtsp_port,         NULL,               NULL,             "rtsp_fixup"      , "rtsp"      , 12));
    allFixups.push_back(fixupControl( pix_sip_switch,      pix_sip_port1,         pix_sip_port2,      NULL,             "sip_fixup"       , "sip"       , 13));
    allFixups.push_back(fixupControl( pix_sipudp_switch,   pix_sip_udp_port1,     NULL,               NULL,             "sip_udp_fixup"   , "sip udp"   , 14));
    allFixups.push_back(fixupControl( pix_skinny_switch,   pix_skinny_port1,      pix_skinny_port2,   NULL,             "skinny_fixup"    , "skinny"    , 15));
    allFixups.push_back(fixupControl( pix_smtp_switch,     pix_smtp_port1,        pix_smtp_port2,     NULL,             "smtp_fixup"      , "smtp"      , 16));
    allFixups.push_back(fixupControl( pix_sqlnet_switch,   pix_sqlnet_port1,      pix_sqlnet_port2,   NULL,             "sqlnet_fixup"    , "sqlnet"    , 17));
    allFixups.push_back(fixupControl( pix_tftp_switch,     pix_tftp_port,         NULL,               NULL,             "tftp_fixup"      , "tftp"      , 18));

    string lst=Resources::platform_res[platform]->getResourceStr(
            "/FWBuilderResources/Target/options/"+vers+"/fixups/list");

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (fi->switch_widget!=NULL) connect( fi->switch_widget, SIGNAL(activated(int)),
                                              this, SLOT(fixupCmdChanged()) );

        if (fi->arg1!=NULL) connect( fi->arg1, SIGNAL(valueChanged(int)),
                                     this, SLOT(fixupCmdChanged()) );

        if (fi->arg2!=NULL) connect( fi->arg2, SIGNAL(valueChanged(int)),
                                     this, SLOT(fixupCmdChanged()) );

        if (fi->arg3!=NULL) connect( fi->arg3, SIGNAL(clicked()),
                                     this, SLOT(fixupCmdChanged()) );

        string::size_type i,j;
        i=0;
        bool present=false;
        while ( i<lst.size() )
        {
            j=lst.find(",",i);
            if (lst.substr(i,j-i)==fi->fwoption.latin1()) { present=true; break; }
            if (j==string::npos) break;
            i=j+1;
        }
        if (!present)
        {
            fi->active=false;
            fixup_notebook->setTabEnabled( fixup_notebook->page( fi->page ), false );
        }
    }

/* page Logging */

    emblem_log_format->setEnabled(
        Resources::platform_res[platform]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_emblem_log_format") );


    syslogDeviceIdSupported= (Resources::platform_res[platform]->getResourceBool(
                  "/FWBuilderResources/Target/options/"+vers+"/pix_syslog_device_id_supported") );

    syslog_device_id_hostname->setEnabled(syslogDeviceIdSupported);
    syslog_device_id_interface->setEnabled(syslogDeviceIdSupported);
    syslog_device_id_interface_val->setEnabled(syslogDeviceIdSupported);
    syslog_device_id_string->setEnabled(syslogDeviceIdSupported);
    syslog_device_id_string_val->setEnabled(syslogDeviceIdSupported);


    data.registerOption( syslog_host,          fwoptions,    "pix_syslog_host");
    data.registerOption( syslog_queue_size,    fwoptions,    "pix_syslog_queue_size" );

    syslog_facility->clear();
    syslog_facility->insertStringList( syslogFacilities );
    data.registerOption( syslog_facility,      fwoptions,
                         "pix_syslog_facility", syslogFacilityMapping);

    logging_trap_level->clear();
    logging_trap_level->insertStringList(logLevels);

    data.registerOption( logging_trap_level,   fwoptions,
                         "pix_logging_trap_level", logLevelMapping);


    data.registerOption( emblem_log_format,    fwoptions,    "pix_emblem_log_format");



    QStringList interfaces;
    list<FWObject*> l2=obj->getByType(Interface::TYPENAME);
    for (list<FWObject*>::iterator i=l2.begin(); i!=l2.end(); ++i) 
        interfaces.push_back( (Interface::cast(*i))->getLabel().c_str() );

    syslog_device_id_interface_val->insertStringList(interfaces);

    if (syslogDeviceIdSupported)
    {
        string s=fwoptions->getStr("pix_syslog_device_id_opt");
        string v=fwoptions->getStr("pix_syslog_device_id_val");
        if (s=="hostname")  syslog_device_id_hostname->setChecked(true);
        if (s=="interface")
        {
            syslog_device_id_interface->setChecked(true);
            QListBox *lb = syslog_device_id_interface_val->listBox();
            syslog_device_id_interface_val->setCurrentItem(
                lb->index(lb->findItem(v.c_str())) );
        }
        if (s=="string")
        {
            syslog_device_id_string->setChecked(true);
            syslog_device_id_string_val->setText(v.c_str());
        }
    }

    data.registerOption( logging_timestamp,    fwoptions,    "pix_logging_timestamp");

    data.registerOption( logging_buffered,     fwoptions,    "pix_logging_buffered");

    logging_buffered_level->clear();
    logging_buffered_level->insertStringList(logLevels);
    data.registerOption( logging_buffered_level, fwoptions,
                         "pix_logging_buffered_level", logLevelMapping);

    data.registerOption( logging_console,      fwoptions,    "pix_logging_console");

    logging_console_level->clear();
    logging_console_level->insertStringList(logLevels);
    data.registerOption( logging_console_level,fwoptions,
                         "pix_logging_console_level", logLevelMapping);


/* page Options */

    fragguard->setEnabled(
        Resources::platform_res[platform]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_security_fragguard_supported") );

    route_dnat->setEnabled(
        Resources::platform_res[platform]->getResourceBool(
            "/FWBuilderResources/Target/options/"+vers+"/pix_route_dnat_supported") );

    data.registerOption( fragguard,           fwoptions,  "pix_fragguard"           );
    data.registerOption( route_dnat,          fwoptions,  "pix_route_dnat"          );

    data.registerOption( resetinbound,        fwoptions,  "pix_resetinbound"        );
    data.registerOption( resetoutside,        fwoptions,  "pix_resetoutside"        );

    data.registerOption( connection_timewait, fwoptions,  "pix_connection_timewait" );
    data.registerOption( floodguard,          fwoptions,  "pix_floodguard"          );
    data.registerOption( nodnsalias_inbound,  fwoptions,  "pix_nodnsalias_inbound"  );
    data.registerOption( nodnsalias_outbound, fwoptions,  "pix_nodnsalias_outbound" );

    data.registerOption( max_conns,           fwoptions,  "pix_max_conns"           );
    data.registerOption( emb_limit,           fwoptions,  "pix_emb_limit"           );

    data.loadAll();
    loadFixups();
    showFixups();
    scriptACLModeChanged();
}

/*
 * items in the switch_widget (QComboBox) are layed out as follows:
 *
 * Skip      - item 0
 * Enable    - item 1
 * Disable   - item 2
 *
 * values in the attribute in the FirewallOptions object are as follows:
 *
 * 0  - enable
 * 1  - disable
 * 2  - skip
 *
 * this is historical.
 */
static int fixupOpt2Widget[] = { 1, 2, 0 };
static int fixupWidget2Opt[] = { 2, 0, 1 };

int pixAdvancedDialog::translateFixupSwitchFromOptionToWidget(int o)
{
    return fixupOpt2Widget[o];
}

int pixAdvancedDialog::translateFixupSwitchFromWidgetToOption(int w)
{
    return fixupWidget2Opt[w];
}

void pixAdvancedDialog::enableAllFixups()  { changeAllFixups(0); }
void pixAdvancedDialog::disableAllFixups() { changeAllFixups(1); }
void pixAdvancedDialog::skipAllFixups()    { changeAllFixups(2); }

void pixAdvancedDialog::changeAllFixups(int state)
{
    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (!fi->active) continue;

        fi->switch_widget->setCurrentItem(
            translateFixupSwitchFromOptionToWidget(state) );            
    }
    showFixups();
}

void pixAdvancedDialog::loadFixups()
{
    FWOptions *options=(Firewall::cast(obj))->getOptionsObject();
    assert(options!=NULL);

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (!fi->active) continue;
        string f=options->getStr(fi->fwoption.latin1());
        if (!f.empty())
        {
// "0" means "fixup" or "enable" in a pop-down menu (historical)
// "1" means "no fixup" or "disable" in a pop-down menu (historical)
            int    sw;

            int    p1,p2;   // two port numbers
            string arg3n;   // option name
            bool   arg3v;   // option state (on/off)

            istringstream str(f);

            str >> sw >> p1 >> p2 >> arg3n >> arg3v;

            if (arg3n=="nil")    arg3n="";

            fi->switch_widget->setCurrentItem(
                translateFixupSwitchFromOptionToWidget(sw) );

/* if values are 0 in the data file, we stick with defaults. Defaults are preconfigured
 * in the GUI (via appropriate settings in pix.glade file */
            if (fi->arg1 && p1!=0) fi->arg1->setValue(p1);
            if (fi->arg2 && p2!=0) fi->arg2->setValue(p2);
            if (fi->arg3) fi->arg3->setChecked(arg3v);

        } else {
            fi->switch_widget->setCurrentItem(0);
        }
    }
}

void pixAdvancedDialog::saveFixups()
{
    FWOptions *options=(Firewall::cast(obj))->getOptionsObject();
    assert(options!=NULL);

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        string name=fi->fwoption.latin1();
        int sw=translateFixupSwitchFromWidgetToOption(
            fi->switch_widget->currentItem());

        int    p1  =(fi->arg1)?fi->arg1->value():0;
        int    p2  =(fi->arg2)?fi->arg2->value():0;
        string on  =(name=="ftp_fixup")?"strict":"nil";
        bool   ov  =(fi->arg3)?fi->arg3->isChecked():false;

        if (!fi->active) sw=2;

        ostringstream str;
        str << sw << " " << p1 << " " << p2 << " " << on << " " << int(ov);

        options->setStr( fi->fwoption.latin1() , str.str() );
    }
}

void pixAdvancedDialog::showFixups()
{
    string str;

    pix_generated_fixup->setText("");

    for (list<fixupControl>::iterator fi=allFixups.begin(); fi!=allFixups.end(); fi++)
    {
        if (!fi->active) continue;

        string name=fi->fwoption.latin1();
        int    sw=translateFixupSwitchFromWidgetToOption(
                    fi->switch_widget->currentItem());
        int    p1=(fi->arg1)?fi->arg1->value():0;
        int    p2=(fi->arg2)?fi->arg2->value():0;
        bool   op=(fi->arg3)?fi->arg3->isChecked():false;

        pix_generated_fixup->append( _printFixupCommand(fi->fixup_cmd,sw,p1,p2,op) );
    }
}

/*
 * This is a copy of the method  OSConfigurator_pix_os::_printFixupCommand
 */
QString pixAdvancedDialog::_printFixupCommand(const QString &fixup_name,
                                              int   sw,
                                              int   arg1, 
                                              int   arg2,
                                              bool  ov)
{
    ostringstream res;

    if (sw==0)
    {
        if (fixup_name=="dns")
        {
            if (arg1)
            {
                res << "fixup protocol "  << fixup_name;
                res << " maximum-length " << arg1;
                res << endl;
            }
        } else
        {
            if (fixup_name=="ftp")
            {
                if (arg1)
                {
                    res << "fixup protocol " << fixup_name << " ";
                    if (ov) res << "strict ";
                    res << arg1;
                    res << endl;
                }
            } else
            {
                if (fixup_name=="mgcp")
                {
                    if (arg1)
                    {
                        res << "fixup protocol " << fixup_name << " ";
                        res << arg1;
                        res << endl;
                    }
                    if (arg2) 
                    {
                        res << "fixup protocol " << fixup_name << " ";
                        res << arg2;
                        res << endl;
                    }
                } else 
                {
                    res << "fixup protocol " << fixup_name << " ";
                    if (arg1) res << arg1;
                    if (arg2 && arg1!=arg2) res << "-" << arg2;
                    res << endl;
                }
            }
        }
    }
    if (sw==1)
    {
        res << "no fixup protocol " << fixup_name;
        res << endl;
    }

    return res.str().c_str();
}

void pixAdvancedDialog::fixupCmdChanged()
{  
    showFixups();
}



/*
 * store all data in the object
 */
void pixAdvancedDialog::accept()
{
    FWOptions *options=(Firewall::cast(obj))->getOptionsObject();
    assert(options!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.saveAll();
    saveFixups();

//    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
//    pis->setCommand( installScript->text() );
//    pis->setArguments( installScriptArgs->text() );
    
    mgmt->setAddress( (Firewall::cast(obj))->getAddress() );


    if (syslogDeviceIdSupported)
    {
        QString s,v;
        s="";
        v="";
        if (syslog_device_id_hostname->isChecked())  s="hostname";
        if (syslog_device_id_interface->isChecked())
        {
            s="interface";
            v=syslog_device_id_interface_val->currentText();
        }
        if (syslog_device_id_string->isChecked())
        {
            s="string";
            v=syslog_device_id_string_val->text();
        }

        options->setStr("pix_syslog_device_id_opt",s.latin1());
        options->setStr("pix_syslog_device_id_val",v.latin1());
    }

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    pixAdvancedDialog_q::accept();
}

void pixAdvancedDialog::reject()
{
    pixAdvancedDialog_q::reject();
}

void pixAdvancedDialog::editProlog()
{
    SimpleTextEditor edt( pix_prolog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        pix_prolog_script->setText( edt.text() );
}

void pixAdvancedDialog::editEpilog()
{
    SimpleTextEditor edt( pix_epilog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        pix_epilog_script->setText( edt.text() );
}

void pixAdvancedDialog::setDefaultTimeoutValue(const QString &option)
{
    string platform = obj->getStr("platform");   // could be 'pix' or 'fwsm'
    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);
    
    string vers="version_"+obj->getStr("version");

    if (option=="uauth_abs" || option=="uauth_inact")
        data.setWidgetValue(option,
                        Resources::platform_res[platform]->getResourceBool(
     "/FWBuilderResources/Target/options/"+vers+"/timeouts/"+option.latin1()));
    else
        data.setWidgetValue(option,
                        Resources::platform_res[platform]->getResourceInt(
     "/FWBuilderResources/Target/options/"+vers+"/timeouts/"+option.latin1()));
}

void pixAdvancedDialog::defaultTimeouts()
{
    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);
    
    string vers="version_"+obj->getStr("version");

    setDefaultTimeoutValue("xlate_hh"       );
    setDefaultTimeoutValue("xlate_mm"       );
    setDefaultTimeoutValue("xlate_ss"       );
    setDefaultTimeoutValue("conn_hh"        );
    setDefaultTimeoutValue("conn_mm"        );
    setDefaultTimeoutValue("conn_ss"        );
    setDefaultTimeoutValue("udp_hh"         );
    setDefaultTimeoutValue("udp_mm"         );
    setDefaultTimeoutValue("udp_ss"         );
    setDefaultTimeoutValue("rpc_hh"         );
    setDefaultTimeoutValue("rpc_mm"         );
    setDefaultTimeoutValue("rpc_ss"         );
    setDefaultTimeoutValue("h323_hh"        );
    setDefaultTimeoutValue("h323_mm"        );
    setDefaultTimeoutValue("h323_ss"        );
    setDefaultTimeoutValue("sip_hh"         );
    setDefaultTimeoutValue("sip_mm"         );
    setDefaultTimeoutValue("sip_ss"         );
    setDefaultTimeoutValue("sip_media_hh"   );
    setDefaultTimeoutValue("sip_media_mm"   );
    setDefaultTimeoutValue("sip_media_ss"   );
    setDefaultTimeoutValue("half-closed_hh" );
    setDefaultTimeoutValue("half-closed_mm" );
    setDefaultTimeoutValue("half-closed_ss" );
    setDefaultTimeoutValue("uauth_hh"       );
    setDefaultTimeoutValue("uauth_mm"       );
    setDefaultTimeoutValue("uauth_abs"      );
    setDefaultTimeoutValue("uauth_inact"    );

    setDefaultTimeoutValue("telnet_timeout" );
    setDefaultTimeoutValue("ssh_timeout"    );
}

void pixAdvancedDialog::regenerateFixups()
{
}

void pixAdvancedDialog::scriptACLModeChanged()
{
    pix_acl_temp_lbl->setEnabled(pix_acl_substitution->isChecked());
    pix_acl_temp_addr->setEnabled(pix_acl_substitution->isChecked());
}



