/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: platforms.cpp,v 1.12.4.2 2005/09/13 04:55:41 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include "platforms.h"

#include <qobject.h>
#include <qstringlist.h>

#include "fwbuilder/Firewall.h"
#include "fwbuilder/FWOptions.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"

using namespace std;
using namespace libfwbuilder;


bool isUsingNetZone(Firewall *fw)
{
    string platform=fw->getStr("platform");
    return (platform=="pix" || platform=="fwsm");
}

bool isDefaultOptions(FWOptions *opt)
{
    bool res=false;
    FWObject *p;

    p=opt;
    do {  p=p->getParent();
    } while ( p!=NULL && Firewall::cast(p)==NULL );

    assert(p!=NULL);

    QString platform = p->getStr("platform").c_str();

    if (PolicyRuleOptions::isA(opt))
    {
	if (platform=="ipfilter") 
        {
	    res= ( ! opt->getBool("log_or_block") && 
		   ! opt->getBool("log_body")     &&
		   ! opt->getBool("log_first")    &&
		   ! opt->getBool("icmp_as_dest") &&
		   opt->getStr("action_on_reject").empty() );
	}

	if (platform=="iptables") 
        {
	    res= ( opt->getStr("log_prefix").empty()       && 
                   opt->getStr("log_level").empty()        && 
		   opt->getStr("action_on_reject").empty() && 
		   opt->getStr("rule_name_accounting").empty() && 
		   opt->getInt("limit_value")<=0  &&
		   opt->getInt("limit_burst")<=0  &&
		   ! opt->getBool("stateless") &&
                   ! opt->getBool("firewall_is_part_of_any_and_networks"));
	}

	if (platform=="pix" || platform=="fwsm") 
        {
            res= ( opt->getStr("log_level").empty()        && 
                   opt->getInt("log_interval")<=0          &&
                   ! opt->getBool("disable_logging_for_this_rule") );
	}

	if (platform=="pf") 
        {
	    res= ( opt->getStr("log_prefix").empty()       && 
                   opt->getStr("action_on_reject").empty() && 
		   ! opt->getBool("stateless")             &&
                   opt->getInt("pf_rule_max_state")<=0     &&
                   ! opt->getBool("pf_source_tracking") );
	}

	if (platform=="ipf") 
        {
	    res= ( opt->getStr("ipf_log_facility").empty()       && 
                   opt->getStr("log_level").empty()        && 
                   opt->getStr("action_on_reject").empty() && 
		   ! opt->getBool("stateless") &&
		   ! opt->getBool("ipf_keep_frags") &&
                   ! opt->getBool("ipf_return_icmp_as_dest") );
	}

	if (platform=="ipfw") 
        {
	    res= ( opt->getStr("action_on_reject").empty() && 
		   ! opt->getBool("stateless") );
	}

    }
    return res; 
}

QMap<QString,QString> getVersionsForPlatform(const QString &platform)
{
    QMap<QString,QString> res;

    if (platform=="iptables")
    {
        res[""]         = QObject::tr("- any -");
        res["lt_1.2.6"] = QObject::tr("1.2.5 or earlier");
        res["ge_1.2.6"] = QObject::tr("1.2.6 to 1.2.8");
        res["1.2.9"]    = QObject::tr("1.2.9 or later");
    } else
    {
        if (platform=="pix" || platform=="fwsm") 
        {
            QString lst=Resources::platform_res[platform]->getResourceStr(
                "/FWBuilderResources/Target/versions").c_str();

            QStringList ll=QStringList::split(',', lst);

            for (QStringList::iterator i=ll.begin(); i!=ll.end(); ++i)
                res.insert( *i, *i );
        } else
        {
            if (platform=="pf") 
            {
                res[""]         = QObject::tr("- any -");
/* add pf versions here */
            } else
            {
                if (platform=="ipf") 
                {
                    res[""]         = QObject::tr("- any -");
/* add ipf versions here */
                } else
                {
                    if (platform=="ipfw") 
                    {
                        res[""]         = QObject::tr("- any -");
/* add ipfw versions here */
                    } else
                        res[""]         = QObject::tr("- any -");
                }
            }
        }
    }

    return res;
}

/* currently we return the same list for all platforms */
QStringList getLogLevels(const QString &platform)
{
    QStringList logLevels;

    logLevels.push_back("");
    logLevels.push_back("");
    logLevels.push_back(QObject::tr( "alert"  ));
    logLevels.push_back(             "alert"  );
    logLevels.push_back(QObject::tr( "crit"   ));
    logLevels.push_back(             "crit"   );
    logLevels.push_back(QObject::tr( "error"  ));
    logLevels.push_back(             "error"  );
    logLevels.push_back(QObject::tr( "warning"));
    logLevels.push_back(             "warning");
    logLevels.push_back(QObject::tr( "notice" ));
    logLevels.push_back(             "notice" );
    logLevels.push_back(QObject::tr( "info"   ));
    logLevels.push_back(             "info"   );
    logLevels.push_back(QObject::tr( "debug"  ));
    logLevels.push_back(             "debug"  );

    return logLevels;
}

QStringList getLogFacilities(const QString &platform)
{
    QStringList logFacilities;

    logFacilities.push_back("");
    logFacilities.push_back("");
    logFacilities.push_back(QObject::tr( "kern"   ));
    logFacilities.push_back(             "kern"   );
    logFacilities.push_back(QObject::tr( "user"   ));
    logFacilities.push_back(             "user"   );
    logFacilities.push_back(QObject::tr( "mail"   ));
    logFacilities.push_back(             "mail"   );
    logFacilities.push_back(QObject::tr( "daemon" ));
    logFacilities.push_back(             "daemon" );
    logFacilities.push_back(QObject::tr( "auth"   ));
    logFacilities.push_back(             "auth"   );
    logFacilities.push_back(QObject::tr( "syslog" ));
    logFacilities.push_back(             "syslog" );
    logFacilities.push_back(QObject::tr( "lpr"    ));
    logFacilities.push_back(             "lpr"    );
    logFacilities.push_back(QObject::tr( "news"   ));
    logFacilities.push_back(             "news"   );
    logFacilities.push_back(QObject::tr( "uucp"   ));
    logFacilities.push_back(             "uucp"   );
    logFacilities.push_back(QObject::tr( "cron"   ));
    logFacilities.push_back(             "cron"   );
    logFacilities.push_back(QObject::tr( "authpriv" ));
    logFacilities.push_back(             "authpriv");
    logFacilities.push_back(QObject::tr( "ftp"    ));
    logFacilities.push_back(             "ftp"    );
    logFacilities.push_back(QObject::tr( "local0" ));
    logFacilities.push_back(             "local0" );
    logFacilities.push_back(QObject::tr( "local1" ));
    logFacilities.push_back(             "local1" );
    logFacilities.push_back(QObject::tr( "local2" ));
    logFacilities.push_back(             "local2" );
    logFacilities.push_back(QObject::tr( "local3" ));
    logFacilities.push_back(             "local3" );
    logFacilities.push_back(QObject::tr( "local4" ));
    logFacilities.push_back(             "local4" );
    logFacilities.push_back(QObject::tr( "local5" ));
    logFacilities.push_back(             "local5" );
    logFacilities.push_back(QObject::tr( "local6" ));
    logFacilities.push_back(             "local6" );
    logFacilities.push_back(QObject::tr( "local7" ));
    logFacilities.push_back(             "local7" );
    
    return logFacilities;
}
QStringList getActionsOnReject(const QString &platform)
{
    QStringList slm;
    
    slm.push_back("");
    slm.push_back("");
    slm.push_back(QObject::tr("ICMP admin prohibited"));
    slm.push_back("ICMP admin prohibited");
    slm.push_back(QObject::tr("ICMP host prohibited"));
    slm.push_back("ICMP host prohibited");
    slm.push_back(QObject::tr("ICMP host unreachable"));
    slm.push_back("ICMP host unreachable");
    slm.push_back(QObject::tr("ICMP net prohibited"));
    slm.push_back("ICMP net prohibited");
    slm.push_back(QObject::tr("ICMP net unreachable"));
    slm.push_back("ICMP net unreachable");
    slm.push_back(QObject::tr("ICMP port unreachable"));
    slm.push_back("ICMP port unreachable");
    slm.push_back(QObject::tr("ICMP protocol unreachable"));
    slm.push_back("ICMP protocol unreachable");
    slm.push_back(QObject::tr("TCP RST"));
    slm.push_back("TCP RST");

    return slm;
}
QStringList getPrologPlaces(const QString &platform)
{
    QStringList slm;
    
    slm.push_back(QObject::tr("on top of the script"));
    slm.push_back("top");
    slm.push_back(QObject::tr("after interface configuration"));
    slm.push_back("after_interfaces");
    slm.push_back(QObject::tr("after policy reset"));
    slm.push_back("after_flush");

    return slm;
}

QStringList getLimitSuffixes(const QString &platform)
{
    QStringList slm;
    
    slm.push_back("");
    slm.push_back("");
    slm.push_back(QObject::tr("/day"));
    slm.push_back("/day");
    slm.push_back(QObject::tr("/hour"));
    slm.push_back("/hour");
    slm.push_back(QObject::tr("/minute"));
    slm.push_back("/minute");
    slm.push_back(QObject::tr("/second"));
    slm.push_back("/second");

    return slm;
}


QStringList getScreenNames(QStringList sl)
{
    QStringList res;
    
    for(    QStringList::iterator it = sl.begin(); 
            it!=sl.end();
            ++it,++it)
    {
        res.push_back(*it);
    }
    return res;
}

