
#include "global.h"

#include "InstallFirewallViewItem.h"

#include "fwbuilder/Firewall.h"

#include <qfont.h>
#include <qpainter.h>

using namespace std;
using namespace libfwbuilder;

void InstallFirewallViewItem::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
    if (!p) return;
    QFont f;
    QColorGroup c=cg;

    int statCol=(showLastTimes)?4:1;
    
    if (text(statCol).contains("..."))
    {
        p->save();
        f=p->font();
        f.setBold (true);
        p->setFont(f); 
        QListViewItem::paintCell(p,cg,column,width,align);
        p->restore();
        return;
    } else if (text(statCol)==QObject::tr("Failure"))
    {
        p->save();
        p->setFont(f);
        c.setBrush(QColorGroup::Text,Qt::red);
        QListViewItem::paintCell(p,c,column,width,align);
        p->restore();
        return;
    }
    if (column==statCol)
    {
        f=p->font();
        f.setBold (true);
        if (text(statCol)==QObject::tr("Success"))
        {
            p->save();
            p->setFont(f);
            c.setBrush(QColorGroup::Text,Qt::green);
            QListViewItem::paintCell(p,c,column,width,align);
            p->restore();
        } else
        {
            QListViewItem::paintCell(p,cg,column,width,align);
        }
    }
    else
    {
        QListViewItem::paintCell(p,cg,column,width,align);
    }
}

