/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: PrintingProgressDialog.cpp,v 1.3 2005/01/27 09:35:53 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "PrintingProgressDialog.h"

#include <qstring.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qapplication.h>
#include <qeventloop.h>
#include <qpushbutton.h>

PrintingProgressDialog::PrintingProgressDialog(QWidget *parent,QPrinter *p,int nPages,bool disableCancel) :
    printingProgressDialog_q(parent)    
{
    printer=p;
    setNPages(nPages);
    text->setText("");
    if (disableCancel) Cancel->hide();
}

void PrintingProgressDialog::setCurrentPageNo(int n)
{
    if (totalPages)
        text->setText(tr( "Printing (page %1/%2)" ).arg(n).arg(totalPages));
    else
        text->setText(tr( "Printing page %1" ).arg(n) );

    progressBar->setProgress(n);

    QApplication::eventLoop()->processEvents(QEventLoop::AllEvents,1);
}

void PrintingProgressDialog::genericProgressIndicator(int n,const QString &txt)
{
    text->setText(txt);
    progressBar->setProgress(n,totalPages);

    QApplication::eventLoop()->processEvents(QEventLoop::ExcludeUserInput,1);
}

void PrintingProgressDialog::abortPrinting()
{
    text->setText( tr("Aborting print operation") );
    printer->abort();
}

void PrintingProgressDialog::setNPages(int n)
{
    totalPages=n;
    progressBar->setTotalSteps(totalPages);
}

