/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ipfwAdvancedDialog.cpp,v 1.13 2007/01/06 22:03:25 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "platforms.h"

#include "ipfwAdvancedDialog.h"
#include "SimpleTextEditor.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>
#include <qtextview.h>


using namespace std;
using namespace libfwbuilder;


ipfwAdvancedDialog::ipfwAdvancedDialog(QWidget *parent,FWObject *o)
    : ipfwAdvancedDialog_q(parent)
{
    obj=o;

    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    if (fwbdebug)
        qDebug("%s",Resources::getTargetOptionStr(
                   obj->getStr("host_OS"),"user_can_change_install_dir").c_str());

    if (!Resources::getTargetOptionBool(
            obj->getStr("host_OS"),"user_can_change_install_dir"))
    {
        ipfw_fw_dir->setEnabled(false);
        fwopt->setStr("firewall_dir","");
    }

    if (fwopt->getStr("add_check_state_rule").empty())
        fwopt->setBool("add_check_state_rule",true);

    data.registerOption( ipfw_add_check_state_rule  ,fwopt, "add_check_state_rule");
    data.registerOption( ipfw_check_shadowing       ,fwopt, "check_shading"       );
    data.registerOption( ipfw_ignore_empty_groups   ,fwopt, "ignore_empty_groups" );
    data.registerOption( ipfw_fw_dir                ,fwopt, "firewall_dir"    );
    data.registerOption( ipfw_user                  ,fwopt, "admUser"         );
    data.registerOption( altAddress                 ,fwopt, "altAddress"      );
    data.registerOption( sshArgs                    ,fwopt, "sshArgs"         );
    data.registerOption( activationCmd              ,fwopt, "activationCmd"   );

    data.registerOption( ipfw_manage_virtual_addr   ,fwopt, "manage_virtual_addr"  );
    data.registerOption( ipfw_configure_interfaces  ,fwopt, "configure_interfaces" );
    data.registerOption( ipfw_debug                 ,fwopt, "debug"           );

    data.registerOption( compiler                   ,fwopt, "compiler" );
    data.registerOption( compilerArgs               ,fwopt, "cmdline"  );
    data.registerOption( outputFileName       , fwopt,  "output_file"  );

    data.registerOption( mgmt_ssh             , fwopt,  "mgmt_ssh"  );
    data.registerOption( mgmt_addr            , fwopt,  "mgmt_addr" );

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

/* page "Prolog/Epilog" */
    data.registerOption( prolog_script    , fwopt,
                         "prolog_script"  );

    data.registerOption( epilog_script    , fwopt,
                         "epilog_script"  );



    data.loadAll();
}

/*
 * store all data in the object
 */
void ipfwAdvancedDialog::accept()
{
    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.saveAll();

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    om->updateLastModifiedTimestampForAllFirewalls(obj);
    ipfwAdvancedDialog_q::accept();
}

void ipfwAdvancedDialog::reject()
{
    ipfwAdvancedDialog_q::reject();
}

void ipfwAdvancedDialog::editProlog()
{
    SimpleTextEditor edt(this,
                         prolog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        prolog_script->setText( edt.text() );
}

void ipfwAdvancedDialog::editEpilog()
{
    SimpleTextEditor edt(this,
                         epilog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        epilog_script->setText( edt.text() );
}




