###The only customizable variables are prefix and kversion.
###If you have used a custom tug in the vesrion of your
###kernel rpm, you may need to adjust mversion as well.

###This package IS relocatable (change prefix to relocate).

%define prefix /usr/local

#Distribution vendors who would like to integrate the package should
#probably use: %define prefix /usr

#WARNING!!! This package must be compiled for the the same kernel that will
#run on the target machine. This implies the same kernel version and the
#same kernel configuration. Thus, the binary packages can be provided by
#distribution vendors only for their stock distribution kernels. If you use
#a custom configured kernel, you must rebuild this package. To protect the
#innocent, we define kversion and make the resulting package dependable
#on the specific version of the kernel.

#Define your kernel version here. 
%define kversion 2.2.14
%define mversion %{kversion}

#Another example for the above: %define kversion 2.2.14-SMP

%define name kernel-i2c
%define ver 2.5.0
Summary: Updated i2c drivers
Name: %{name}
Version: %{ver}
Release: 1
Group: Base/Kernel

#Latest RedHat distributions define a different Group: Group: System Environment/Kernel

Copyright: GPL
Source0: http://www.lm-sensors.nu/lm-sensors/archive/i2c-%{ver}.tar.gz
Buildroot: /var/tmp/%{name}-%{ver}
Docdir: %{prefix}/doc
Url: http://www.netroedge.com/~lm78/
Requires: kernel = %{kversion}
#The new i2c code has been integrated into kernel 2.3.38
Conflicts: kernel >= 2.3.38

#For officially distributed packages, please sign below
#Packager: Lm_sensors Group <lm78@stimpy.netroedge.com>

%description
This package contains the new i2c code and several bus drivers (algorithm
and adapter drivers). The chip drivers are not included in this package.
Most of the chip and bus drivers as well as additional basic code
for SMBus emulation over i2c are included in the lm_sensors package.
This package is required if you want to install programs which use the new
i2c implementation. Lm_sensors and video4linux (latest versions of bttv
driver) require the new i2c code.

%prep
%setup -n i2c-%{ver}

%build
#even for non-SMP systems parallel make will build faster
make -j4

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT LINUX_INCLUDE_DIR=%{prefix}/include/linux 

%post
depmod -a || /bin/true

%postun
depmod -a || /bin/true

%files
%dir /lib/modules/%{mversion}
%dir /lib/modules/%{mversion}/misc
/lib/modules/%{mversion}/misc/*
%dir %{prefix}/include/linux
%{prefix}/include/linux/*.h
%doc doc/* IMPORTANT_CHANGES INSTALL README TODO

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/i2c-%{ver}
